/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import java.util.Objects;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.CouldNotCreateEntityDuringImportException;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.CouldNotParseEntityDuringImportException;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.PivotImportAttachmentMaxSizeExceededException;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.PivotImportAttachmentTypeNotAllowedException;
import org.squashtest.tm.service.internal.dto.projectimporter.ImportWarningEntry;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentPivotType;

public final class PivotFormatLoggerHelper {
    public static final String CALLED_TEST_CASE = "called test case";
    public static final String CALLED_TEST_CASES = "called test cases";
    public static final String CAMPAIGN = "campaign";
    public static final String CAMPAIGNS = "campaigns";
    public static final String CAMPAIGN_FOLDER = "campaign folder";
    public static final String CAMPAIGN_FOLDERS = "campaign folders";
    public static final String CUSTOM_FIELD = "custom field";
    public static final String CUSTOM_FIELDS = "custom fields";
    public static final String EXECUTION = "execution";
    public static final String EXECUTIONS = "executions";
    public static final String INFO_LIST = "info list";
    public static final String INFO_LISTS = "info lists";
    public static final String ITERATION = "iteration";
    public static final String ITERATIONS = "iterations";
    public static final String MILESTONE = "milestone";
    public static final String MILESTONES = "milestones";
    public static final String PROJECT = "project";
    public static final String PROJECTS = "projects";
    public static final String REQUIREMENT = "requirement";
    public static final String REQUIREMENTS = "requirements";
    public static final String REQUIREMENT_LINK = "requirement link";
    public static final String REQUIREMENTS_LINK = "requirements link";
    public static final String REQUIREMENT_VERSION = "requirement_version";
    public static final String REQUIREMENT_FOLDER = "requirement folder";
    public static final String REQUIREMENT_FOLDERS = "requirement folders";
    public static final String SERVER = "server";
    public static final String SERVERS = "servers";
    public static final String SPRINTS = "sprints";
    public static final String SPRINT = "sprint";
    public static final String TEST_CASE = "test case";
    public static final String TEST_CASES = "test cases";
    public static final String TEST_CASE_FOLDER = "test case folder";
    public static final String TEST_CASE_FOLDERS = "test case folders";
    public static final String TEST_STEP = "test step";
    public static final String TEST_SUITE = "test suite";
    public static final String TEST_SUITES = "test suites";

    private PivotFormatLoggerHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void logImportStartedForEntitiesKind(Logger logger, String entitiesKind, PivotFormatImport pivotFormatImport) {
        logger.info("Starting to import {} for import with id: {}", new Object[]{entitiesKind, pivotFormatImport.getId()});
    }

    public static void logImportSuccessForEntitiesKind(Logger logger, String entitiesKind, PivotFormatImport pivotFormatImport) {
        logger.info("Import id: {} - Successfully imported {} from json file", new Object[]{pivotFormatImport.getId(), entitiesKind});
    }

    public static void logImportFailureForEntitiesKind(Logger logger, String entitiesKind, PivotFormatImport pivotFormatImport) {
        logger.error("Import id: {} - Failed to import {} from json file", new Object[]{pivotFormatImport.getId(), entitiesKind});
    }

    public static void logParsingSuccessForEntity(Logger logger, String entityKind, String internalId) {
        logger.debug("The {} and internal id {} was successfully parsed", new Object[]{entityKind, internalId});
    }

    public static void handleParsingErrorForEntity(Logger logger, String entityKind, String internalId, Exception e) {
        String message = Objects.nonNull(internalId) ? String.format("Failed to parse %s with internal id : %s", entityKind, internalId) : String.format("Failed to parse %s.", entityKind);
        logger.error(message, new Object[0]);
        throw new CouldNotParseEntityDuringImportException(message, (Throwable)e);
    }

    public static void logEntityCreationStarted(Logger logger, String entityKind, String internalId, PivotFormatImport pivotFormatImport) {
        logger.info("Import id: {} - Creating {} with internal id {}", new Object[]{pivotFormatImport.getId(), entityKind, internalId});
    }

    public static void logEntityCreatedSuccessfully(Logger logger, String entityKind, String entityName, String internalId, PivotFormatImport pivotFormatImport) {
        logger.info("Import id: {} - Successfully created {} named \"{}\" with internal id {}", new Object[]{pivotFormatImport.getId(), entityKind, entityName, internalId});
    }

    public static void logEntityCreatedSuccessfully(Logger logger, String entityKind, String internalId, PivotFormatImport pivotFormatImport) {
        logger.info("Import id: {} - Successfully created {} with internal id {}", new Object[]{pivotFormatImport.getId(), entityKind, internalId});
    }

    public static void handleEntityCreationFailed(Logger logger, String entityKind, String entityName, String internalId, PivotFormatImport pivotFormatImport, Exception e) {
        String message = String.format("Import id: %s - Failed to create %s named \"%s\" with internal id %s", pivotFormatImport.getId(), entityKind, entityName, internalId);
        logger.error(message, new Object[0]);
        throw new CouldNotCreateEntityDuringImportException(message, (Throwable)e);
    }

    public static void handleEntityCreationFailed(Logger logger, String entityKind, String internalId, PivotFormatImport pivotFormatImport, Exception e) {
        String message = String.format("Import id: %s - Failed to create %s with internal id %s", pivotFormatImport.getId(), entityKind, internalId);
        logger.error(message, new Object[0]);
        throw new CouldNotCreateEntityDuringImportException(message, (Throwable)e);
    }

    public static String getFolderEntityKindNameFromJsonFile(JsonImportFile jsonFileName, boolean isPlural) {
        return switch (jsonFileName) {
            case JsonImportFile.TEST_CASE_FOLDERS -> isPlural ? TEST_CASE_FOLDERS : TEST_CASE_FOLDER;
            case JsonImportFile.REQUIREMENT_FOLDERS -> isPlural ? REQUIREMENT_FOLDERS : REQUIREMENT_FOLDER;
            case JsonImportFile.CAMPAIGN_FOLDERS_AND_SPRINT_GROUPS -> isPlural ? CAMPAIGN_FOLDERS : CAMPAIGN_FOLDER;
            default -> throw new IllegalArgumentException("Unknown json import file name: " + String.valueOf((Object)jsonFileName));
        };
    }

    public static void handleAttachmentNotFound(Logger logger, String attachmentPath, EntityType holderType, String holderPivotId, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        AttachmentPivotType attachmentPivotType = AttachmentPivotType.getAttachmentPivotTypeFromEntityType(holderType);
        String message = String.format("Import %s - Could not find attachment for %s with internal ID %s at the following path: %s ", pivotFormatImport.getId(), attachmentPivotType.getSimpleName(), holderPivotId, attachmentPath);
        logger.error(message, new Object[0]);
        pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.attachmentNotFound(holderType, attachmentPath, pivotImportMetadata.getCurrentImportFile()));
    }

    public static void handleAttachmentTypeNotAllowed(Logger logger, String fileType, String fileName, EntityType holderType, String holderPivotId, PivotFormatImport pivotFormatImport) {
        AttachmentPivotType attachmentPivotType = AttachmentPivotType.getAttachmentPivotTypeFromEntityType(holderType);
        String message = String.format("Import %s - Could not add attachment for %s with internal ID %s. The extension \"%s\" of file \"%s\" is not allowed for attachment import.", pivotFormatImport.getId(), attachmentPivotType.getSimpleName(), holderPivotId, fileType, fileName);
        logger.error(message, new Object[0]);
        throw new PivotImportAttachmentTypeNotAllowedException(message);
    }

    public static void handleAttachmentMaxSizeExceeded(Logger logger, String fileName, Long fileSize, Long maxAllowedSize, EntityType holderType, String holderPivotId, PivotFormatImport pivotFormatImport) {
        AttachmentPivotType attachmentPivotType = AttachmentPivotType.getAttachmentPivotTypeFromEntityType(holderType);
        String message = String.format("Import %s - Could not add attachment for %s with internal ID %s. The attachment \"%s\" has exceeded size limit (Max allowed size: %s bytes). File size: %s bytes", pivotFormatImport.getId(), attachmentPivotType.getSimpleName(), holderPivotId, fileName, maxAllowedSize, fileSize);
        logger.error(message, new Object[0]);
        throw new PivotImportAttachmentMaxSizeExceededException(message);
    }

    public static void logEntitiesAlreadyExistsInSquash(Logger logger, String entityName, String pivotId, String label, PivotFormatImport pivotFormatImport) {
        logger.warn("Import id {} - {} \"{}\" with internal id {} already exists in SquashTM. Import will use the existing {} for entity bindings", new Object[]{pivotFormatImport.getId(), entityName, pivotId, label});
    }
}

