/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.RequirementLibraryNode;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.RequirementLinkTypePivot;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.RequirementLinkDao;

@Repository
public class RequirementLinkDaoImpl
extends AbstractPivotDao<RequirementLinkTypePivot>
implements RequirementLinkDao {
    public RequirementLinkDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService) {
        super(dsl, adminPivotConverterService);
    }

    @Override
    public boolean hasRequirementLinkByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from(this.getRequirementLinkTableByProjectId(projectId)));
    }

    private Table<Record1<Long>> getRequirementLinkTableByProjectId(Long projectId) {
        RequirementVersion relatedVersion = Tables.REQUIREMENT_VERSION.as("relatedVersion");
        RequirementLibraryNode relatedRequirement = Tables.REQUIREMENT_LIBRARY_NODE.as("relatedRequirement");
        return this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION_LINK.LINK_TYPE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_LINK).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).join((TableLike)relatedVersion).on(relatedVersion.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID)).join((TableLike)relatedRequirement).on(relatedRequirement.RLN_ID.eq((Field)relatedVersion.REQUIREMENT_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(relatedRequirement.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_LINK.LINK_TYPE_ID}).asTable();
    }

    @Override
    public void getRequirementLinkByProjectId(Long projectId, Consumer<RequirementLinkTypePivot> writingToJsonConsumer) {
        Table<Record1<Long>> requirementLinkTable = this.getRequirementLinkTableByProjectId(projectId);
        ResultQuery requirementLinkQuery = this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION_LINK_TYPE.TYPE_ID, (SelectField)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_1, (SelectField)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_2, (SelectField)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_1_CODE, (SelectField)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_2_CODE).from((TableLike)Tables.REQUIREMENT_VERSION_LINK_TYPE).join(requirementLinkTable).on(Tables.REQUIREMENT_VERSION_LINK_TYPE.TYPE_ID.eq(requirementLinkTable.field((Field)Tables.REQUIREMENT_VERSION_LINK.LINK_TYPE_ID))).fetchSize(50);
        this.convertRecordAndWritingPivot(requirementLinkQuery, projectId, EntityBindingField.REQUIREMENT_LINK_TYPE, writingToJsonConsumer, attachmentPivot -> {});
    }

    @Override
    protected RequirementLinkTypePivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        return this.adminPivotConverterService.recordToRequirementLinkTypePivot(record);
    }

    @Override
    protected void fillPivotObject(RequirementLinkTypePivot pivotObject, Record record) {
    }

    @Override
    protected List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of();
    }

    @Override
    protected void appendSubElementsToPivotObject(RequirementLinkTypePivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
    }
}

