/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.ServerPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.ServerPivotDao;

@Service
public class ServerPivotExporterServiceImpl
implements ServerPivotExporterService {
    private final ServerPivotDao serverPivotDao;
    private final PivotFileManager pivotFileManager;

    public ServerPivotExporterServiceImpl(ServerPivotDao serverPivotDao, PivotFileManager pivotFileManager) {
        this.serverPivotDao = serverPivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateServerJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (!this.serverPivotDao.hasServerBindingByProjectId(projectId)) {
            return;
        }
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleSever((JsonGenerator)jsonGenerator, projectId), JsonImportFile.SERVERS, archive);
    }

    private void handleSever(JsonGenerator jsonGenerator, Long projectId) {
        this.serverPivotDao.getServerByProjectId(projectId, serversPivot -> this.pivotFileManager.writePivotObject(serversPivot, jsonGenerator, JsonImportFile.SERVERS));
    }
}

