/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportReportBinding;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.domain.users.preferences.WorkspaceDashboardContentValues;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.repository.CustomReportChartBindingDao;
import org.squashtest.tm.service.internal.repository.CustomReportDashboardDao;
import org.squashtest.tm.service.internal.repository.CustomReportLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.CustomReportReportBindingDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.PartyPreferenceService;

@Transactional
@Service(value="org.squashtest.tm.service.customreport.CustomReportDashboardService")
public class CustomReportDashboardServiceImpl
implements CustomReportDashboardService {
    private static final String ROLE_ADMIN = "ROLE_ADMIN";
    @Inject
    private CustomReportDashboardDao customReportDashboardDao;
    @Inject
    private CustomReportChartBindingDao chartBindingDao;
    @Inject
    private CustomReportReportBindingDao reportBindingDao;
    @Inject
    private CustomReportLibraryNodeService crlnService;
    @PersistenceContext
    private EntityManager em;
    @Inject
    protected PermissionEvaluationService permissionService;
    @Inject
    private PartyPreferenceService partyPreferenceService;
    @Inject
    private CustomReportLibraryNodeDao customReportLibraryNodeDao;

    @Override
    public CustomReportDashboard findById(Long id) {
        return (CustomReportDashboard)this.customReportDashboardDao.getReferenceById(id);
    }

    @Override
    @PreAuthorize(value="hasPermission(#dashboardEntityId, 'org.squashtest.tm.domain.customreport.CustomReportDashboard' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void bindReport(CustomReportReportBinding newBinding, Long reportDefinitionNodeId, Long dashboardEntityId) {
        ReportDefinition reportDefinition = this.crlnService.findReportDefinitionByNodeId(reportDefinitionNodeId);
        CustomReportDashboard dashboard = (CustomReportDashboard)this.em.find(CustomReportDashboard.class, (Object)dashboardEntityId);
        newBinding.setReport(reportDefinition);
        newBinding.setDashboard(dashboard);
        this.reportBindingDao.save(newBinding);
        this.em.flush();
    }

    @Override
    @PreAuthorize(value="hasPermission(#dashboardEntityId, 'org.squashtest.tm.domain.customreport.CustomReportDashboard' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void bindChart(CustomReportChartBinding newBinding, Long chartDefinitionNodeId, Long dashboardEntityId) {
        ChartDefinition chartDefinition = this.crlnService.findChartDefinitionByNodeId(chartDefinitionNodeId);
        CustomReportDashboard dashboard = (CustomReportDashboard)this.em.find(CustomReportDashboard.class, (Object)dashboardEntityId);
        newBinding.setChart(chartDefinition);
        newBinding.setDashboard(dashboard);
        this.chartBindingDao.save(newBinding);
        this.em.flush();
    }

    @Override
    public void updateGridPosition(List<CustomReportChartBinding> chartBindings, List<CustomReportReportBinding> reportBindings) {
        for (CustomReportChartBinding chartBinding : chartBindings) {
            this.updateChartBinding(chartBinding);
        }
        for (CustomReportReportBinding reportBinding : reportBindings) {
            this.updateReportBinding(reportBinding);
        }
    }

    private void updateChartBinding(CustomReportChartBinding transientBinding) {
        CustomReportChartBinding persistedBinding = (CustomReportChartBinding)this.chartBindingDao.getReferenceById(transientBinding.getId());
        if (this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, "WRITE", persistedBinding.getDashboard()) && persistedBinding.hasMoved(transientBinding)) {
            persistedBinding.move(transientBinding);
        }
    }

    private void updateReportBinding(CustomReportReportBinding transientBinding) {
        CustomReportReportBinding persistedBinding = (CustomReportReportBinding)this.reportBindingDao.getReferenceById(transientBinding.getId());
        if (this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, "WRITE", persistedBinding.getDashboard()) && persistedBinding.hasMoved(transientBinding)) {
            persistedBinding.move(transientBinding);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'org.squashtest.tm.domain.customreport.CustomReportChartBinding' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void unbindChart(Long id) {
        Optional optBinding = this.chartBindingDao.findById(id);
        if (optBinding.isPresent()) {
            this.chartBindingDao.delete((CustomReportChartBinding)optBinding.get());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'org.squashtest.tm.domain.customreport.CustomReportReportBinding' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void unbindReport(Long id) {
        Optional optBinding = this.reportBindingDao.findById(id);
        if (optBinding.isPresent()) {
            this.reportBindingDao.delete((CustomReportReportBinding)optBinding.get());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#bindingId, 'org.squashtest.tm.domain.customreport.CustomReportChartBinding' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public CustomReportChartBinding changeBindedChart(long bindingId, long chartNodeId) {
        CustomReportChartBinding chartBinding = (CustomReportChartBinding)this.chartBindingDao.getReferenceById(bindingId);
        ChartDefinition chartDefinition = this.crlnService.findChartDefinitionByNodeId(chartNodeId);
        chartBinding.setChart(chartDefinition);
        return chartBinding;
    }

    @Override
    @PreAuthorize(value="hasPermission(#bindingId, 'org.squashtest.tm.domain.customreport.CustomReportReportBinding' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public CustomReportReportBinding changeBindedReport(long bindingId, long reportNodeId) {
        CustomReportReportBinding reportBinding = (CustomReportReportBinding)this.reportBindingDao.getReferenceById(bindingId);
        ReportDefinition reportDefinition = this.crlnService.findReportDefinitionByNodeId(reportNodeId);
        reportBinding.setReport(reportDefinition);
        return reportBinding;
    }

    @Override
    public void chooseFavoriteDashboardForCurrentUser(Workspace workspace, long nodeId) {
        CustomReportLibraryNode node = this.crlnService.findCustomReportLibraryNodeById(nodeId);
        if (node != null) {
            String preferenceKey = this.getChooseFavoriteDashboardPreferenceKey(workspace);
            this.partyPreferenceService.addOrUpdatePreferenceForCurrentUser(preferenceKey, String.valueOf(node.getId()));
        }
    }

    private String getChooseFavoriteDashboardPreferenceKey(Workspace workspace) {
        return switch (workspace) {
            case Workspace.HOME -> CorePartyPreference.FAVORITE_DASHBOARD_HOME.getPreferenceKey();
            case Workspace.REQUIREMENT -> CorePartyPreference.FAVORITE_DASHBOARD_REQUIREMENT.getPreferenceKey();
            case Workspace.TEST_CASE -> CorePartyPreference.FAVORITE_DASHBOARD_TEST_CASE.getPreferenceKey();
            case Workspace.CAMPAIGN -> CorePartyPreference.FAVORITE_DASHBOARD_CAMPAIGN.getPreferenceKey();
            default -> throw new IllegalArgumentException("workspace should be home, requirement,test-case or campaign");
        };
    }

    @Override
    public boolean shouldShowFavoriteDashboardInWorkspace(Workspace workspace) {
        String key = this.getWorkspaceContentPreferenceKey(workspace);
        PartyPreference pref = this.partyPreferenceService.findPreferenceForCurrentUser(key);
        if (pref == null) {
            return false;
        }
        String content = pref.getPreferenceValue();
        if (StringUtils.isEmpty((CharSequence)content) || content.equals(WorkspaceDashboardContentValues.DEFAULT.getPreferenceValue())) {
            return false;
        }
        return content.equals(WorkspaceDashboardContentValues.DASHBOARD.getPreferenceValue());
    }

    private String getWorkspaceContentPreferenceKey(Workspace workspace) {
        return switch (workspace) {
            case Workspace.HOME -> CorePartyPreference.HOME_WORKSPACE_CONTENT.getPreferenceKey();
            case Workspace.REQUIREMENT -> CorePartyPreference.REQUIREMENT_WORKSPACE_CONTENT.getPreferenceKey();
            case Workspace.TEST_CASE -> CorePartyPreference.TEST_CASE_WORKSPACE_CONTENT.getPreferenceKey();
            case Workspace.CAMPAIGN -> CorePartyPreference.CAMPAIGN_WORKSPACE_CONTENT.getPreferenceKey();
            default -> throw new IllegalArgumentException("workspace should be home, requirement,test-case or campaign");
        };
    }

    @Override
    public boolean canShowDashboardInWorkspace(Workspace workspace) {
        String key = this.getChooseFavoriteDashboardPreferenceKey(workspace);
        PartyPreference pref = this.partyPreferenceService.findPreferenceForCurrentUser(key);
        if (pref == null) {
            return false;
        }
        String candidateDashboardId = pref.getPreferenceValue();
        if (StringUtils.isEmpty((CharSequence)candidateDashboardId)) {
            return false;
        }
        Long dashboardId = Long.parseLong(candidateDashboardId);
        Optional node = this.customReportLibraryNodeDao.findById(dashboardId);
        return node.isPresent() && this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, "READ", node.get());
    }

    @Override
    public void removeDashboardFromFavoritesForCurrentUser(long nodeId) {
        this.partyPreferenceService.removeDashboardFromFavoritesForCurrentUser(nodeId);
    }

    @Override
    public void removeDashboardFromFavoriteWithPreferenceKey(long nodeId, Workspace workspace) {
        String preferenceKey = this.getChooseFavoriteDashboardPreferenceKey(workspace);
        this.partyPreferenceService.removeDashboardFromFavoriteWithPreferenceKey(nodeId, preferenceKey);
    }

    @Override
    public List<EntityReference> getScopeFromMilestone(Milestone milestone) {
        if (Objects.isNull(milestone)) {
            return Collections.emptyList();
        }
        return milestone.getProjects().stream().map(GenericProject::toEntityReference).toList();
    }
}

