/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.connectionhistory;

import jakarta.inject.Inject;
import java.util.Date;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.users.ConnectionLog;
import org.squashtest.tm.service.connectionhistory.ConnectionLogService;
import org.squashtest.tm.service.internal.repository.ConnectionLogDao;

@Service(value="squashtest.tm.service.ConnectionLogService")
@Transactional
public class ConnectionLogServiceImpl
implements ConnectionLogService {
    @Inject
    private ConnectionLogDao dao;

    @Override
    public ConnectionLog addSuccessfulConnectionLog(String login) {
        return this.initConnectionLog(login, true);
    }

    @Override
    public ConnectionLog addFailedConnectionLog(String login) {
        return this.initConnectionLog(login, false);
    }

    private ConnectionLog initConnectionLog(String login, boolean success) {
        ConnectionLog connectionLog = new ConnectionLog();
        connectionLog.setLogin(login);
        connectionLog.setConnectionDate(new Date());
        connectionLog.setSuccess(Boolean.valueOf(success));
        this.dao.save(connectionLog);
        return connectionLog;
    }
}

