/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.List;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.execution.TestSuiteTestPlanHasDeletedTestCaseException;
import org.squashtest.tm.service.campaign.ExecutionCreationService;
import org.squashtest.tm.service.internal.campaign.AbstractTestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcTestPlanItemDeletionHandlerFactory;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.TestSuiteTestPlanGrid;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.internal.repository.display.TestSuiteDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squashtest.tm.service.TestSuiteExecutionProcessingService")
@Transactional
public class TestSuiteExecutionProcessingServiceImpl
extends AbstractTestPlanExecutionProcessingService<TestSuite, TestPlanResume.TestSuiteTestPlanResume> {
    private static final String CAN_EXECUTE_BY_TESTSUITE_ID = "hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'EXECUTE') or hasRole('ROLE_ADMIN')";
    private final TestSuiteDao suiteDao;
    private final TestSuiteDisplayDao testSuiteDisplayDao;

    TestSuiteExecutionProcessingServiceImpl(CampaignNodeDeletionHandler campaignDeletionHandler, PermissionEvaluationService permissionEvaluationService, TestPlanItemDao testPlanItemDao, DSLContext dslContext, TestSuiteDao suiteDao, TestSuiteDisplayDao testSuiteDisplayDao, ExecutionCreationService executionCreationService, JdbcTestPlanItemDeletionHandlerFactory deletionHandlerFactory) {
        super(campaignDeletionHandler, permissionEvaluationService, testPlanItemDao, dslContext, executionCreationService, deletionHandlerFactory);
        this.suiteDao = suiteDao;
        this.testSuiteDisplayDao = testSuiteDisplayDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.TestSuiteTestPlanResume startResume(long testSuiteId) {
        return (TestPlanResume.TestSuiteTestPlanResume)this.commonStartResume(testSuiteId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.TestSuiteTestPlanResume relaunch(long testSuiteId, boolean deletePrevious) {
        return (TestPlanResume.TestSuiteTestPlanResume)super.relaunch(testSuiteId, deletePrevious);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.TestSuiteTestPlanResume startResumeNextExecution(long testSuiteId, long testPlanItemId, boolean deletePrevious) {
        return (TestPlanResume.TestSuiteTestPlanResume)super.startResumeNextExecution(testSuiteId, testPlanItemId, deletePrevious);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public void deleteAllExecutions(long testSuiteId) {
        super.deleteAllExecutions(testSuiteId);
    }

    @Override
    protected TestSuite getTestPlanOwner(long testSuiteId) {
        return this.suiteDao.loadForExecutionResume(testSuiteId);
    }

    @Override
    TestSuite createTransientTestPlanOwnerWithFilteredTestPlan(long testSuiteId, List<TestPlanItem> filteredTestPLan) {
        TestSuite testSuite = this.getTestPlanOwner(testSuiteId);
        TestSuite copyTestSuite = testSuite.createCopy();
        copyTestSuite.getTestPlanItems().clear();
        copyTestSuite.getTestPlanItems().addAll(filteredTestPLan);
        return copyTestSuite;
    }

    @Override
    List<TestPlanItem> getFilteredTestPlan(long testSuiteId, List<GridFilterValue> filters) {
        TestSuiteTestPlanGrid testPlanGrid = new TestSuiteTestPlanGrid(testSuiteId, null, this.testSuiteDisplayDao);
        GridRequest gridRequest = this.prepareNonPaginatedGridRequest(filters);
        GridResponse gridResponse = testPlanGrid.getRows(gridRequest, this.dslContext);
        List<Long> itemIds = this.extractItemIdsFromGridResponse(gridResponse);
        return this.testPlanItemDao.findAllById(itemIds);
    }

    @Override
    ActionException getTestPlanHasDeletedTestCaseException() {
        return new TestSuiteTestPlanHasDeletedTestCaseException();
    }

    @Override
    protected TestPlanResume createNewTestPlanResume(long testPlanOwnerId, Execution execution, boolean hasNextTestCase, List<Long> partialTestPlanItemIds) {
        return new TestPlanResume.TestSuiteTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, partialTestPlanItemIds);
    }

    @Override
    protected TestPlanResume.TestSuiteTestPlanResume createNewTestPlanResume(long testPlanOwnerId, Execution execution, boolean hasNextTestCase) {
        return new TestPlanResume.TestSuiteTestPlanResume(testPlanOwnerId, execution, hasNextTestCase);
    }

    @Override
    public boolean hasDeletedTestCaseInTestPlan(long testPlanOwnerId) {
        return this.suiteDao.hasDeletedTestCaseInTestPlan(testPlanOwnerId);
    }

    @Override
    protected List<Long> getTestPlanItemIds(long testPlanOwnerId, String testerLogin) {
        if (testerLogin != null && !testerLogin.isBlank()) {
            return this.suiteDao.getTestPlanItemIdsAssignedToUser(testPlanOwnerId, testerLogin);
        }
        return this.suiteDao.getTestPlanItemIds(testPlanOwnerId);
    }

    @Override
    protected Class<?> getTestPlanOwnerClass() {
        return TestSuite.class;
    }
}

