/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.server.custom;

import java.time.Duration;
import java.util.Map;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.CustomChatModel;

public class CustomChatModelBuilder {
    private String apiKey;
    private String baseUrl;
    private String payloadTemplate;
    private Map<String, String> httpHeaders;
    private String answerPath;
    private Duration timeout;
    private boolean logRequests = false;
    private boolean logResponses = false;

    public CustomChatModelBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public CustomChatModelBuilder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public CustomChatModelBuilder payloadTemplate(String payloadTemplate) {
        this.payloadTemplate = payloadTemplate;
        return this;
    }

    public CustomChatModelBuilder httpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public CustomChatModelBuilder answerPath(String answerPath) {
        this.answerPath = answerPath;
        return this;
    }

    public CustomChatModelBuilder timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public CustomChatModelBuilder logRequests(boolean logRequests) {
        this.logRequests = logRequests;
        return this;
    }

    public CustomChatModelBuilder logResponses(boolean logResponses) {
        this.logResponses = logResponses;
        return this;
    }

    public CustomChatModelBuilder additionalParameter(String key, String value) {
        this.httpHeaders.put(key, value);
        return this;
    }

    public CustomChatModelBuilder additionalParameters(Map<String, String> parameters) {
        this.httpHeaders.putAll(parameters);
        return this;
    }

    public CustomChatModel build() {
        this.validateParameters();
        return new CustomChatModel(this);
    }

    private void validateParameters() {
        if (this.apiKey == null || this.apiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("API key is required");
        }
        if (this.baseUrl == null || this.baseUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Base URL is required");
        }
        if (this.payloadTemplate == null || this.payloadTemplate.trim().isEmpty()) {
            throw new IllegalArgumentException("Payload template is required");
        }
        if (this.answerPath == null || this.answerPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Answer path is required");
        }
    }

    String getApiKey() {
        return this.apiKey;
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    String getPayloadTemplate() {
        return this.payloadTemplate;
    }

    String getAnswerPath() {
        return this.answerPath;
    }

    Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    Duration getTimeout() {
        return this.timeout;
    }

    boolean isLogRequests() {
        return this.logRequests;
    }

    boolean isLogResponses() {
        return this.logResponses;
    }
}

