/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.annotation;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.hibernate.Session;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.service.annotation.DisableSoftDeleteFilters;

@Aspect
@Component
public class DisableSoftDeleteFiltersAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisableSoftDeleteFilters.class);
    private static final Map<Class<?>, String> FILTER_BY_CLASS_MAP = Map.of(CampaignTestPlanItem.class, "activeCampaignItem");
    @PersistenceContext
    private EntityManager entityManager;

    @Around(value="execution(@org.squashtest.tm.service.annotation.DisableSoftDeleteFilters * * (..)) && @annotation(disableSoftDeleteFilters)")
    public Object disableFilters(ProceedingJoinPoint joinPoint, DisableSoftDeleteFilters disableSoftDeleteFilters) throws Throwable {
        Object object;
        Session session = (Session)this.entityManager.unwrap(Session.class);
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Set<String> filtersToDisable = DisableSoftDeleteFiltersAspect.resolveFilters(session, disableSoftDeleteFilters, methodName);
        Set<String> activeFilters = filtersToDisable.stream().filter(filterName -> session.getEnabledFilter(filterName) != null).collect(Collectors.toSet());
        try {
            LOGGER.trace("Disabling filters {} for method: {}", new Object[]{filtersToDisable, methodName});
            filtersToDisable.forEach(arg_0 -> ((Session)session).disableFilter(arg_0));
            object = joinPoint.proceed();
        }
        catch (Throwable throwable) {
            LOGGER.trace("Restoring filters {} after method: {}", new Object[]{activeFilters, methodName});
            activeFilters.forEach(arg_0 -> ((Session)session).enableFilter(arg_0));
            throw throwable;
        }
        LOGGER.trace("Restoring filters {} after method: {}", new Object[]{activeFilters, methodName});
        activeFilters.forEach(arg_0 -> ((Session)session).enableFilter(arg_0));
        return object;
    }

    private static Set<String> resolveFilters(Session session, DisableSoftDeleteFilters annotation, String methodName) {
        Set definedFilters = session.getSessionFactory().getDefinedFilterNames();
        if (annotation.disableAll()) {
            return definedFilters;
        }
        return Arrays.stream(annotation.entities()).map(entityClass -> DisableSoftDeleteFiltersAspect.getFilterForClass(entityClass, definedFilters, methodName)).collect(Collectors.toSet());
    }

    private static String getFilterForClass(Class<?> entityClass, Set<String> definedFilters, String methodName) {
        String filter = FILTER_BY_CLASS_MAP.get(entityClass);
        if (filter == null) {
            throw new IllegalArgumentException("No filter mapping found for entity '%s' in method '%s'".formatted(entityClass.getSimpleName(), methodName));
        }
        if (!definedFilters.contains(filter)) {
            throw new IllegalArgumentException("Filter '%s' not found in Hibernate configuration for method '%s'. Available filters: %s".formatted(filter, methodName, definedFilters));
        }
        return filter;
    }
}

