/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.NamedReferencePair;
import org.squashtest.tm.domain.library.structures.LibraryGraph;
import org.squashtest.tm.service.internal.repository.JooqCallTestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;

@Component
public class TestCaseCallTreeFinder {
    private final TestCaseDao testCaseDao;
    private final JooqCallTestCaseDao jooqCallTestCaseDao;

    public TestCaseCallTreeFinder(JooqCallTestCaseDao jooqCallTestCaseDao, TestCaseDao testCaseDao) {
        this.jooqCallTestCaseDao = jooqCallTestCaseDao;
        this.testCaseDao = testCaseDao;
    }

    public Set<Long> getTestCaseCallTree(Long testCaseId) {
        return new HashSet<Long>(this.jooqCallTestCaseDao.findRecursiveCalledIdsByCallerIds(List.of(testCaseId)).getOrDefault(testCaseId, Collections.emptyList()));
    }

    public Set<Long> getTestCaseCallTree(Collection<Long> testCaseIds) {
        return this.jooqCallTestCaseDao.findRecursiveCalledIdsByCallerIds(testCaseIds).values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> getCallerGraph(List<Long> calledIds) {
        HashSet<Long> allIds = new HashSet<Long>();
        allIds.addAll(calledIds);
        LinkedList allpairs = new LinkedList();
        LinkedList<Long> currentCalled = new LinkedList<Long>(calledIds);
        while (!currentCalled.isEmpty()) {
            List currentPair = this.testCaseDao.findTestCaseCallsUpstream(currentCalled);
            allpairs.addAll(currentPair);
            LinkedList<Long> nextCalled = new LinkedList<Long>();
            for (NamedReferencePair pair : currentPair) {
                Long key;
                if (pair.getCaller() == null || allIds.contains(key = pair.getCaller().getId())) continue;
                nextCalled.add(key);
                allIds.add(key);
            }
            currentCalled = nextCalled;
        }
        LibraryGraph graph = new LibraryGraph();
        for (NamedReferencePair pair : allpairs) {
            graph.addEdge(this.node(pair.getCaller()), this.node(pair.getCalled()));
        }
        return graph;
    }

    public LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> getExtendedGraph(Collection<Long> sourceIds) {
        List<NamedReferencePair> existingPairs = this.jooqCallTestCaseDao.findRecursiveTestCasesCalls(sourceIds);
        ArrayList<NamedReferencePair> result = new ArrayList<NamedReferencePair>(existingPairs);
        Map<Long, String> caller = existingPairs.stream().map(NamedReferencePair::getCaller).collect(Collectors.toMap(NamedReference::getId, NamedReference::getName, (x, y) -> x));
        Map<Long, String> called = existingPairs.stream().map(NamedReferencePair::getCalled).collect(Collectors.toMap(NamedReference::getId, NamedReference::getName, (x, y) -> x));
        HashSet<Long> ids = new HashSet<Long>(caller.keySet());
        ids.addAll(called.keySet());
        for (Long id2 : ids) {
            if (!caller.containsKey(id2)) {
                result.add(new NamedReferencePair(id2, called.get(id2), null, null));
            }
            if (called.containsKey(id2)) continue;
            result.add(new NamedReferencePair(null, null, id2, caller.get(id2)));
        }
        Set missingIds = sourceIds.stream().filter(sourceId -> !ids.contains(sourceId)).collect(Collectors.toSet());
        if (!missingIds.isEmpty()) {
            Map missingIdByNames = this.testCaseDao.findNameByTestCaseId(missingIds);
            missingIdByNames.forEach((id, name) -> {
                result.add(new NamedReferencePair(id, name, null, null));
                result.add(new NamedReferencePair(null, null, id, name));
            });
        }
        LibraryGraph graph = new LibraryGraph();
        for (NamedReferencePair pair : result) {
            graph.addEdge(this.node(pair.getCaller()), this.node(pair.getCalled()));
        }
        return graph;
    }

    private LibraryGraph.SimpleNode<NamedReference> node(NamedReference ref) {
        return ref != null ? new LibraryGraph.SimpleNode((Object)ref) : null;
    }
}

