/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultpublisher;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.testautomation.resultpublisher.AutomatedSuiteCompletionActionsService;
import org.squashtest.tm.service.testautomation.resultpublisher.AutomatedSuiteCompletionService;

@Service(value="suiteCompletionService")
@Transactional
public class AutomatedSuiteCompletionServiceImpl
implements AutomatedSuiteCompletionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedSuiteCompletionServiceImpl.class);
    private static final long SAFETY_DELAY_SECONDS = 30L;
    private final AutomatedSuiteCompletionActionsService completionActionsService;

    public AutomatedSuiteCompletionServiceImpl(AutomatedSuiteCompletionActionsService completionActionsService) {
        this.completionActionsService = completionActionsService;
    }

    @Override
    @UsedInPlugin(names={PluginName.API_REST})
    public void completeSuite(String automatedSuiteUuid) {
        LOGGER.info("AutomatedSuite completion requested for UUID: {}", new Object[]{automatedSuiteUuid});
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.schedule(() -> {
            this.completionActionsService.performCompletionActions(automatedSuiteUuid);
            scheduler.shutdown();
        }, 30L, TimeUnit.SECONDS);
        LOGGER.debug("AutomatedSuite completion actions scheduled in {} seconds for UUID: {}", new Object[]{30L, automatedSuiteUuid});
    }
}

