/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignDto;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignFolderDto;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignLibraryDto;
import org.squashtest.tm.service.internal.display.dto.campaign.IterationPlanningDto;
import org.squashtest.tm.service.internal.repository.display.CampaignDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository
public class CampaignDisplayDaoImpl
implements CampaignDisplayDao {
    private final DSLContext dsl;

    public CampaignDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public CampaignLibraryDto getCampaignLibraryDtoById(Long id) {
        return (CampaignLibraryDto)this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY.CL_ID.as("ID"), (SelectField)Tables.CAMPAIGN_LIBRARY.ATTACHMENT_LIST_ID, (SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.DESCRIPTION, (SelectField)Tables.PROJECT.NAME).from((TableLike)Tables.CAMPAIGN_LIBRARY).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.TCL_ID.eq((Field)Tables.CAMPAIGN_LIBRARY.CL_ID)).where(Tables.CAMPAIGN_LIBRARY.CL_ID.eq((Object)id)).fetchOneInto(CampaignLibraryDto.class);
    }

    @Override
    public CampaignFolderDto getCampaignFolderDtoById(long campaignFolderId) {
        return (CampaignFolderDto)this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("ID"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.ATTACHMENT_LIST_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Object)campaignFolderId)).fetchOneInto(CampaignFolderDto.class);
    }

    @Override
    public CampaignDto getCampaignDtoById(long campaignId) {
        Field hasDatasets = DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID).and(Tables.CAMPAIGN_TEST_PLAN_ITEM.DATASET_ID.isNotNull()))).as("HAS_DATASETS");
        return (CampaignDto)this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("ID"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.ATTACHMENT_LIST_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_BY, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_ON, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_BY, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_ON, (SelectField)Tables.CAMPAIGN.REFERENCE, (SelectField)Tables.CAMPAIGN.CAMPAIGN_STATUS, (SelectField)Tables.CAMPAIGN.ACTUAL_END_AUTO, (SelectField)Tables.CAMPAIGN.ACTUAL_END_DATE, (SelectField)Tables.CAMPAIGN.ACTUAL_START_AUTO, (SelectField)Tables.CAMPAIGN.ACTUAL_START_DATE, (SelectField)Tables.CAMPAIGN.SCHEDULED_START_DATE, (SelectField)Tables.CAMPAIGN.SCHEDULED_END_DATE, (SelectField)hasDatasets).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Object)campaignId)).groupBy(new GroupField[]{Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CAMPAIGN.CLN_ID}).fetchOneInto(CampaignDto.class);
    }

    @Override
    public List<IterationPlanningDto> findIterationPlanningByCampaign(Long campaignId) {
        return this.dsl.select((SelectField)Tables.ITERATION.ITERATION_ID.as("ID"), (SelectField)Tables.ITERATION.SCHEDULED_START_DATE, (SelectField)Tables.ITERATION.SCHEDULED_END_DATE, (SelectField)Tables.ITERATION.NAME).from((TableLike)Tables.ITERATION).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).where(Tables.CAMPAIGN.CLN_ID.eq((Object)campaignId)).fetchInto(IterationPlanningDto.class);
    }

    @Override
    public int getNbTestPlanItem(Long campaignId, String login) {
        Integer count;
        SelectConditionStep allTestPlanItemsFromCampaign = this.dsl.selectCount().from((TableLike)Tables.CAMPAIGN).innerJoin((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.USER_ID)).where(Tables.CAMPAIGN.CLN_ID.eq((Object)campaignId));
        if (login != null) {
            allTestPlanItemsFromCampaign = allTestPlanItemsFromCampaign.and(Tables.CORE_USER.LOGIN.eq((Object)login));
        }
        return (count = (Integer)allTestPlanItemsFromCampaign.groupBy(new GroupField[]{Tables.CAMPAIGN.CLN_ID}).fetchOneInto(Integer.TYPE)) != null ? count : 0;
    }

    @Override
    public List<String> retrieveFullNameByCampaignLibraryNodeIds(List<Long> campaignLibraryNodeIds, List<Long> projectIds) {
        Field fullName = DSL.when((Condition)Tables.CAMPAIGN.REFERENCE.isNull().or(Tables.CAMPAIGN.REFERENCE.eq((Object)"")), (Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME).otherwise(DSL.concat((Field[])new Field[]{Tables.CAMPAIGN.REFERENCE, DSL.val((String)" - "), Tables.CAMPAIGN_LIBRARY_NODE.NAME}));
        return this.dsl.select((SelectField)fullName).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.in(campaignLibraryNodeIds)).and(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)fullName).fetch(fullName);
    }

    @Override
    public List<Long> findDistinctProjectIdsByCampaignLibraryIds(Set<Long> campaignLibraryIds) {
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.CL_ID.in(campaignLibraryIds)).fetchInto(Long.class);
    }

    @Override
    public List<Long> findDistinctProjectIdsByCampaignLibraryNodeIds(Set<Long> campaignNodeIds) {
        return this.dsl.selectDistinct((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.in(campaignNodeIds)).fetchInto(Long.class);
    }

    @Override
    public List<String> findAllDisabledExecutionStatusByProjectIds(Set<Long> projectIds) {
        return this.dsl.select((SelectField)Tables.DISABLED_EXECUTION_STATUS.EXECUTION_STATUS).from((TableLike)Tables.PROJECT).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY).on(Tables.PROJECT.CL_ID.eq((Field)Tables.CAMPAIGN_LIBRARY.CL_ID)).leftJoin((TableLike)Tables.DISABLED_EXECUTION_STATUS).on(Tables.CAMPAIGN_LIBRARY.CL_ID.eq((Field)Tables.DISABLED_EXECUTION_STATUS.CL_ID)).where(Tables.PROJECT.PROJECT_ID.in(projectIds)).and(Tables.DISABLED_EXECUTION_STATUS.EXECUTION_STATUS.isNotNull()).fetchInto(String.class);
    }

    @Override
    public List<NamedReference> findNamedReferences(List<Long> ids) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("ID"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.in(ids)).fetchInto(NamedReference.class);
    }

    @Override
    public Map<Long, List<Long>> findExecutionIdsByCampaignIds(List<Long> campaignIds) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.CAMPAIGN_ITERATION).leftJoin((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(campaignIds)).fetchGroups((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (Field)Tables.EXECUTION.EXECUTION_ID);
    }

    @Override
    public List<Long> findContainedCampaignIds(List<Long> campaignLibraryNodeIds) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN.CLN_ID).from((TableLike)Tables.CAMPAIGN).leftJoin((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(campaignLibraryNodeIds).or(Tables.CAMPAIGN.CLN_ID.in(campaignLibraryNodeIds))).fetchInto(Long.class);
    }
}

