/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record9;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotAttachmentEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestSuitePivot;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestSuitePivotDao;

@Repository
public class TestSuitePivotDaoImpl
extends AbstractPivotDao<TestSuitePivot>
implements TestSuitePivotDao {
    private final CustomFieldPivotDao customFieldPivotDao;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;

    public TestSuitePivotDaoImpl(AdminPivotConverterService adminPivotConverterService, DSLContext dsl, CustomFieldPivotDao customFieldPivotDao, ExecutionWorkspaceConverterService executionWorkspaceConverterService) {
        super(dsl, adminPivotConverterService);
        this.customFieldPivotDao = customFieldPivotDao;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
    }

    @Override
    public boolean hasTestSuiteByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    private ResultQuery<? extends Record> getCustomFieldValueTestSuiteByProjectIdQuery(Long projectId) {
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.TEST_SUITE);
        return this.dsl.select((SelectField)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID)).join(customFieldValuesTable).on(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getAttachmentByProjectIdQuery(Long projectId) {
        return this.dsl.select((SelectField)Tables.TEST_SUITE.ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID)).join((TableLike)Tables.TEST_SUITE).on(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.TEST_SUITE.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.TEST_SUITE.ID).fetchSize(50);
    }

    @Override
    public void getTestSuiteByProjectId(Long projectId, Consumer<TestSuitePivot> writingToJsonConsumer, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        ResultQuery resultQuery = this.dsl.select((SelectField)Tables.TEST_SUITE.ID, (SelectField)Tables.TEST_SUITE.NAME, (SelectField)Tables.TEST_SUITE.DESCRIPTION, (SelectField)Tables.TEST_SUITE.CREATED_BY, (SelectField)Tables.TEST_SUITE.CREATED_ON, (SelectField)Tables.TEST_SUITE.LAST_MODIFIED_BY, (SelectField)Tables.TEST_SUITE.LAST_MODIFIED_ON, (SelectField)Tables.TEST_SUITE.EXECUTION_STATUS, (SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID, (SelectField)Tables.ITERATION_TEST_SUITE.ITERATION_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID)).join((TableLike)Tables.TEST_SUITE).on(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.TEST_SUITE.ID, (OrderField)Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER).fetchSize(50);
        this.convertRecordAndWritingPivot(resultQuery, projectId, EntityBindingField.TEST_SUITE, writingToJsonConsumer, writingAttachmentConsumer);
    }

    @Override
    protected TestSuitePivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        TestSuitePivot testSuitePivot = this.executionWorkspaceConverterService.testSuiteRecordToTestSuitePivot(record);
        this.appendTestPlanItemToTestSuitePivot(testSuitePivot, record);
        return testSuitePivot;
    }

    private void appendTestPlanItemToTestSuitePivot(TestSuitePivot testSuitePivot, Record record) {
        if (record.get((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID) != null) {
            testSuitePivot.addTestPlanItemBinding((Long)record.get((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID));
        }
    }

    @Override
    protected void fillPivotObject(TestSuitePivot pivotObject, Record record) {
        this.appendTestPlanItemToTestSuitePivot(pivotObject, record);
    }

    @Override
    protected List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of(this.getCufPivotContainer(projectId), this.getAttachmentPivotContainer(this.getAttachmentByProjectIdQuery(projectId), (Field<Long>)Tables.TEST_SUITE.ID));
    }

    private SubElementRecordProcessor<CustomFieldValuePivot> getCufPivotContainer(Long projectId) {
        return new SubElementRecordProcessor<CustomFieldValuePivot>(this.getCustomFieldValueTestSuiteByProjectIdQuery(projectId), (Field<Long>)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, this.customFieldPivotDao::cufValueRecordToCufValuePivot, CustomFieldValuePivot.class);
    }

    @Override
    protected void appendSubElementsToPivotObject(TestSuitePivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        pivotObject.addAllCustomFields(this.getSubElement(CustomFieldValuePivot.class, subElementsByClazz));
        this.addAndWriteAttachmentPivot(this.getSubElement(AttachmentPivot.class, subElementsByClazz), (PivotAttachmentEntity)pivotObject, writingAttachmentConsumer);
    }
}

