/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.mapping;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.testcase.TestCaseImportance;

public enum XrayPriority {
    LOWEST("lowest", RequirementCriticality.MINOR, TestCaseImportance.LOW),
    LOW("low", RequirementCriticality.MINOR, TestCaseImportance.LOW),
    MEDIUM("medium", RequirementCriticality.MAJOR, TestCaseImportance.MEDIUM),
    HIGH("high", RequirementCriticality.MAJOR, TestCaseImportance.HIGH),
    HIGHEST("highest", RequirementCriticality.CRITICAL, TestCaseImportance.VERY_HIGH),
    DEFAULT("", RequirementCriticality.UNDEFINED, TestCaseImportance.defaultValue());

    private final String xrayField;
    private final RequirementCriticality requirementCriticality;
    private final TestCaseImportance testCaseImportance;

    private XrayPriority(String xrayField, RequirementCriticality requirementCriticality, TestCaseImportance testCaseImportance) {
        this.xrayField = xrayField;
        this.requirementCriticality = requirementCriticality;
        this.testCaseImportance = testCaseImportance;
    }

    public String getXrayField() {
        return this.xrayField;
    }

    public RequirementCriticality getRequirementCriticality() {
        return this.requirementCriticality;
    }

    public TestCaseImportance getTestCaseImportance() {
        return this.testCaseImportance;
    }

    public static String getXrayFieldMapping() {
        return Arrays.stream(XrayPriority.values()).filter(xrayPriority -> xrayPriority != DEFAULT).map(XrayPriority::getXrayField).collect(Collectors.joining(", "));
    }

    public static XrayPriority getPriority(String priority) {
        if (Objects.isNull(priority)) {
            return DEFAULT;
        }
        return Arrays.stream(XrayPriority.values()).filter(xrayPriority -> xrayPriority.getXrayField().toLowerCase().contains(priority.toLowerCase())).findFirst().orElse(DEFAULT);
    }
}

