/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class RequirementVersionHasChildrenFilterHandler
implements FilterHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"REQUIREMENT_VERSION_HAS_CHILDREN"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        HasChildrenFilterValue hasChildrenFilterValue = this.extractFilterValue(filter);
        QRequirement parentRequirement = new QRequirement("parentRequirement");
        QRequirementVersion parentVersion = new QRequirementVersion("parentVersion");
        QRequirementVersion outerVersion = QRequirementVersion.requirementVersion;
        HibernateQuery subquery = (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)parentRequirement)).join((CollectionExpression)parentRequirement.versions, (Path)parentVersion)).where((Predicate)parentVersion.id.eq((Expression)outerVersion.id))).groupBy((Expression)parentRequirement.id);
        if (HasChildrenFilterValue.NO_CHILDREN.equals((Object)hasChildrenFilterValue)) {
            subquery.having((Predicate)parentRequirement.children.size().eq((Object)0));
        } else {
            subquery.having((Predicate)parentRequirement.children.size().gt((Number)0));
        }
        query.where((Predicate)subquery.exists());
    }

    private HasChildrenFilterValue extractFilterValue(GridFilterValue filter) {
        List<String> values = filter.getValues();
        if (values.size() != 1) {
            throw new IllegalArgumentException("Invalid value for filter REQUIREMENT_VERSION_HAS_CHILDREN");
        }
        return HasChildrenFilterValue.valueOf(values.get(0));
    }

    public static enum HasChildrenFilterValue {
        HAS_CHILDREN,
        NO_CHILDREN;

    }
}

