/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.search.filter.FilterValueHandler;

@Component
@Profile(value={"mariadb"})
public class FullTextMariaFilterValueHandler
implements FilterValueHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"TEST_CASE_DESCRIPTION", "TEST_CASE_PREQUISITE", "REQUIREMENT_VERSION_DESCRIPTION"});

    @Override
    public boolean canHandleGridFilterValue(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleGridFilterValue(GridFilterValue filter) {
        List<String> value = filter.getValues();
        List<String> htmlValues = value.stream().map(this::formatValue).toList();
        filter.setValues(htmlValues);
    }

    private String formatValue(String value) {
        String newValue = HtmlUtils.htmlEscape((String)value);
        List<String> sValues = Arrays.asList(newValue.trim().split("\\s+"));
        newValue = sValues.stream().map(v -> "+\"" + v + "\"").collect(Collectors.joining(" "));
        return newValue;
    }
}

