/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.requirements;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.display.requirements.RequirementPathFinderService;
import org.squashtest.tm.service.internal.library.HibernatePathService;

@Service
@Transactional(readOnly=true)
public class RequirementPathFinderServiceImpl
implements RequirementPathFinderService {
    @PersistenceContext
    private EntityManager em;

    @Override
    public String buildRequirementLinkPath(Long requirementId, String requirementProjectName) {
        if (requirementId != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(requirementProjectName);
            String pathFromFolder = this.getPathFromFolder(requirementId);
            String pathFromParents = this.getPathFromParentsRequirements(requirementId);
            sb.append(pathFromFolder);
            sb.append(pathFromParents);
            return HibernatePathService.substituteSpecialPathSeparator(sb.toString());
        }
        return null;
    }

    private String getPathFromParentsRequirements(Long requirementId) {
        String result = this.requirementVersionQuery("requirement.findReqParentPathForToolTip", requirementId, String.class, "");
        if (!result.isEmpty()) {
            return " \u001f " + result;
        }
        return "";
    }

    private String getPathFromFolder(Long requirementId) {
        String result = this.requirementVersionQuery("requirement.findReqFolderPathForToolTip", requirementId, String.class, "");
        if (!result.isEmpty()) {
            return " \u001f " + result;
        }
        return "";
    }

    private <R> R requirementVersionQuery(String queryName, Long requirementId, Class<R> resultClass, R defaultValue) {
        Session session = this.getStatelessSession();
        Query q = session.createNamedQuery(queryName, resultClass);
        q.setParameter("requirementId", (Object)requirementId);
        Object result = q.uniqueResult();
        return (R)(result != null ? result : defaultValue);
    }

    private Session getStatelessSession() {
        Session s = (Session)this.em.unwrap(Session.class);
        s.setHibernateFlushMode(FlushMode.MANUAL);
        return s;
    }
}

