/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.actionword;

import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.actionword.ActionWordTreeLibraryNode;
import org.squashtest.tm.domain.tree.TreeLibraryNode;
import org.squashtest.tm.service.internal.repository.ActionWordLibraryNodeDao;

@Component
public class ActionWordLibraryNodeCopier {
    private final ActionWordLibraryNodeDao actionWordLibraryNodeDao;

    public ActionWordLibraryNodeCopier(ActionWordLibraryNodeDao actionWordLibraryNodeDao) {
        this.actionWordLibraryNodeDao = actionWordLibraryNodeDao;
    }

    public boolean simulateCopyNodes(List<ActionWordLibraryNode> nodes, ActionWordLibraryNode target, boolean caseInsensitivity) {
        return this.checkIfAllNodesCanBeCopiedInTarget(nodes, target, caseInsensitivity);
    }

    private boolean checkIfAllNodesCanBeCopiedInTarget(List<ActionWordLibraryNode> nodes, ActionWordLibraryNode target, boolean caseInsensitivity) {
        return nodes.size() == this.actionWordLibraryNodeDao.findAllCanBeCopiedNodesInTarget(nodes, target, caseInsensitivity).size();
    }

    public List<ActionWordLibraryNode> copyNodes(List<ActionWordLibraryNode> nodes, ActionWordLibraryNode target, boolean caseInsensitivity) {
        List allCanBeCopiedNodeIds = this.actionWordLibraryNodeDao.findAllCanBeCopiedNodesInTarget(nodes, target, caseInsensitivity);
        ArrayList<ActionWordLibraryNode> copiedNodes = new ArrayList<ActionWordLibraryNode>();
        for (ActionWordLibraryNode node : nodes) {
            if (!allCanBeCopiedNodeIds.contains(node.getId())) continue;
            ActionWordLibraryNode copy = this.createFirstLayerCopy(node, target, caseInsensitivity);
            target.addChild((ActionWordTreeLibraryNode)copy, caseInsensitivity);
            copiedNodes.add(copy);
        }
        return copiedNodes;
    }

    private ActionWordLibraryNode createFirstLayerCopy(ActionWordLibraryNode node, ActionWordLibraryNode target, boolean caseInsensitivity) {
        ActionWordLibraryNode copy = this.createBasicCopy(node, target);
        for (TreeLibraryNode child : node.getChildren()) {
            this.createSubTreeCopy((ActionWordLibraryNode)child, copy, caseInsensitivity);
        }
        return copy;
    }

    private ActionWordLibraryNode createSubTreeCopy(ActionWordLibraryNode node, ActionWordLibraryNode target, boolean caseInsensitivity) {
        ActionWordLibraryNode copy = this.createBasicCopy(node, target);
        target.addChild((ActionWordTreeLibraryNode)copy, caseInsensitivity);
        for (TreeLibraryNode child : node.getChildren()) {
            this.createSubTreeCopy((ActionWordLibraryNode)child, copy, caseInsensitivity);
        }
        return copy;
    }

    private ActionWordLibraryNode createBasicCopy(ActionWordLibraryNode node, ActionWordLibraryNode target) {
        ActionWordLibraryNode copy = new ActionWordLibraryNode();
        copy.setLibrary(target.getLibrary());
        copy.setName(node.getName());
        this.copyTreeEntity(node, copy);
        return copy;
    }

    private void copyTreeEntity(ActionWordLibraryNode node, ActionWordLibraryNode copy) {
        ActionWordTreeEntity treeEntity = node.getEntity().createCopy();
        treeEntity.setProject(copy.getLibrary().getProject());
        copy.setEntity(treeEntity);
        copy.setEntityType(node.getEntityType());
    }
}

