/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.jooq;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.TestCaseStatisticsDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Repository
public class TestCaseStatisticsDaoImpl
implements TestCaseStatisticsDao {
    private static final String SIZE_COUNT = "size_count";
    private static final String SIZE_CLASS = "sizeclass";
    private final DSLContext dslContext;
    private final ActiveMilestoneHolder activeMilestoneHolder;

    public TestCaseStatisticsDaoImpl(DSLContext dslContext, ActiveMilestoneHolder activeMilestoneHolder) {
        this.dslContext = dslContext;
        this.activeMilestoneHolder = activeMilestoneHolder;
    }

    private Table<Record1<Long>> getTestCaseTable(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        Select<Record1<Long>> query = null;
        if (!testCaseLibraryIds.isEmpty()) {
            query = this.getTestCaseLibrary(testCaseLibraryIds, activeMilestone);
        }
        if (!testCaseNodeIds.isEmpty()) {
            Select<Record1<Long>> nodeQuery = this.getTestCaseNode(testCaseNodeIds, activeMilestone);
            Select<Record1<Long>> select = query = query == null ? nodeQuery : query.union(nodeQuery);
        }
        if (query == null) {
            throw new IllegalArgumentException("At least one of the collections must not be empty");
        }
        return query.asTable("test_case_table");
    }

    private Select<Record1<Long>> getTestCaseNode(Collection<Long> testCaseNodeIds, Optional<Milestone> activeMilestone) {
        SelectOnConditionStep baseQuery = this.dslContext.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.TEST_CASE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID));
        Condition filterConditions = Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(testCaseNodeIds).and(ConditionsConstants.TCLN_NOT_IN_BIN);
        return this.applyActiveMilestoneFilter((SelectJoinStep<Record1<Long>>)baseQuery, filterConditions, activeMilestone);
    }

    private Select<Record1<Long>> getTestCaseLibrary(Collection<Long> testCaseLibraryIds, Optional<Milestone> activeMilestone) {
        SelectOnConditionStep baseQuery = this.dslContext.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID));
        Condition filterConditions = Tables.PROJECT.TCL_ID.in(testCaseLibraryIds).and(ConditionsConstants.TCLN_NOT_IN_BIN);
        return this.applyActiveMilestoneFilter((SelectJoinStep<Record1<Long>>)baseQuery, filterConditions, activeMilestone);
    }

    private Select<Record1<Long>> applyActiveMilestoneFilter(SelectJoinStep<Record1<Long>> baseQuery, Condition filterConditions, Optional<Milestone> activeMilestone) {
        return (Select)activeMilestone.map(milestone -> baseQuery.join((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).where(filterConditions.and(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Object)milestone.getId())))).orElseGet(() -> baseQuery.where(filterConditions));
    }

    @Override
    public List<Long> countTestCaseInScope(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        Table<Record1<Long>> testCaseTable = this.getTestCaseTable(testCaseLibraryIds, testCaseNodeIds);
        return this.dslContext.selectFrom(testCaseTable).fetchInto(Long.class);
    }

    @Override
    public Map<Integer, Integer> gatherBoundRequirementStatistics(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        Table<Record1<Long>> testCaseTable = this.getTestCaseTable(testCaseLibraryIds, testCaseNodeIds);
        Table subquery = this.dslContext.select((SelectField)DSL.when((Condition)DSL.count((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).eq((Object)0), (Object)0).when(DSL.count((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).eq((Object)1), (Object)1).otherwise((Object)2).as(SIZE_CLASS)).from(testCaseTable).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq(testCaseTable.field("TCLN_ID", Long.class))).groupBy(new GroupField[]{testCaseTable.field("TCLN_ID", Long.class)}).asTable("test_case_coverage");
        Field sizeClass = subquery.field(SIZE_CLASS, Integer.class);
        return this.dslContext.select((SelectField)sizeClass, (SelectField)DSL.count((Field)sizeClass).as(SIZE_COUNT)).from((TableLike)subquery).groupBy(new GroupField[]{sizeClass}).fetchMap(sizeClass, DSL.field((String)SIZE_COUNT, Integer.class));
    }

    @Override
    public Map<String, Integer> gatherTestCaseImportanceStatistics(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        Table<Record1<Long>> testCaseTable = this.getTestCaseTable(testCaseLibraryIds, testCaseNodeIds);
        return this.dslContext.select((SelectField)Tables.TEST_CASE.IMPORTANCE, (SelectField)DSL.count((Field)Tables.TEST_CASE.TCLN_ID).as("importance_count")).from(testCaseTable).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq(testCaseTable.field("TCLN_ID", Long.class))).groupBy(new GroupField[]{Tables.TEST_CASE.IMPORTANCE}).fetchMap((Field)Tables.TEST_CASE.IMPORTANCE, DSL.count((Field)Tables.TEST_CASE.TCLN_ID).as("importance_count"));
    }

    @Override
    public Map<String, Integer> gatherTestCaseStatusesStatistics(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        Table<Record1<Long>> testCaseTable = this.getTestCaseTable(testCaseLibraryIds, testCaseNodeIds);
        return this.dslContext.select((SelectField)Tables.TEST_CASE.TC_STATUS, (SelectField)DSL.count().as("status_count")).from(testCaseTable).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq(testCaseTable.field("TCLN_ID", Long.class))).groupBy(new GroupField[]{Tables.TEST_CASE.TC_STATUS}).fetchMap((Field)Tables.TEST_CASE.TC_STATUS, DSL.count().as("status_count"));
    }

    @Override
    public Map<Integer, Integer> gatherTestCaseSizeStatistics(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        Table<Record1<Long>> testCaseTable = this.getTestCaseTable(testCaseLibraryIds, testCaseNodeIds);
        Field testCaseIdField = testCaseTable.field("TCLN_ID", Long.class);
        Table subquery = this.dslContext.select((SelectField)DSL.when((Condition)DSL.count((Field)Tables.TEST_CASE_STEPS.STEP_ID).eq((Object)0), (Object)0).when(DSL.count((Field)Tables.TEST_CASE_STEPS.STEP_ID).lt((Object)11), (Object)1).when(DSL.count((Field)Tables.TEST_CASE_STEPS.STEP_ID).lt((Object)21), (Object)2).otherwise((Object)3).as(SIZE_CLASS)).from(testCaseTable).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq(testCaseIdField)).groupBy(new GroupField[]{testCaseIdField}).asTable("sct");
        Field sizeClass = subquery.field(SIZE_CLASS, Integer.class);
        return this.dslContext.select((SelectField)sizeClass, (SelectField)DSL.count((Field)sizeClass).as(SIZE_COUNT)).from((TableLike)subquery).groupBy(new GroupField[]{sizeClass}).fetchMap(sizeClass, DSL.field((String)SIZE_COUNT, Integer.class));
    }
}

