/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.report.ReportTemplateManagerService;

@Service
public class ReportTemplateManagerServiceImpl
implements ReportTemplateManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportTemplateManagerServiceImpl.class);
    private static final String PATH_TRAVERSAL_ERROR = "Attempt to access file outside of template folder.";

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public boolean addATemplateToServer(String folderPathStr, MultipartFile uploadedFile) {
        if (uploadedFile == null || uploadedFile.isEmpty()) {
            throw new IllegalArgumentException("Uploaded file is null or empty.");
        }
        String originalFilename = StringUtils.cleanPath((String)Objects.requireNonNull(uploadedFile.getOriginalFilename()));
        String fileExtension = FilenameUtils.getExtension((String)originalFilename);
        if (!"docx".equalsIgnoreCase(fileExtension)) {
            throw new IllegalArgumentException("Uploaded file does not have a valid .docx extension.");
        }
        try {
            Path folderPath = Paths.get(folderPathStr, new String[0]).toAbsolutePath().normalize();
            Path targetPath = folderPath.resolve(originalFilename).normalize();
            if (!targetPath.startsWith(folderPath)) {
                throw new SecurityException(PATH_TRAVERSAL_ERROR);
            }
            if (Files.notExists(folderPath, new LinkOption[0])) {
                this.checkPathAndCreateMissingFolders(folderPath);
            }
            uploadedFile.transferTo(targetPath);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while adding report template file", (Throwable)e);
            return false;
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteTemplateFromServer(String folderPathStr, String templateFileName) {
        String cleanedFileName = StringUtils.cleanPath((String)Objects.requireNonNull(templateFileName));
        Path folderPath = Paths.get(folderPathStr, new String[0]).toAbsolutePath().normalize();
        Path targetPath = folderPath.resolve(cleanedFileName).normalize();
        if (!targetPath.startsWith(folderPath)) {
            throw new SecurityException(PATH_TRAVERSAL_ERROR);
        }
        try {
            if (Files.exists(targetPath, new LinkOption[0])) {
                FileUtils.delete((File)targetPath.toFile());
            }
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while deleting report template file", (Throwable)e);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public boolean doesTemplateExistOnServer(String folderPathStr, String templateFileName) {
        String cleanedFileName = StringUtils.cleanPath((String)Objects.requireNonNull(templateFileName));
        Path folderPath = Paths.get(folderPathStr, new String[0]).toAbsolutePath().normalize();
        Path targetPath = folderPath.resolve(cleanedFileName).normalize();
        if (!targetPath.startsWith(folderPath)) {
            throw new SecurityException(PATH_TRAVERSAL_ERROR);
        }
        return Files.exists(targetPath, new LinkOption[0]);
    }

    private void checkPathAndCreateMissingFolders(Path folderPath) throws IOException {
        Path normalizedPath = folderPath.toAbsolutePath().normalize();
        if (normalizedPath.toString().isEmpty()) {
            throw new IOException("Folder path is empty.");
        }
        Files.createDirectories(normalizedPath, new FileAttribute[0]);
    }
}

