/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.dto.project;

import java.util.List;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.service.internal.display.dto.project.ProjectAction;

public record ProjectDataInfo(boolean hasData, String i18nMessageKey, List<NonEmptyWorkspaceModel> nonEmptyWorkspaces, boolean hasItemsInBin) {
    private static final String DELETABLE_PROJECT_I18N_KEY = "sqtm-core.administration-workspace.projects.dialog.message.delete-project";
    private static final String NO_DELETABLE_PROJECT_I18N_KEY = "sqtm-core.administration-workspace.projects.dialog.message.cannot-delete-project-with-data";
    private static final String DELETABLE_PROJECT_I18N_KEY_WITH_LINKED_JOBS = "sqtm-core.administration-workspace.projects.dialog.message.delete-project-with-linked-jobs";
    private static final String DELETABLE_PROJECT_I18N_KEY_WITH_NON_EMPTY_BIN = "sqtm-core.administration-workspace.projects.dialog.message.delete-project-with-non-empty-bin";
    private static final String DELETABLE_PROJECT_I18N_KEY_WITH_LINKED_JOBS_AND_NON_EMPTY_BIN = "sqtm-core.administration-workspace.projects.dialog.message.delete-project-with-linked-jobs-and-non-empty-bin";
    private static final String CANNOT_COERCE_INTO_TEMPLATE_I18N_KEY = "sqtm-core.administration-workspace.projects.dialog.message.cannot-coerce-into-template";
    private static final String COERCE_INTO_TEMPLATE_I18N_KEY = "sqtm-core.administration-workspace.projects.dialog.message.coerce-into-template";
    private static final String COERCE_INTO_TEMPLATE_I18N_KEY_WITH_NON_EMPTY_BIN = "sqtm-core.administration-workspace.projects.dialog.message.coerce-into-template-with-non-empty-bin";

    public static ProjectDataInfo empty(ProjectAction action, boolean containElementsInBin, boolean containExecutedTests) {
        String i18nKey = ProjectDataInfo.determineEmptyProjectMessageKey(action, containElementsInBin, containExecutedTests);
        return new ProjectDataInfo(false, i18nKey, List.of(), containElementsInBin);
    }

    public static ProjectDataInfo nonEmpty(ProjectAction action, List<Workspace> nonEmptyWorkspaces) {
        String i18nKey = ProjectDataInfo.determineNonEmptyProjectMessageKey(ProjectAction.DELETION == action);
        List<NonEmptyWorkspaceModel> models = nonEmptyWorkspaces.stream().map(workspace -> new NonEmptyWorkspaceModel((Workspace)workspace, ProjectDataInfo.getNotEmptyWorkspaceI18nKey(workspace))).toList();
        return new ProjectDataInfo(true, i18nKey, models, false);
    }

    private static String determineNonEmptyProjectMessageKey(boolean isDeletionAction) {
        if (isDeletionAction) {
            return NO_DELETABLE_PROJECT_I18N_KEY;
        }
        return CANNOT_COERCE_INTO_TEMPLATE_I18N_KEY;
    }

    private static String determineEmptyProjectMessageKey(ProjectAction action, boolean containElementsInBin, boolean containExecutedTests) {
        if (ProjectAction.TRANSFORMATION == action) {
            return containElementsInBin ? COERCE_INTO_TEMPLATE_I18N_KEY_WITH_NON_EMPTY_BIN : COERCE_INTO_TEMPLATE_I18N_KEY;
        }
        if (containExecutedTests) {
            return containElementsInBin ? DELETABLE_PROJECT_I18N_KEY_WITH_LINKED_JOBS_AND_NON_EMPTY_BIN : DELETABLE_PROJECT_I18N_KEY_WITH_LINKED_JOBS;
        }
        return containElementsInBin ? DELETABLE_PROJECT_I18N_KEY_WITH_NON_EMPTY_BIN : DELETABLE_PROJECT_I18N_KEY;
    }

    public static String getNotEmptyWorkspaceI18nKey(Workspace workspace) {
        return switch (workspace) {
            case Workspace.REQUIREMENT -> "sqtm-core.requirement-workspace.label.short";
            case Workspace.TEST_CASE -> "sqtm-core.test-case-workspace.label.short";
            case Workspace.CAMPAIGN -> "sqtm-core.campaign-workspace.label.short";
            case Workspace.CUSTOM_REPORT -> "sqtm-core.custom-report-workspace.label.short";
            case Workspace.ACTION_WORD -> "sqtm-core.action-word-workspace.label.short";
            default -> throw new IllegalArgumentException("Workspace " + String.valueOf(workspace) + " is not handled");
        };
    }

    public record NonEmptyWorkspaceModel(Workspace id, String i18nKey) {
    }
}

