/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testplanitem;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.exception.requirement.MilestoneForbidModificationException;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.TestPlanDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testplanitem.GenericTestPlanItemManager;

@Service
@Transactional
public class GenericTestPlanItemManagerImpl
implements GenericTestPlanItemManager {
    private static final String LOCKED_MILESTONE_MESSAGE = "This test plan item is linked to a blocking milestone and cannot be modified.";
    private final SprintDisplayDao sprintDisplayDao;
    private final MilestoneDao milestoneDao;
    private final TestPlanDao testPlanDao;
    private final PermissionEvaluationService permissionEvaluationService;
    @PersistenceContext
    private EntityManager entityManager;

    public GenericTestPlanItemManagerImpl(SprintDisplayDao sprintDisplayDao, MilestoneDao milestoneDao, TestPlanDao testPlanDao, PermissionEvaluationService permissionEvaluationService) {
        this.sprintDisplayDao = sprintDisplayDao;
        this.milestoneDao = milestoneDao;
        this.testPlanDao = testPlanDao;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void changeDataset(long testPlanItemId, Long datasetId) {
        TestPlanItem item = this.findTestPlanItemAndCheckSprintStatusAndMilestones(testPlanItemId);
        if (datasetId == null) {
            item.setReferencedDataset(null);
        } else {
            Dataset dataset = (Dataset)this.entityManager.find(Dataset.class, (Object)datasetId);
            item.setReferencedDataset(dataset);
        }
    }

    @Override
    public void assignUserToTestPlanItems(List<Long> testPlanItemIds, Long userId) {
        List<TestPlanItem> items = this.findWritableTestPlanItems(testPlanItemIds);
        if (userId == null) {
            items.forEach(item -> item.setAssignee(null));
        } else {
            User user = (User)this.entityManager.find(User.class, (Object)userId);
            items.forEach(item -> item.setAssignee(user));
        }
    }

    @Override
    public void moveTestPlanItems(long testPlanId, List<Long> testPlanItemIds, int position) {
        TestPlan testPlan = this.testPlanDao.findByIdWithTestPlanItems(testPlanId);
        List<TestPlanItem> testPlanItems = testPlan.getTestPlanItems().stream().filter(item -> testPlanItemIds.contains(item.getId())).toList();
        if (testPlanItems.isEmpty()) {
            return;
        }
        Long firstTestPlanItemId = testPlanItems.get(0).getId();
        this.checkBlockingMilestones(firstTestPlanItemId);
        this.checkParentSprintStatus(firstTestPlanItemId);
        testPlan.moveItems(testPlanItems, position);
    }

    private TestPlanItem findTestPlanItemAndCheckSprintStatusAndMilestones(Long testPlanItemId) {
        this.checkBlockingMilestones(testPlanItemId);
        this.checkParentSprintStatus(testPlanItemId);
        return (TestPlanItem)this.entityManager.find(TestPlanItem.class, (Object)testPlanItemId);
    }

    private void checkBlockingMilestones(long testPlanItemId) {
        if (this.milestoneDao.isTestPlanItemBoundToBlockingMilestone(testPlanItemId)) {
            throw new MilestoneForbidModificationException(LOCKED_MILESTONE_MESSAGE);
        }
    }

    private void checkParentSprintStatus(long testPlanItemId) {
        SprintStatus sprintStatus = this.sprintDisplayDao.getSprintStatusByTestPlanItemId(testPlanItemId);
        if (SprintStatus.CLOSED.equals((Object)sprintStatus)) {
            throw new SprintClosedException();
        }
    }

    private List<TestPlanItem> findWritableTestPlanItems(List<Long> testPlanItemIds) {
        this.permissionEvaluationService.checkPermission(testPlanItemIds, Permissions.WRITE.name(), TestPlanItem.class.getName());
        return this.entityManager.createQuery("select tpi\nfrom TestPlanItem tpi\nwhere tpi.id in :testPlanItemIds\n", TestPlanItem.class).setParameter("testPlanItemIds", testPlanItemIds).getResultList().stream().peek(item -> this.checkBlockingMilestones(item.getId())).peek(item -> this.checkParentSprintStatus(item.getId())).toList();
    }
}

