/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.ExecutionExecutionSteps;
import org.squashtest.tm.jooq.domain.tables.ExecutionStep;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.TestAutomationServer;
import org.squashtest.tm.service.internal.dto.AutomatedExecutionUpdateData;
import org.squashtest.tm.service.internal.dto.ExecutionSummaryDto;
import org.squashtest.tm.service.internal.repository.CustomExecutionDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

@Repository
public class ExecutionDaoImpl
implements CustomExecutionDao {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dsl;

    @Override
    public Execution findAndInit(long executionId) {
        return (Execution)this.entityManager.createQuery("select e from Execution e\nleft join fetch e.referencedTestCase\nleft join fetch e.steps\nwhere e.id = :id", Execution.class).setParameter("id", (Object)executionId).getSingleResult();
    }

    @Override
    public ExecutionStatusReport getStatusReport(long executionId) {
        Field statusCount = DSL.count().as("STATUS_COUNT");
        Map map = this.dsl.select((SelectField)ExecutionStep.EXECUTION_STEP.EXECUTION_STATUS, (SelectField)statusCount).from((TableLike)ExecutionExecutionSteps.EXECUTION_EXECUTION_STEPS).innerJoin((TableLike)ExecutionStep.EXECUTION_STEP).on(ExecutionExecutionSteps.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)ExecutionStep.EXECUTION_STEP.EXECUTION_STEP_ID)).where(ExecutionExecutionSteps.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Object)executionId)).groupBy(new GroupField[]{ExecutionStep.EXECUTION_STEP.EXECUTION_STATUS}).fetchMap((Field)ExecutionStep.EXECUTION_STEP.EXECUTION_STATUS, statusCount);
        ExecutionStatusReport report = new ExecutionStatusReport();
        ExecutionStatus[] executionStatusArray = ExecutionStatus.values();
        int n = executionStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionStatus status = executionStatusArray[n2];
            Integer count = map.getOrDefault(status.name(), 0);
            report.set(status, count.intValue());
            ++n2;
        }
        return report;
    }

    @Override
    public List<org.squashtest.tm.domain.execution.ExecutionStep> findStepsFiltered(Long executionId, Paging filter) {
        Execution execution = this.findAndInit(executionId);
        int listSize = execution.getSteps().size();
        int startIndex = filter.getFirstItemIndex();
        int lastIndex = filter.getFirstItemIndex() + filter.getPageSize();
        if (startIndex >= listSize) {
            return new LinkedList<org.squashtest.tm.domain.execution.ExecutionStep>();
        }
        if (lastIndex >= listSize) {
            lastIndex = listSize;
        }
        return execution.getSteps().subList(startIndex, lastIndex);
    }

    @Override
    public boolean projectUsesExecutionStatus(long projectId, ExecutionStatus executionStatus) {
        return this.hasExecStepWithStatus(projectId, executionStatus) || this.hasItemTestPlanWithStatus(projectId, executionStatus) || this.hasExecWithStatus(projectId, executionStatus) || this.hasQuickTestWithStatus(projectId, executionStatus);
    }

    private boolean hasExecStepWithStatus(long projectId, ExecutionStatus executionStatus) {
        return this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)ExecutionStep.EXECUTION_STEP).innerJoin((TableLike)ExecutionExecutionSteps.EXECUTION_EXECUTION_STEPS).on(ExecutionExecutionSteps.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)ExecutionStep.EXECUTION_STEP.EXECUTION_STEP_ID)).innerJoin((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).on(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID.eq((Field)ExecutionExecutionSteps.EXECUTION_EXECUTION_STEPS.EXECUTION_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).and(Tables.TEST_PLAN_ITEM.DELETED.isFalse())).innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).innerJoin((TableLike)Project.PROJECT).on(Tables.TEST_PLAN.CL_ID.eq((Field)Project.PROJECT.CL_ID)).where(ExecutionStep.EXECUTION_STEP.EXECUTION_STATUS.eq((Object)executionStatus.name())).and(Project.PROJECT.PROJECT_ID.eq((Object)projectId)));
    }

    private boolean hasExecWithStatus(long projectId, ExecutionStatus executionStatus) {
        return this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).and(Tables.TEST_PLAN_ITEM.DELETED.isFalse())).innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).innerJoin((TableLike)Project.PROJECT).on(Tables.TEST_PLAN.CL_ID.eq((Field)Project.PROJECT.CL_ID)).where(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_STATUS.eq((Object)executionStatus.name())).and(Project.PROJECT.PROJECT_ID.eq((Object)projectId)));
    }

    private boolean hasItemTestPlanWithStatus(long projectId, ExecutionStatus executionStatus) {
        return this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).innerJoin((TableLike)Project.PROJECT).on(Tables.TEST_PLAN.CL_ID.eq((Field)Project.PROJECT.CL_ID)).where(Project.PROJECT.PROJECT_ID.eq((Object)projectId).and(Tables.TEST_PLAN_ITEM.DELETED.isFalse()).and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.eq((Object)executionStatus.name()))));
    }

    private boolean hasQuickTestWithStatus(long projectId, ExecutionStatus executionStatus) {
        return this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.QUICK_TEST).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.QUICK_TEST.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID)).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.SPRINT.CLN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.QUICK_TEST.EXECUTION_STATUS.eq((Object)executionStatus.name()).and(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId))));
    }

    @Override
    public TestAutomationServerKind getTestAutomationServerKindByProjectId(Long projectId) {
        return (TestAutomationServerKind)this.dsl.select((SelectField)TestAutomationServer.TEST_AUTOMATION_SERVER.KIND).from((TableLike)TestAutomationServer.TEST_AUTOMATION_SERVER).innerJoin((TableLike)Project.PROJECT).on(Project.PROJECT.TA_SERVER_ID.eq((Field)TestAutomationServer.TEST_AUTOMATION_SERVER.SERVER_ID)).where(Project.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOneInto(TestAutomationServerKind.class);
    }

    @Override
    public Map<Long, List<ExecutionSummaryDto>> findIterationTestPlanItemLastExecStatuses(Collection<Long> itemTestPlanIds) {
        Table maxOrderTable = DSL.select((SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID, (SelectField)DSL.max((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ORDER).as("max_order")).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).where(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID.in(itemTestPlanIds)).groupBy(new GroupField[]{org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID}).asTable("max_order_table");
        Table partitionTable = DSL.select((SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID, (SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID, (SelectField)DSL.when((Condition)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_STATUS.isNull(), (Field)DSL.val((Object)ExecutionStatus.READY, String.class)).otherwise((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_STATUS).as("EXECUTION_STATUS"), (SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.LAST_EXECUTED_ON, (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID}).orderBy(new OrderField[]{org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ORDER.desc()})).as("ROW_NUMBER")).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).innerJoin((TableLike)maxOrderTable).on(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID.eq(maxOrderTable.field("TEST_PLAN_ITEM_ID", Long.class)).and(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ORDER.ne(maxOrderTable.field("max_order", Integer.class)))).asTable();
        return this.dsl.selectFrom((TableLike)partitionTable).where(partitionTable.field("ROW_NUMBER", Integer.class).le((Object)5)).fetchStream().collect(Collectors.groupingBy(r -> (Long)r.get("TEST_PLAN_ITEM_ID", Long.class), Collectors.mapping(r -> new ExecutionSummaryDto((Long)r.get("EXECUTION_ID", Long.class), (String)r.get("EXECUTION_STATUS", String.class), (Date)r.get("LAST_EXECUTED_ON", Date.class)), Collectors.toList())));
    }

    @Override
    public List<ExecutionSummaryDto> findSprintTestPlanItemLastExecStatuses(Long testPlanItemId) {
        Integer maxOrder = (Integer)this.dsl.select((SelectField)DSL.max((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ORDER)).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).where(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID.eq((Object)testPlanItemId)).fetchOneInto(Integer.class);
        return this.dsl.select((SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID, (SelectField)DSL.when((Condition)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_STATUS.isNull(), (Field)DSL.val((Object)ExecutionStatus.READY, String.class)).otherwise((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_STATUS).as("EXECUTION_STATUS"), (SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.LAST_EXECUTED_ON).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).where(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID.eq((Object)testPlanItemId).and(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ORDER.notEqual((Object)maxOrder))).orderBy((OrderField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ORDER.desc()).limit((Number)5).fetchInto(ExecutionSummaryDto.class);
    }

    @Override
    public AutomatedExecutionUpdateData findAutomatedExecutionUpdateData(Long itemId, Long suiteId) {
        return (AutomatedExecutionUpdateData)this.dsl.select((SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID, (SelectField)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID, (SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.ATTACHMENT_LIST_ID).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID)).where(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID.eq((Object)itemId).and(Tables.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.eq((Object)suiteId))).fetchOneInto(AutomatedExecutionUpdateData.class);
    }

    @Override
    public List<Long> findItpiIdsByExecutionIds(List<Long> executionIds) {
        return this.dsl.selectDistinct((SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).where(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID.in(executionIds)).fetchInto(Long.class);
    }

    @Override
    public List<Long> findAllIdsByAutomatedSuiteIds(List<Long> automatedSuiteIds) {
        return this.entityManager.createQuery("select autoExec.execution.id\nfrom AutomatedSuite suite\njoin suite.executionExtenders autoExec\nwhere suite.id in :ids", Long.class).setParameter("ids", automatedSuiteIds).getResultList();
    }

    @Override
    public List<org.squashtest.tm.domain.execution.ExecutionStep> findStepsForAllExecutions(Collection<Long> executionIds) {
        return new EntityGraphQueryBuilder<org.squashtest.tm.domain.execution.ExecutionStep>(this.entityManager, org.squashtest.tm.domain.execution.ExecutionStep.class, "select step from ExecutionStep step where step.execution.id in (:ids)").executeDistinctList(Map.of("ids", executionIds));
    }

    @Override
    public Execution loadWithSteps(long executionId) {
        return (Execution)this.entityManager.createQuery("select e from Execution e\nleft join fetch e.referencedTestCase tc\nleft join fetch tc.steps\nleft join fetch e.steps step\nleft join fetch step.referencedTestStep\nwhere e.id = :id", Execution.class).setParameter("id", (Object)executionId).getSingleResult();
    }

    @Override
    public List<Execution> findExecutionsByFailureDetailAndDateAfter(Long failureDetailId, Date createdOnDate) {
        return this.entityManager.createQuery("select e from Execution e\njoin fetch e.automatedExecutionExtender ae\njoin fetch ae.failureDetailList fd\nwhere fd.id = :failureDetailId\nand e.audit.createdOn >= :createdOnDate", Execution.class).setParameter("failureDetailId", (Object)failureDetailId).setParameter("createdOnDate", (Object)createdOnDate).getResultList();
    }

    @Override
    public long countByTestCaseId(long testCaseId) {
        return this.dsl.fetchCount((Select)DSL.select((SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TCLN_ID.eq((Object)testCaseId)));
    }
}

