/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.helper;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringExpression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;
import org.springframework.data.domain.Sort;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.Level;

public final class PagingToQueryDsl {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagingToQueryDsl.class);
    public static final String LIST_SEPARATOR = ";";

    private PagingToQueryDsl() {
    }

    public static SortConverter sortConverter() {
        return new SortConverter();
    }

    public static SortConverter sortConverter(Class<?> entity) {
        return new SortConverter(entity);
    }

    public static ColumnFilteringConverter filterConverter() {
        return new ColumnFilteringConverter();
    }

    public static ColumnFilteringConverter filterConverter(Class<?> entity) {
        return new ColumnFilteringConverter(entity);
    }

    static class BaseConverter {
        Class<?> entity;
        PathBuilder<?> basePath;
        Map<String, Class<?>> propertyTypes = new HashMap();

        BaseConverter(Class<?> entity) {
            this.entity = entity;
        }

        void initBasePath() {
            String alias = this.createAlias();
            this.basePath = new PathBuilder(this.entity, alias);
        }

        String createAlias() {
            String simpleName = this.entity.getSimpleName();
            return simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
        }

        void registerPropertyType(String propertyName, Class<?> propClass) {
            this.propertyTypes.put(propertyName, propClass);
        }

        EntityPathBase<?> toEntityPath(String property) {
            String[] pathElts;
            PathBuilder finalPath = this.basePath;
            String[] stringArray = pathElts = property.split("\\.");
            int n = pathElts.length;
            int n2 = 0;
            while (n2 < n) {
                String elt = stringArray[n2];
                finalPath = finalPath.get(elt);
                ++n2;
            }
            return finalPath;
        }

        public static final class PropertyTypesConfigurer<CONVERTER_SUBTYPE extends BaseConverter> {
            private CONVERTER_SUBTYPE converter;
            private String[] propertyNames;

            PropertyTypesConfigurer(CONVERTER_SUBTYPE parent, String ... propertyNames) {
                this.converter = parent;
                this.propertyNames = propertyNames;
            }

            public CONVERTER_SUBTYPE isClass(Class<?> clazz) {
                String[] stringArray = this.propertyNames;
                int n = this.propertyNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String prop = stringArray[n2];
                    ((BaseConverter)this.converter).registerPropertyType(prop, clazz);
                    ++n2;
                }
                return this.converter;
            }
        }
    }

    public static final class ColumnFilteringConverter
    extends BaseConverter {
        private ColumnFiltering from;
        private Map<String, CompOperator> propertyComparison = new HashMap<String, CompOperator>();

        public ColumnFilteringConverter() {
            super(null);
        }

        public ColumnFilteringConverter(Class<?> entity) {
            super(entity);
        }

        public ColumnFilteringConverter forEntity(Class<?> entity) {
            this.entity = entity;
            return this;
        }

        public ColumnFilteringConverter from(ColumnFiltering filtering) {
            this.from = filtering;
            return this;
        }

        public BaseConverter.PropertyTypesConfigurer<ColumnFilteringConverter> typeFor(String ... propertyNames) {
            return new BaseConverter.PropertyTypesConfigurer<ColumnFilteringConverter>(this, propertyNames);
        }

        public ComparisonOperationConfigurer compare(String ... properties) {
            return new ComparisonOperationConfigurer(this, properties);
        }

        public Predicate build() {
            if (this.entity == null || this.from == null) {
                throw new IllegalStateException("Programming error : PagingToQueryDsl.ColumnFilteringConverter invoked while not fully initialized");
            }
            this.initBasePath();
            BooleanBuilder builder = new BooleanBuilder();
            this.from.getFilteredAttributes().stream().map(this::convert).forEach(arg_0 -> ((BooleanBuilder)builder).and(arg_0));
            return builder.getValue();
        }

        private BooleanExpression convert(String property) {
            EntityPathBase<?> pptPath = this.toEntityPath(property);
            String value = this.from.getFilter(property);
            Object comparisonParameters = this.resolveParameters(property, value);
            CompOperator operator = this.resolveOperator(property, value);
            return switch (operator) {
                case CompOperator.DATE_BETWEEN -> this.asBetweenDateExpression((Expression<Date>)pptPath, (Couple<Date, Date>)((Couple)comparisonParameters));
                case CompOperator.DATE -> this.asDateExpression((Expression<Date>)pptPath, (Date)comparisonParameters);
                case CompOperator.LIKE -> this.asLikeExpression((Expression<String>)pptPath, (String)comparisonParameters);
                case CompOperator.IN -> this.asInExpression(pptPath, comparisonParameters);
                case CompOperator.IS_NULL -> this.isNull((Expression<String>)pptPath);
                default -> pptPath.eq(Expressions.constant((Object)comparisonParameters));
            };
        }

        private <T> BooleanExpression asInExpression(EntityPathBase<T> pptPath, Object comparisonParameters) {
            Set<Object> effectiveParameters = comparisonParameters instanceof Collection ? (Set<Object>)comparisonParameters : Collections.singleton(comparisonParameters);
            return pptPath.in(effectiveParameters);
        }

        private BooleanExpression asLikeExpression(Expression<String> pptPath, String value) {
            String searchTerm = "%" + value.replace("%", "\\%") + "%";
            StringExpression asString = Expressions.asString(pptPath);
            return asString.likeIgnoreCase(searchTerm);
        }

        private BooleanExpression isNull(Expression<String> pptPath) {
            StringExpression asString = Expressions.asString(pptPath);
            return asString.isNull();
        }

        private BooleanExpression asDateExpression(Expression<Date> pptPath, Date value) {
            return this.asBetweenDateExpression(pptPath, (Couple<Date, Date>)new Couple((Object)value, (Object)value));
        }

        private BooleanExpression asBetweenDateExpression(Expression<Date> pptPath, Couple<Date, Date> dates) {
            DateExpression asDate = Expressions.asDate(pptPath);
            Date begin = (Date)dates.getA1();
            Date end = new Date(((Date)dates.getA2()).getTime() + TimeUnit.DAYS.toMillis(1L));
            BooleanExpression finalExpression = asDate.between((Comparable)begin, (Comparable)end);
            return finalExpression;
        }

        private Class<?> resolveClass(String property) {
            CompOperator operator = this.propertyComparison.get(property);
            return this.propertyTypes.computeIfAbsent(property, s -> {
                Class res;
                if (operator == null) {
                    res = String.class;
                } else {
                    res = switch (operator) {
                        case CompOperator.DATE -> Date.class;
                        default -> String.class;
                    };
                }
                return res;
            });
        }

        private CompOperator resolveOperator(String property, String value) {
            Class<String> pptClass = this.propertyTypes.getOrDefault(property, String.class);
            CompOperator operator = this.propertyComparison.computeIfAbsent(property, s -> String.class.isAssignableFrom(pptClass) ? CompOperator.LIKE : CompOperator.EQUALITY);
            if (operator.equals((Object)CompOperator.DATE) && value.contains(" - ")) {
                operator = CompOperator.DATE_BETWEEN;
            }
            return operator;
        }

        private Object resolveParameters(String property, String value) {
            Class<?> pptClass = this.resolveClass(property);
            if (this.isEnumList(pptClass, value)) {
                String[] values = value.split(PagingToQueryDsl.LIST_SEPARATOR);
                ArrayList<Enum> c = new ArrayList<Enum>();
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    c.add(Enum.valueOf(pptClass.asSubclass(Enum.class), s));
                    ++n2;
                }
                return c;
            }
            Object result = this.isEnum(pptClass) ? Enum.valueOf(pptClass.asSubclass(Enum.class), value) : (this.canCoerceToDate(pptClass) ? (value.contains(" - ") ? this.parseAsCoupleDates(value) : this.parseAsDate(value)) : (this.canCoerceToLong(pptClass) ? (value != null ? Long.valueOf(ColumnFilteringConverter.coerceToLong(value)) : value) : (this.canCoerceToDouble(pptClass) ? Double.valueOf(value) : value)));
            return result;
        }

        private static long coerceToLong(String value) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("Wrong format for numeric value", (Throwable)nfe);
                return -52214L;
            }
        }

        private boolean canCoerceToLong(Class<?> clazz) {
            return Long.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz);
        }

        private boolean canCoerceToDouble(Class<?> clazz) {
            return Float.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz);
        }

        private boolean isEnum(Class<?> clazz) {
            return clazz.isEnum();
        }

        private boolean isEnumList(Class<?> clazz, String value) {
            boolean isEnumList = false;
            if (value != null) {
                isEnumList = value.contains(PagingToQueryDsl.LIST_SEPARATOR) && clazz.isEnum();
            }
            return isEnumList;
        }

        private boolean canCoerceToDate(Class<?> clazz) {
            return Date.class.isAssignableFrom(clazz) || Temporal.class.isAssignableFrom(clazz) || LocalDate.class.isAssignableFrom(clazz);
        }

        private Date parseAsDate(String value) {
            try {
                return DateUtils.parseDdMmYyyyDate((String)value);
            }
            catch (ParseException ex) {
                throw new RuntimeException("Encountered exception while parsing dates, probably not in yyyy-mm-dd format : '" + value + "'", ex);
            }
        }

        private Couple<Date, Date> parseAsCoupleDates(String strDates) {
            String[] splitDates = strDates.split(" - ");
            Date begin = this.parseAsDate(splitDates[0]);
            Date end = this.parseAsDate(splitDates[1]);
            return new Couple((Object)begin, (Object)end);
        }

        private static enum CompOperator {
            EQUALITY,
            LIKE,
            DATE_BETWEEN,
            DATE,
            IN,
            IS_NULL;

        }

        public static final class ComparisonOperationConfigurer {
            private ColumnFilteringConverter converter;
            private String[] properties;

            ComparisonOperationConfigurer(ColumnFilteringConverter converter, String[] propertyNames) {
                this.converter = converter;
                this.properties = propertyNames;
            }

            public ColumnFilteringConverter withEquality() {
                this.registerHint(CompOperator.EQUALITY);
                return this.converter;
            }

            public ColumnFilteringConverter withLike() {
                this.registerHint(CompOperator.LIKE);
                return this.converter;
            }

            public ColumnFilteringConverter withIn() {
                this.registerHint(CompOperator.IN);
                return this.converter;
            }

            public ColumnFilteringConverter withBetweenDates() {
                this.registerHint(CompOperator.DATE_BETWEEN);
                return this.converter;
            }

            public ColumnFilteringConverter withDates() {
                this.registerHint(CompOperator.DATE);
                return this.converter;
            }

            public ColumnFilteringConverter isNull() {
                this.registerHint(CompOperator.IS_NULL);
                return this.converter;
            }

            private void registerHint(CompOperator operation) {
                String[] stringArray = this.properties;
                int n = this.properties.length;
                int n2 = 0;
                while (n2 < n) {
                    String prop = stringArray[n2];
                    this.converter.propertyComparison.put(prop, operation);
                    ++n2;
                }
            }
        }
    }

    public static final class SortConverter
    extends BaseConverter {
        private Sort from;

        SortConverter() {
            super(null);
        }

        SortConverter(Class<?> entity) {
            super(entity);
        }

        public SortConverter forEntity(Class<?> entity) {
            this.entity = entity;
            return this;
        }

        public SortConverter from(Sort from) {
            this.from = from;
            return this;
        }

        public BaseConverter.PropertyTypesConfigurer<SortConverter> typeFor(String ... propertyNames) {
            return new BaseConverter.PropertyTypesConfigurer<SortConverter>(this, propertyNames);
        }

        public OrderSpecifier<?>[] build() {
            if (this.entity == null || this.from == null) {
                throw new IllegalStateException("Programming error : PagingToQueryDsl.SortConverter invoked while not fully initialized");
            }
            this.initBasePath();
            return (OrderSpecifier[])this.from.stream().map(this::convert).toArray(OrderSpecifier[]::new);
        }

        private OrderSpecifier convert(Sort.Order nativeOrder) {
            Sort.Direction direction = nativeOrder.getDirection();
            Sort.NullHandling nullHandling = nativeOrder.getNullHandling();
            String property = nativeOrder.getProperty();
            Expression expr = this.createOrderExpression(property);
            Order qdslOrder = this.toQdslOrder(direction);
            OrderSpecifier.NullHandling qdslNullHandling = this.toQdslNullhandling(nullHandling);
            return new OrderSpecifier(qdslOrder, expr, qdslNullHandling);
        }

        private Expression createOrderExpression(String property) {
            Class pptClass;
            Expression pptPath;
            Expression expression = pptPath = this.toEntityPath(property);
            if (this.propertyTypes.containsKey(property) && this.isLevelEnum(pptClass = (Class)this.propertyTypes.get(property))) {
                expression = this.orderByLevel((EntityPathBase<?>)pptPath, pptClass);
            }
            return expression;
        }

        private boolean isLevelEnum(Class<?> clazz) {
            return Level.class.isAssignableFrom(clazz) && Enum.class.isAssignableFrom(clazz);
        }

        private <T extends Enum<T>> Expression orderByLevel(EntityPathBase<?> path, Class<T> pptClass) {
            CaseBuilder.Cases interm = null;
            Enum[] enums = (Enum[])pptClass.getEnumConstants();
            Map<Integer, Expression> levelByEnum = Arrays.stream(enums).collect(Collectors.toMap(e -> ((Level)e).getLevel(), Expressions::constant));
            for (Map.Entry<Integer, Expression> entry : levelByEnum.entrySet()) {
                Integer level = entry.getKey();
                Expression value = entry.getValue();
                interm = interm == null ? new CaseBuilder().when((Predicate)path.eq(value)).then((Number)level) : interm.when((Predicate)path.eq(value)).then((Object)level);
            }
            return interm.otherwise(Expressions.constant((Object)-1000));
        }

        private Order toQdslOrder(Sort.Direction direction) {
            return direction.isAscending() ? Order.ASC : Order.DESC;
        }

        private OrderSpecifier.NullHandling toQdslNullhandling(Sort.NullHandling handling) {
            return switch (handling) {
                case Sort.NullHandling.NULLS_FIRST -> OrderSpecifier.NullHandling.NullsFirst;
                case Sort.NullHandling.NULLS_LAST -> OrderSpecifier.NullHandling.NullsLast;
                default -> OrderSpecifier.NullHandling.Default;
            };
        }
    }
}

