/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customfield;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.RichTextValue;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.annotation.CachableType;
import org.squashtest.tm.service.annotation.CacheResult;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.internal.copier.BoundEntityCopy;
import org.squashtest.tm.service.internal.customfield.CustomFieldValuesFactoryProvider;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure11;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure7;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure9;
import org.squashtest.tm.service.internal.customfield.ValueEditionStatusStrategy;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomFieldCustomExportDto;
import org.squashtest.tm.service.internal.repository.BoundEntityDao;
import org.squashtest.tm.service.internal.repository.CustomFieldBindingDao;
import org.squashtest.tm.service.internal.repository.CustomFieldValueDao;
import org.squashtest.tm.service.internal.repository.hibernate.customfieldvaluesfactory.AbstractCustomFieldValuesFactory;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squashtest.tm.service.CustomFieldValueManagerService")
@Transactional
public class PrivateCustomFieldValueServiceImpl
implements PrivateCustomFieldValueService {
    @Inject
    AttachmentManagerService attachmentManagerService;
    @Inject
    @Named(value="defaultEditionStatusStrategy")
    private ValueEditionStatusStrategy defaultEditionStatusStrategy;
    @Inject
    @Named(value="requirementBoundEditionStatusStrategy")
    private ValueEditionStatusStrategy requirementBoundEditionStatusStrategy;
    @Inject
    private CustomFieldValueDao customFieldValueDao;
    @Inject
    private CustomFieldBindingDao customFieldBindingDao;
    @Inject
    private BoundEntityDao boundEntityDao;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private CustomFieldValuesFactoryProvider factoryProvider;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public void setPermissionService(PermissionEvaluationService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean hasCustomFields(BoundEntity boundEntity) {
        return this.boundEntityDao.hasCustomField(boundEntity.getBoundEntityId(), boundEntity.getBoundEntityType());
    }

    @Override
    @Transactional(readOnly=true)
    public boolean hasCustomFields(Long boundEntityId, BindableEntity bindableEntity) {
        return this.boundEntityDao.hasCustomField(boundEntityId, bindableEntity);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CustomFieldValue> findAllCustomFieldValues(BoundEntity boundEntity) {
        if (!this.permissionService.canRead(boundEntity) && !this.permissionService.hasRole("ROLE_TA_API_CLIENT")) {
            throw new AccessDeniedException("Access is denied");
        }
        return this.customFieldValueDao.findAllCustomValues(boundEntity.getBoundEntityId(), boundEntity.getBoundEntityType());
    }

    @Override
    @Transactional(readOnly=true)
    public List<CustomFieldValue> findAllCustomFieldValues(long boundEntityId, BindableEntity bindableEntity) {
        BoundEntity boundEntity = this.boundEntityDao.findBoundEntity(boundEntityId, bindableEntity);
        if (!this.permissionService.canRead(boundEntity)) {
            throw new AccessDeniedException("Access is denied");
        }
        return this.findAllCustomFieldValues(boundEntity);
    }

    @Override
    public List<CustomFieldValue> findAllCustomFieldValues(Collection<? extends BoundEntity> boundEntities) {
        Map<BindableEntity, List<Long>> compositeIds = this.breakEntitiesIntoCompositeIds(boundEntities);
        ArrayList<CustomFieldValue> result = new ArrayList<CustomFieldValue>();
        for (Map.Entry<BindableEntity, List<Long>> entry : compositeIds.entrySet()) {
            BindableEntity bindableEntity = entry.getKey();
            Collection collection = entry.getValue();
            CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)customFieldValueDao, (Object)collection, (Object)bindableEntity);
            Object[] objectArray = new Object[]{this, customFieldValueDao, collection, bindableEntity, joinPoint};
            PrivateCustomFieldValueServiceImpl$AjcClosure1 privateCustomFieldValueServiceImpl$AjcClosure1 = new PrivateCustomFieldValueServiceImpl$AjcClosure1(objectArray);
            result.addAll((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
        }
        return result;
    }

    @Override
    public List<CustomFieldValue> findAllCustomFieldValues(Collection<? extends BoundEntity> boundEntities, Collection<CustomField> restrictedToThoseCustomfields) {
        Map<BindableEntity, List<Long>> compositeIds = this.breakEntitiesIntoCompositeIds(boundEntities);
        ArrayList<CustomFieldValue> result = new ArrayList<CustomFieldValue>();
        for (Map.Entry<BindableEntity, List<Long>> entry : compositeIds.entrySet()) {
            Collection<CustomField> collection = restrictedToThoseCustomfields;
            BindableEntity bindableEntity = entry.getKey();
            List<Long> list = entry.getValue();
            CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
            Object[] objectArray = new Object[]{list, bindableEntity, collection};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)customFieldValueDao, (Object[])objectArray);
            Object[] objectArray2 = new Object[]{this, customFieldValueDao, list, bindableEntity, collection, joinPoint};
            PrivateCustomFieldValueServiceImpl$AjcClosure3 privateCustomFieldValueServiceImpl$AjcClosure3 = new PrivateCustomFieldValueServiceImpl$AjcClosure3(objectArray2);
            result.addAll((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112)));
        }
        return result;
    }

    @Override
    public List<CustomFieldValue> findAllCustomFieldValuesOfCustomField(long cufId) {
        return this.customFieldValueDao.findAllCustomValuesOfCustomField(cufId);
    }

    @Override
    public void cascadeCustomFieldValuesCreation(CustomFieldBinding binding) {
        BindableEntity boundEntity = binding.getBoundEntity();
        AbstractCustomFieldValuesFactory factory = this.factoryProvider.getFactory(boundEntity);
        factory.insertValues(binding);
    }

    @Override
    public void cascadeCustomFieldValuesCreationNotCreatedFolderYet(CustomFieldBinding binding, BoundEntity entity) {
        CustomFieldValue value = binding.createNewValue();
        this.handleRichTextAttachments(entity, value);
        value.setBoundEntity(entity);
        this.customFieldValueDao.save(value);
    }

    @Override
    public <T extends BoundEntity> void batchFolderCustomFieldValuesCreation(List<T> entities, BindableEntity bindableEntity, Long projectId) {
        List<CustomFieldBinding> bindings = this.customFieldBindingDao.findAllForProjectAndEntity(projectId, bindableEntity);
        List newValues = entities.stream().flatMap(entity -> bindings.stream().map(binding -> {
            CustomFieldValue value = binding.createNewValue();
            this.handleRichTextAttachments((BoundEntity)entity, value);
            value.setBoundEntity(entity);
            return value;
        })).toList();
        this.customFieldValueDao.saveAll(newValues);
    }

    @Override
    public void cascadeCustomFieldValuesDeletion(CustomFieldBinding binding) {
        this.customFieldValueDao.deleteAllForBinding(binding.getId());
    }

    @Override
    public void cascadeCustomFieldValuesDeletion(List<Long> customFieldBindingIds) {
        this.customFieldValueDao.deleteAllFromBindings(customFieldBindingIds);
    }

    @Override
    public void createAllCustomFieldValues(BoundEntity entity, GenericProject project) {
        this.createAllCustomFieldValues(Collections.singleton(entity), project, Collections.emptyMap(), null);
    }

    @Override
    public void createAllCustomFieldValues(BoundEntity entity, GenericProject project, Map<Long, RawValue> initialCustomFieldValues) {
        this.createAllCustomFieldValues(Collections.singleton(entity), project, Map.of(entity, initialCustomFieldValues), null);
    }

    @Override
    public void createAllCustomFieldValues(BoundEntity entity, GenericProject project, Map<Long, RawValue> initialCustomFieldValues, String url) {
        this.createAllCustomFieldValues(Collections.singleton(entity), project, Map.of(entity, initialCustomFieldValues), url);
    }

    @Override
    public <T extends BoundEntity> void createAllCustomFieldValues(Collection<T> entities, GenericProject p) {
        this.createAllCustomFieldValues(entities, p, Collections.emptyMap(), null);
    }

    @Override
    public <T extends BoundEntity> void createAllCustomFieldValues(Collection<T> entities, GenericProject p, Map<T, Map<Long, RawValue>> customFieldsByEntity, String url) {
        if (entities.isEmpty()) {
            return;
        }
        GenericProject project = Objects.isNull(p) ? ((BoundEntity)entities.iterator().next()).getProject() : p;
        entities.stream().collect(Collectors.groupingBy(BoundEntity::getBoundEntityType)).forEach((type, groupedEntities) -> this.createAllCustomFieldValuesByBindableEntity((BindableEntity)type, (List)groupedEntities, project, customFieldsByEntity, url));
    }

    private <T extends BoundEntity> void createAllCustomFieldValuesByBindableEntity(BindableEntity bindableEntity, List<T> entities, GenericProject project, Map<T, Map<Long, RawValue>> customFieldsByEntity, String url) {
        List<CustomFieldBinding> bindings = this.optimizedFindCustomField((BoundEntity)entities.getFirst(), project);
        Map<Long, Set<CustomFieldBinding>> bindingPerEntities = this.findEffectiveBindings(bindableEntity, entities);
        for (BoundEntity entity : entities) {
            Set effectiveBindings = bindingPerEntities.getOrDefault(entity.getBoundEntityId(), Collections.emptySet());
            bindings.stream().filter(b -> !effectiveBindings.contains(b)).forEach(binding -> {
                CustomFieldValue value = binding.createNewValue();
                Long customFieldId = value.getCustomField().getId();
                if (customFieldsByEntity.containsKey(entity) && ((Map)customFieldsByEntity.get(entity)).containsKey(customFieldId)) {
                    RawValue newValue = (RawValue)((Map)customFieldsByEntity.get(entity)).get(customFieldId);
                    newValue.setValueFor(value);
                }
                this.handleRichTextAttachments(entity, value, url);
                value.setBoundEntity(entity);
                this.customFieldValueDao.save(value);
            });
        }
    }

    private void handleRichTextAttachments(BoundEntity entity, CustomFieldValue customFieldValue, String url) {
        if (customFieldValue instanceof RichTextValue) {
            String html;
            String richText = customFieldValue.getValue();
            String string = html = Objects.isNull(url) ? this.attachmentManagerService.handleRichTextAttachments(richText, entity.getAttachmentList()) : this.attachmentManagerService.handleRichTextAttachments(richText, entity.getAttachmentList(), url);
            if (!richText.equals(html)) {
                customFieldValue.setValue(html);
            }
        }
    }

    private void handleRichTextAttachments(BoundEntity entity, CustomFieldValue customFieldValue) {
        this.handleRichTextAttachments(entity, customFieldValue, null);
    }

    @Override
    public void deleteAllCustomFieldValues(BoundEntity entity) {
        this.customFieldValueDao.deleteAllForEntity(entity.getBoundEntityId(), entity.getBoundEntityType());
    }

    @Override
    public void deleteAllCustomFieldValues(BindableEntity entityType, List<Long> entityIds) {
        List<Long> list = entityIds;
        BindableEntity bindableEntity = entityType;
        CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)customFieldValueDao, (Object)bindableEntity, list);
        Object[] objectArray = new Object[]{this, customFieldValueDao, bindableEntity, list, joinPoint};
        PrivateCustomFieldValueServiceImpl$AjcClosure5 privateCustomFieldValueServiceImpl$AjcClosure5 = new PrivateCustomFieldValueServiceImpl$AjcClosure5(objectArray);
        SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
    }

    @Override
    public void copyCustomFieldValues(BoundEntity source, BoundEntity recipient) {
        List<CustomFieldValue> sourceValues = this.customFieldValueDao.findAllCustomValues(source.getBoundEntityId(), source.getBoundEntityType());
        for (CustomFieldValue value : sourceValues) {
            CustomFieldValue copy = value.copy();
            copy.setBoundEntity(recipient);
            this.customFieldValueDao.save(copy);
        }
    }

    @Override
    public boolean areValuesEditable(long boundEntityId, BindableEntity bindableEntity) {
        return this.editableStrategy(bindableEntity).isEditable(boundEntityId, bindableEntity);
    }

    @Override
    public void copyCustomFieldValues(Map<Long, BoundEntity> copiedEntityBySourceId, BindableEntity bindableEntityType) {
        if (copiedEntityBySourceId.isEmpty()) {
            return;
        }
        Set<Long> sourceEntitiesIds = copiedEntityBySourceId.keySet();
        BindableEntity bindableEntity = bindableEntityType;
        Set<Long> set = sourceEntitiesIds;
        CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)customFieldValueDao, set, (Object)bindableEntity);
        Object[] objectArray = new Object[]{this, customFieldValueDao, set, bindableEntity, joinPoint};
        PrivateCustomFieldValueServiceImpl$AjcClosure7 privateCustomFieldValueServiceImpl$AjcClosure7 = new PrivateCustomFieldValueServiceImpl$AjcClosure7(objectArray);
        List sourceValues = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112));
        for (CustomFieldValue cufSource : sourceValues) {
            BoundEntity targetCopy = copiedEntityBySourceId.get(cufSource.getBoundEntityId());
            CustomFieldValue copy = cufSource.copy();
            copy.setBoundEntity(targetCopy);
            this.customFieldValueDao.save(copy);
        }
    }

    @Override
    public void copyCustomFieldValues(List<BoundEntityCopy> boundEntityCopies) {
        if (boundEntityCopies.isEmpty()) {
            return;
        }
        Map<BindableEntity, List<BoundEntityCopy>> copiesByEntity = boundEntityCopies.stream().collect(Collectors.groupingBy(boundEntityCopy -> boundEntityCopy.copy().getBoundEntityType()));
        for (Map.Entry<BindableEntity, List<BoundEntityCopy>> entry : copiesByEntity.entrySet()) {
            Map<Long, BoundEntity> copiedEntityBySourceId = entry.getValue().stream().collect(Collectors.toMap(BoundEntityCopy::originId, BoundEntityCopy::copy));
            this.copyCustomFieldValues(copiedEntityBySourceId, entry.getKey());
        }
    }

    @Override
    public void copyCustomFieldValuesOnProjectChanged(List<BoundEntityCopy> boundEntityCopies, Long projectId) {
        if (boundEntityCopies.isEmpty()) {
            return;
        }
        Map<BindableEntity, List<BoundEntityCopy>> copiesByEntity = boundEntityCopies.stream().collect(Collectors.groupingBy(boundEntityCopy -> boundEntityCopy.copy().getBoundEntityType()));
        for (Map.Entry<BindableEntity, List<BoundEntityCopy>> entry : copiesByEntity.entrySet()) {
            Map<Long, BoundEntity> copiedEntityBySource = entry.getValue().stream().collect(Collectors.toMap(BoundEntityCopy::originId, BoundEntityCopy::copy));
            this.copyCustomFieldValuesOnProjectChanged(entry.getKey(), copiedEntityBySource, projectId);
        }
    }

    private void copyCustomFieldValuesOnProjectChanged(BindableEntity bindableEntity, Map<Long, BoundEntity> copyBySourceId, Long projectId) {
        BindableEntity bindableEntity2 = bindableEntity;
        Set<Long> set = copyBySourceId.keySet();
        CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)customFieldValueDao, set, (Object)bindableEntity2);
        Object[] objectArray = new Object[]{this, customFieldValueDao, set, bindableEntity2, joinPoint};
        PrivateCustomFieldValueServiceImpl$AjcClosure9 privateCustomFieldValueServiceImpl$AjcClosure9 = new PrivateCustomFieldValueServiceImpl$AjcClosure9(objectArray);
        Map<Long, List<CustomFieldValue>> sourceValues = ((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure9.linkClosureAndJoinPoint(4112))).stream().collect(Collectors.groupingBy(cfv -> cfv.getCustomField().getId()));
        List<CustomFieldBinding> projectBindings = this.optimizedFindCustomField(bindableEntity, projectId);
        for (CustomFieldBinding binding : projectBindings) {
            List values = sourceValues.getOrDefault(binding.getCustomField().getId(), Collections.emptyList());
            if (values.isEmpty()) {
                for (BoundEntity entity : copyBySourceId.values()) {
                    CustomFieldValue updatedCUFValue = binding.createNewValue();
                    this.handleRichTextAttachments(entity, updatedCUFValue);
                    updatedCUFValue.setBoundEntity(entity);
                    this.customFieldValueDao.save(updatedCUFValue);
                }
                continue;
            }
            for (CustomFieldValue cufSource : values) {
                BoundEntity targetCopy = copyBySourceId.get(cufSource.getBoundEntityId());
                CustomFieldValue copy = cufSource.copy();
                copy.setBinding(binding);
                copy.setBoundEntity(targetCopy);
                this.customFieldValueDao.save(copy);
            }
        }
    }

    @Override
    public void copyCustomFieldValuesContent(BoundEntity source, BoundEntity recipient) {
        List<CustomFieldValueDao.CustomFieldValuesPair> pairs = this.customFieldValueDao.findPairedCustomFieldValues(source.getBoundEntityType(), source.getBoundEntityId(), recipient.getBoundEntityId());
        for (CustomFieldValueDao.CustomFieldValuesPair pair : pairs) {
            pair.copyContent();
        }
    }

    @CacheResult(type=CachableType.CUSTOM_FIELD)
    private List<CustomFieldBinding> optimizedFindCustomField(BoundEntity entity) {
        return this.customFieldBindingDao.findAllForProjectAndEntity(entity.getProject().getId(), entity.getBoundEntityType());
    }

    @CacheResult(type=CachableType.CUSTOM_FIELD)
    private List<CustomFieldBinding> optimizedFindCustomField(BoundEntity entity, GenericProject project) {
        return this.customFieldBindingDao.findAllForProjectAndEntity(project.getId(), entity.getBoundEntityType());
    }

    private List<CustomFieldBinding> optimizedFindCustomField(BindableEntity bindableEntity, Long projectId) {
        return this.customFieldBindingDao.findAllForProjectAndEntity(projectId, bindableEntity);
    }

    @Override
    public void migrateCustomFieldValues(BoundEntity entity) {
        List<CustomFieldValue> valuesToUpdate = this.customFieldValueDao.findAllCustomValues(entity.getBoundEntityId(), entity.getBoundEntityType());
        if (entity.getProject() != null) {
            List valueIds = IdentifiedUtil.extractIds(valuesToUpdate);
            this.customFieldValueDao.deleteAllById(valueIds);
            List<CustomFieldBinding> projectBindings = this.optimizedFindCustomField(entity);
            for (CustomFieldBinding binding : projectBindings) {
                CustomFieldValue updatedCUFValue = binding.createNewValue();
                this.findUpdatedCufValue(valuesToUpdate, updatedCUFValue);
                updatedCUFValue.setBoundEntity(entity);
                this.customFieldValueDao.save(updatedCUFValue);
            }
        }
    }

    private void findUpdatedCufValue(List<CustomFieldValue> valuesToUpdate, CustomFieldValue updatedCUFValue) {
        for (CustomFieldValue formerCUFValue : valuesToUpdate) {
            if (!formerCUFValue.representsSameCustomField(updatedCUFValue)) continue;
            RawValue rawValue = formerCUFValue.asRawValue();
            rawValue.setValueFor(updatedCUFValue);
            break;
        }
    }

    @Override
    public void migrateCustomFieldValues(Collection<BoundEntity> entities) {
        for (BoundEntity entity : entities) {
            this.migrateCustomFieldValues(entity);
        }
    }

    @Override
    public Map<EntityReference, Map<Long, Object>> getCufValueMapByEntityRef(List<EntityReference> scopeEntities, Map<EntityType, List<Long>> cufIdsMapByEntityType) {
        return this.customFieldValueDao.getCufValuesMapByEntityReference(scopeEntities, cufIdsMapByEntityType);
    }

    @Override
    public List<CustomFieldCustomExportDto> findAllAvailableCufsForCustomExport(List<Long> projectIds) {
        return this.customFieldValueDao.findAllAvailableForCustomExportByProjectIds(projectIds);
    }

    @Override
    public Map<Long, List<CustomFieldValue>> getCufValuesMapByBoundEntity(List<? extends BoundEntity> boundEntities) {
        if (boundEntities.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<BindableEntity, List<Long>> compositeIds = this.breakEntitiesIntoCompositeIds(boundEntities);
        if (compositeIds.size() != 1) {
            throw new IllegalArgumentException("All entities must be of the same type");
        }
        Map.Entry<BindableEntity, List<Long>> entry = compositeIds.entrySet().iterator().next();
        return this.customFieldValueDao.getCufValuesMapByBoundEntity(entry.getKey(), entry.getValue());
    }

    private Map<BindableEntity, List<Long>> breakEntitiesIntoCompositeIds(Collection<? extends BoundEntity> boundEntities) {
        EnumMap<BindableEntity, List<Long>> segregatedEntities = new EnumMap<BindableEntity, List<Long>>(BindableEntity.class);
        for (BoundEntity boundEntity : boundEntities) {
            ArrayList<Long> idList = (ArrayList<Long>)segregatedEntities.get(boundEntity.getBoundEntityType());
            if (idList == null) {
                idList = new ArrayList<Long>();
                segregatedEntities.put(boundEntity.getBoundEntityType(), idList);
            }
            idList.add(boundEntity.getBoundEntityId());
        }
        return segregatedEntities;
    }

    private <T extends BoundEntity> Map<Long, Set<CustomFieldBinding>> findEffectiveBindings(BindableEntity type, Collection<T> entities) {
        List<Long> entityIds = entities.stream().map(BoundEntity::getBoundEntityId).toList();
        BindableEntity bindableEntity = type;
        List<Long> list = entityIds;
        CustomFieldBindingDao customFieldBindingDao = this.customFieldBindingDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)customFieldBindingDao, list, (Object)bindableEntity);
        Object[] objectArray = new Object[]{this, customFieldBindingDao, list, bindableEntity, joinPoint};
        PrivateCustomFieldValueServiceImpl$AjcClosure11 privateCustomFieldValueServiceImpl$AjcClosure11 = new PrivateCustomFieldValueServiceImpl$AjcClosure11(objectArray);
        return ((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure11.linkClosureAndJoinPoint(4112))).stream().collect(Collectors.groupingBy(tuple -> (Long)tuple[0], Collectors.mapping(tuple -> (CustomFieldBinding)tuple[1], Collectors.toSet())));
    }

    private ValueEditionStatusStrategy editableStrategy(BindableEntity bindableEntity) {
        if (bindableEntity.equals((Object)BindableEntity.REQUIREMENT_VERSION)) {
            return this.requirementBoundEditionStatusStrategy;
        }
        return this.defaultEditionStatusStrategy;
    }

    @Override
    public void initCustomFieldValues(BoundEntity entity, Map<Long, RawValue> initialCustomFieldValues) {
        if (initialCustomFieldValues.isEmpty()) {
            return;
        }
        List<CustomFieldValue> persistentValues = this.findAllCustomFieldValues(entity);
        for (CustomFieldValue value : persistentValues) {
            Long customFieldId = value.getCufId();
            if (!initialCustomFieldValues.containsKey(customFieldId)) continue;
            RawValue newValue = initialCustomFieldValues.get(customFieldId);
            newValue.setValueFor(value);
        }
    }

    @Override
    public <T extends BoundEntity> void initBatchCustomFieldValues(Map<T, Map<Long, RawValue>> customFieldsByEntity) {
        if (customFieldsByEntity.isEmpty()) {
            return;
        }
        Map<Long, List<CustomFieldValue>> customFieldValuesByEntityId = this.getCufValuesMapByBoundEntity(new ArrayList<T>(customFieldsByEntity.keySet()));
        if (customFieldValuesByEntityId.isEmpty()) {
            return;
        }
        for (Map.Entry<T, Map<Long, RawValue>> entry : customFieldsByEntity.entrySet()) {
            Long entityId = ((BoundEntity)entry.getKey()).getBoundEntityId();
            Map<Long, RawValue> initialCustomFieldValues = entry.getValue();
            List<CustomFieldValue> customFieldValues = customFieldValuesByEntityId.get(entityId);
            if (initialCustomFieldValues == null || customFieldValues == null) continue;
            for (CustomFieldValue customFieldValue : customFieldValues) {
                Long customFieldId = customFieldValue.getCufId();
                RawValue newValue = initialCustomFieldValues.get(customFieldId);
                if (newValue == null) continue;
                newValue.setValueFor(customFieldValue);
            }
        }
    }

    static {
        PrivateCustomFieldValueServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List batchedFindAllCustomValuesFor_aroundBody0(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, Collection collection, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldValueDao.batchedFindAllCustomValuesFor(collection, bindableEntity);
    }

    static final /* synthetic */ List batchedRestrictedFindAllCustomValuesFor_aroundBody2(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, List list, BindableEntity bindableEntity, Collection collection, JoinPoint joinPoint) {
        return customFieldValueDao.batchedRestrictedFindAllCustomValuesFor(list, bindableEntity, collection);
    }

    static final /* synthetic */ void deleteAllForEntities_aroundBody4(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, BindableEntity bindableEntity, List list, JoinPoint joinPoint) {
        customFieldValueDao.deleteAllForEntities(bindableEntity, list);
    }

    static final /* synthetic */ List batchedFindAllCustomValuesFor_aroundBody6(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, Collection collection, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldValueDao.batchedFindAllCustomValuesFor(collection, bindableEntity);
    }

    static final /* synthetic */ List batchedFindAllCustomValuesFor_aroundBody8(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, Collection collection, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldValueDao.batchedFindAllCustomValuesFor(collection, bindableEntity);
    }

    static final /* synthetic */ List findEffectiveBindingsForEntities_aroundBody10(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldBindingDao customFieldBindingDao, List list, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldBindingDao.findEffectiveBindingsForEntities(list, bindableEntity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PrivateCustomFieldValueServiceImpl.java", PrivateCustomFieldValueServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "batchedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.Collection:org.squashtest.tm.domain.customfield.BindableEntity", "arg0:arg1", "", "java.util.List"), 138);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "batchedRestrictedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.List:org.squashtest.tm.domain.customfield.BindableEntity:java.util.Collection", "arg0:arg1:arg2", "", "java.util.List"), 158);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "deleteAllForEntities", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "org.squashtest.tm.domain.customfield.BindableEntity:java.util.List", "arg0:arg1", "", "void"), 345);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "batchedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.Collection:org.squashtest.tm.domain.customfield.BindableEntity", "arg0:arg1", "", "java.util.List"), 383);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "batchedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.Collection:org.squashtest.tm.domain.customfield.BindableEntity", "arg0:arg1", "", "java.util.List"), 440);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findEffectiveBindingsForEntities", "org.squashtest.tm.service.internal.repository.CustomFieldBindingDao", "java.util.List:org.squashtest.tm.domain.customfield.BindableEntity", "entityIds:entityType", "", "java.util.List"), 603);
    }
}

