/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import jakarta.persistence.EntityManager;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.KeywordExecution;
import org.squashtest.tm.domain.execution.ScriptedExecution;
import org.squashtest.tm.domain.testcase.ConsumerForScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.exception.execution.ExecutionHasNoStepsException;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.ExecutionCreationService;
import org.squashtest.tm.service.internal.campaign.AbstractExecutionCreation;
import org.squashtest.tm.service.internal.campaign.scripted.ScriptedTestCaseExecutionHelper;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.display.ProjectDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestPlanExploratorySessionOverviewDisplayDao;
import org.squashtest.tm.service.testcase.TestCaseCyclicCallChecker;

@Service
@Transactional
public class ExecutionCreationServiceImpl
extends AbstractExecutionCreation
implements ExecutionCreationService {
    private final MessageSource messageSource;
    private final TestCaseCyclicCallChecker testCaseCyclicCallChecker;
    private final PrivateCustomFieldValueService customFieldValueService;
    private final ScriptedTestCaseExecutionHelper scriptedTestCaseExecutionHelper;
    private final PrivateDenormalizedFieldValueService denormalizedFieldValueService;
    private final TestPlanItemDao testPlanItemDao;
    private final ProjectDisplayDao projectDisplayDao;
    private final TestPlanExploratorySessionOverviewDisplayDao testPlanExploratorySessionOverviewDisplayDao;
    private final SprintDisplayDao sprintDisplayDao;
    private final CustomTestSuiteModificationService customTestSuiteModificationService;
    private final ExecutionDao executionDao;

    public ExecutionCreationServiceImpl(MessageSource messageSource, AttachmentManagerService attachmentManagerService, TestCaseCyclicCallChecker testCaseCyclicCallChecker, PrivateCustomFieldValueService customFieldValueService, ScriptedTestCaseExecutionHelper scriptedTestCaseExecutionHelper, PrivateDenormalizedFieldValueService denormalizedFieldValueService, TestPlanItemDao testPlanItemDao, ProjectDisplayDao projectDisplayDao, TestPlanExploratorySessionOverviewDisplayDao testPlanExploratorySessionOverviewDisplayDao, SprintDisplayDao sprintDisplayDao, CustomTestSuiteModificationService customTestSuiteModificationService, ExecutionDao executionDao, EntityManager entityManager) {
        super(entityManager, attachmentManagerService);
        this.messageSource = messageSource;
        this.testCaseCyclicCallChecker = testCaseCyclicCallChecker;
        this.customFieldValueService = customFieldValueService;
        this.scriptedTestCaseExecutionHelper = scriptedTestCaseExecutionHelper;
        this.denormalizedFieldValueService = denormalizedFieldValueService;
        this.testPlanItemDao = testPlanItemDao;
        this.projectDisplayDao = projectDisplayDao;
        this.testPlanExploratorySessionOverviewDisplayDao = testPlanExploratorySessionOverviewDisplayDao;
        this.sprintDisplayDao = sprintDisplayDao;
        this.customTestSuiteModificationService = customTestSuiteModificationService;
        this.executionDao = executionDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public Execution createManualExecution(long testPlanItemId) {
        return this.createManualExecution(testPlanItemId, null);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    @Transactional(noRollbackFor={ExecutionHasNoStepsException.class, TestPlanItemNotExecutableException.class})
    public Execution createManualExecution(long testPlanItemId, Integer position) {
        this.checkParentSprintStatus(testPlanItemId);
        TestPlanItem item = this.testPlanItemDao.findForExecutionCreation(testPlanItemId);
        if (item.isTestCaseDeleted()) {
            throw new TestPlanItemNotExecutableException("Cannot create the execution: the referenced test case has been deleted.");
        }
        Locale locale = this.projectDisplayDao.findBddScriptLanguageByProjectId(item.getProject().getId()).getLocale();
        Execution execution = this.createAndAddExecution(item, this.messageSource, locale, position);
        boolean isExploratory = TestCaseExecutionMode.EXPLORATORY.equals((Object)execution.getExecutionMode());
        if (!isExploratory && execution.getSteps().isEmpty()) {
            throw new ExecutionHasNoStepsException();
        }
        this.customTestSuiteModificationService.updateExecutionStatus(item.getTestSuites());
        return execution;
    }

    private void checkParentSprintStatus(long testPlanItemId) {
        SprintStatus sprintStatus = this.sprintDisplayDao.getSprintStatusByTestPlanItemId(testPlanItemId);
        if (sprintStatus == SprintStatus.CLOSED) {
            throw new SprintClosedException();
        }
    }

    private Execution createAndAddExecution(TestPlanItem item, MessageSource messageSource, Locale locale, Integer position) throws TestPlanItemNotExecutableException {
        this.testCaseCyclicCallChecker.checkNoCyclicCall(item.getReferencedTestCase());
        Execution execution = this.createExecution(item, messageSource, locale);
        item.addExecution(execution, position);
        this.executionDao.save(execution);
        execution.getSteps().forEach(step -> step.setExecution(execution));
        this.operationsAfterAddingExec(execution);
        return execution;
    }

    private void operationsAfterAddingExec(Execution execution) {
        execution.accept((ExecutionVisitor)new ExecutionPostCreationVisitor());
    }

    private final class ExecutionPostCreationVisitor
    implements ExecutionVisitor {
        private ExecutionPostCreationVisitor() {
        }

        public void visit(Execution execution) {
            this.createCustomFieldsForExecutionAndExecutionSteps(execution);
            this.createDenormalizedFieldsForExecutionAndExecutionSteps(execution);
        }

        public void visit(ScriptedExecution scriptedExecution) {
            this.createCustomAndDenormalizedFieldsForExecution((Execution)scriptedExecution);
            this.createExecutionStepsForScriptedTestCase(scriptedExecution);
        }

        public void visit(KeywordExecution keywordExecution) {
            this.createCustomAndDenormalizedFieldsForExecution((Execution)keywordExecution);
        }

        public void visit(ExploratoryExecution exploratoryExecution) {
            this.createCustomAndDenormalizedFieldsForExecution((Execution)exploratoryExecution);
            TestPlanExploratorySessionOverviewDisplayDao.NameAndReference overviewNameAndRef = ExecutionCreationServiceImpl.this.testPlanExploratorySessionOverviewDisplayDao.findNameAndReferenceByExecutionId(exploratoryExecution.getId());
            this.updateExploratoryExecutionInfoFromSessionOverview((Execution)exploratoryExecution, overviewNameAndRef);
        }

        private void updateExploratoryExecutionInfoFromSessionOverview(Execution execution, TestPlanExploratorySessionOverviewDisplayDao.NameAndReference overviewNameAndRef) {
            execution.setName(this.buildExecutionName(overviewNameAndRef));
            execution.setReference(overviewNameAndRef.reference());
        }

        private String buildExecutionName(TestPlanExploratorySessionOverviewDisplayDao.NameAndReference overviewNameAndRef) {
            if (overviewNameAndRef.reference().isEmpty()) {
                return overviewNameAndRef.name();
            }
            return overviewNameAndRef.reference() + " - " + overviewNameAndRef.name();
        }

        private void createExecutionStepsForScriptedTestCase(ScriptedExecution scriptedExecution) {
            scriptedExecution.getReferencedTestCase().accept((TestCaseVisitor)new ConsumerForScriptedTestCaseVisitor(scriptedTestCase -> ExecutionCreationServiceImpl.this.scriptedTestCaseExecutionHelper.createExecutionStepsForScriptedTestCase(scriptedExecution)));
        }

        private void createCustomFieldsForExecutionAndExecutionSteps(Execution execution) {
            ExecutionCreationServiceImpl.this.customFieldValueService.createAllCustomFieldValues((BoundEntity)execution, execution.getProject());
            ExecutionCreationServiceImpl.this.customFieldValueService.createAllCustomFieldValues(execution.getSteps(), execution.getProject());
        }

        private void createCustomAndDenormalizedFieldsForExecution(Execution execution) {
            ExecutionCreationServiceImpl.this.customFieldValueService.createAllCustomFieldValues((BoundEntity)execution, execution.getProject());
            this.createDenormalizedFieldsForExecution(execution);
        }

        private void createDenormalizedFieldsForExecutionAndExecutionSteps(Execution execution) {
            this.createDenormalizedFieldsForExecution(execution);
            ExecutionCreationServiceImpl.this.denormalizedFieldValueService.createAllDenormalizedFieldValuesForSteps(execution);
        }

        private void createDenormalizedFieldsForExecution(Execution execution) {
            TestCase referencedTestCase = execution.getReferencedTestCase();
            ExecutionCreationServiceImpl.this.denormalizedFieldValueService.createAllDenormalizedFieldValues((BoundEntity)referencedTestCase, (DenormalizedFieldHolder)execution);
        }
    }
}

