/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.hibernate.Hibernate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.domain.bdd.SupportedLanguage;
import org.squashtest.tm.domain.infolist.UserListItem;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.artificialintelligence.testcasegeneration.AiTestCaseGenerationViewService;
import org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration.AiTestCaseGenerationViewServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration.AiTestCaseGenerationViewServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration.RequirementTranslationService;
import org.squashtest.tm.service.internal.display.dto.PromptDto;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.display.PromptDisplayDao;
import org.squashtest.tm.service.internal.templaterenderer.HandlebarsTemplateRenderer;

@Service
@Transactional
public class AiTestCaseGenerationViewServiceImpl
implements AiTestCaseGenerationViewService {
    protected static final String CATEGORY = "category";
    protected static final String CRITICALITY = "criticality";
    protected static final String NATURE = "nature";
    protected static final String HIGH_LEVEL = "HIGH_LEVEL";
    protected static final String CLASSIC = "CLASSIC";
    private static final String REQUIREMENT = "requirement";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String REFERENCE = "reference";
    private final PromptDisplayDao promptDisplayDao;
    private final RequirementVersionDao requirementVersionDao;
    private final GenericProjectDao projectDao;
    private final RequirementTranslationService translationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public AiTestCaseGenerationViewServiceImpl(PromptDisplayDao promptDisplayDao, RequirementVersionDao requirementVersionDao, GenericProjectDao projectDao, RequirementTranslationService translationService) {
        this.promptDisplayDao = promptDisplayDao;
        this.requirementVersionDao = requirementVersionDao;
        this.projectDao = projectDao;
        this.translationService = translationService;
    }

    @Override
    @IsUltimateLicenseAvailable
    public List<PromptDto> findAllPromptsByRequirementVersionId(Long requirementVersionId) {
        List<PromptDto> prompts = this.promptDisplayDao.findAllForClassicTcGenerationByReqVersionId(requirementVersionId);
        RequirementVersion requirementVersion = (RequirementVersion)this.requirementVersionDao.findById(requirementVersionId).orElseThrow();
        Long projectId = this.requirementVersionDao.findProjectIdByRequirementVersionId(requirementVersionId);
        SupportedLanguage aiPromptLanguage = SupportedLanguage.valueOf((String)this.projectDao.findAiPromptLanguageByProjectId(projectId));
        Map<String, Object> variableValueByPlaceholder = this.getVariableValueByPlaceholder(requirementVersion, aiPromptLanguage);
        prompts.forEach(prompt -> {
            PromptDto promptDto = prompt;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, (Object)promptDto);
            Object[] objectArray = new Object[]{promptDto, joinPoint};
            AiTestCaseGenerationViewServiceImpl$AjcClosure1 aiTestCaseGenerationViewServiceImpl$AjcClosure1 = new AiTestCaseGenerationViewServiceImpl$AjcClosure1(objectArray);
            if ((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(aiTestCaseGenerationViewServiceImpl$AjcClosure1.linkClosureAndJoinPoint(16)) == null) {
                throw new IllegalArgumentException("User prompt cannot be null");
            }
            PromptDto promptDto2 = prompt;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, (Object)promptDto2);
            Object[] objectArray2 = new Object[]{promptDto2, joinPoint2};
            AiTestCaseGenerationViewServiceImpl$AjcClosure3 aiTestCaseGenerationViewServiceImpl$AjcClosure3 = new AiTestCaseGenerationViewServiceImpl$AjcClosure3(objectArray2);
            String htmlPrompt = HtmlUtils.htmlEscape((String)((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(aiTestCaseGenerationViewServiceImpl$AjcClosure3.linkClosureAndJoinPoint(16)))).replace("\n", "<br>");
            String userPromptWithRealValues = HandlebarsTemplateRenderer.renderTemplate(htmlPrompt, variableValueByPlaceholder);
            prompt.setUserPromptTemplate(userPromptWithRealValues);
        });
        return prompts;
    }

    private Map<String, Object> getVariableValueByPlaceholder(RequirementVersion requirementVersion, SupportedLanguage aiPromptLanguage) {
        String criticalityCode = requirementVersion.getCriticality().name();
        String categoryCode = requirementVersion.getCategory().getCode();
        String natureCode = requirementVersion.getRequirement().isHighLevel() ? HIGH_LEVEL : CLASSIC;
        HashMap<String, String> requirementMap = new HashMap<String, String>();
        requirementMap.put(NAME, requirementVersion.getName());
        requirementMap.put(CRITICALITY, this.translationService.translate(aiPromptLanguage, CRITICALITY, criticalityCode));
        if (Hibernate.getClass((Object)requirementVersion.getCategory()).equals(UserListItem.class)) {
            requirementMap.put(CATEGORY, categoryCode);
        } else {
            requirementMap.put(CATEGORY, this.translationService.translate(aiPromptLanguage, CATEGORY, categoryCode));
        }
        requirementMap.put(NATURE, this.translationService.translate(aiPromptLanguage, NATURE, natureCode));
        requirementMap.put(DESCRIPTION, requirementVersion.getDescription());
        String reference = requirementVersion.getReference();
        if (reference != null && !reference.isBlank()) {
            requirementMap.put(REFERENCE, reference);
        }
        HashMap<String, Object> variableValueByPlaceholder = new HashMap<String, Object>();
        variableValueByPlaceholder.put(REQUIREMENT, requirementMap);
        return variableValueByPlaceholder;
    }

    static {
        AiTestCaseGenerationViewServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ String getUserPromptTemplate_aroundBody0(PromptDto promptDto, JoinPoint joinPoint) {
        return promptDto.getUserPromptTemplate();
    }

    static final /* synthetic */ String getUserPromptTemplate_aroundBody2(PromptDto promptDto, JoinPoint joinPoint) {
        return promptDto.getUserPromptTemplate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AiTestCaseGenerationViewServiceImpl.java", AiTestCaseGenerationViewServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getUserPromptTemplate", "org.squashtest.tm.service.internal.display.dto.PromptDto", "", "", "", "java.lang.String"), 87);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getUserPromptTemplate", "org.squashtest.tm.service.internal.display.dto.PromptDto", "", "", "", "java.lang.String"), 91);
    }
}

