/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultimport;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.DenormalizedCustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.MultiValuedCustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.service.internal.dto.resultimport.CustomFieldDto;
import org.squashtest.tm.service.internal.dto.resultimport.PartialErrorDto;
import org.squashtest.tm.service.testautomation.resultimport.CustomFieldImportVerificationService;

@Service
public class CustomFieldImportVerificationServiceImpl
implements CustomFieldImportVerificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldImportVerificationServiceImpl.class);

    @Override
    public RawValue parseCustomFieldDtoValue(CustomFieldDto customFieldDto, Execution execution, CustomFieldValue customFieldValue, PartialErrorDto partialErrors) {
        boolean isValueList;
        Object fieldValue = customFieldDto.getValue();
        if (!this.isNotNullCustomFieldValue(fieldValue, customFieldValue.getCustomField(), execution, partialErrors)) {
            return null;
        }
        boolean isMultiValued = MultiValuedCustomFieldValue.class.isAssignableFrom(customFieldValue.getClass());
        if (isMultiValued != (isValueList = fieldValue instanceof ArrayList)) {
            String errorMessage = isMultiValued ? "Custom field '%s' must have a list of values." : "Custom field '%s' must have a single value, not a list.";
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), errorMessage.formatted(customFieldDto.getCode(), execution.getReferencedTestCase().getAutomatedTestReference()));
            return null;
        }
        if (this.isMissingRequiredValue(isMultiValued, fieldValue, customFieldValue.getCustomField(), execution, partialErrors)) {
            return null;
        }
        return isMultiValued ? new RawValue((List)((ArrayList)fieldValue)) : new RawValue(String.valueOf(fieldValue));
    }

    @Override
    public boolean isValidCustomFieldValue(Execution execution, CustomField customField, RawValue rawValue, PartialErrorDto partialErrors) {
        return switch (customField.getInputType()) {
            case InputType.DATE_PICKER -> this.isValidDateField(rawValue, customField, execution, partialErrors);
            case InputType.CHECKBOX -> this.isValidCheckboxField(rawValue, customField, execution, partialErrors);
            case InputType.NUMERIC -> this.isValidNumericField(rawValue, customField, execution, partialErrors);
            case InputType.TAG -> this.isValidTagField(customField, rawValue, execution, partialErrors);
            case InputType.DROPDOWN_LIST -> this.isValidDropdownField(customField, rawValue, execution, partialErrors);
            default -> {
                LOGGER.warn("No specific validation for custom field type '{}'. Custom field: '{}'", (Object)customField.getInputType(), (Object)customField.getName());
                yield true;
            }
        };
    }

    private boolean isNotNullCustomFieldValue(Object fieldValue, CustomField customField, Execution execution, PartialErrorDto partialErrors) {
        if (fieldValue == null) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field '%s' must have a value.".formatted(customField.getCode()));
            return false;
        }
        return true;
    }

    @Override
    public void checkForDuplicates(Execution execution, List<CustomFieldDto> customFields, PartialErrorDto partialErrors) {
        HashSet seenFields = new HashSet();
        List<CustomFieldDto> fieldsToRemove = customFields.stream().filter(customField -> !seenFields.add(customField.getCode())).peek(customField -> partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field '%s' is duplicated. Only the first occurrence will be kept.".formatted(customField.getCode()))).toList();
        customFields.removeAll(fieldsToRemove);
    }

    private boolean isValidDateField(RawValue rawValue, CustomField customField, Execution execution, PartialErrorDto partialErrors) {
        try {
            DateUtils.parseIso8601Date((String)rawValue.getValue());
        }
        catch (ParseException parseException) {
            CustomFieldImportVerificationServiceImpl.addDateError(rawValue, customField, execution, partialErrors);
            return false;
        }
        if (!DateUtils.weakCheckIso8601Date((String)rawValue.getValue())) {
            CustomFieldImportVerificationServiceImpl.addDateError(rawValue, customField, execution, partialErrors);
            return false;
        }
        return true;
    }

    private static void addDateError(RawValue rawValue, CustomField customField, Execution execution, PartialErrorDto partialErrors) {
        partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field '%s' must be a valid 'yyyy-mm-dd' date. Current value: '%s'.".formatted(customField.getName(), rawValue.getValue()));
    }

    private boolean isValidCheckboxField(RawValue rawValue, CustomField customField, Execution execution, PartialErrorDto partialErrors) {
        if (!"true".equals(rawValue.getValue()) && !"false".equals(rawValue.getValue())) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field '%s' must be either true or false.".formatted(customField.getName()));
            return false;
        }
        return true;
    }

    private boolean isValidNumericField(RawValue rawValue, CustomField customField, Execution execution, PartialErrorDto partialErrors) {
        try {
            Double.parseDouble(rawValue.getValue());
            if (Math.abs(Double.parseDouble(rawValue.getValue())) >= 1.0E15) {
                partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field '%s' must be a number with an absolute value less than 10^15.".formatted(customField.getName()));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field '%s' must be a valid number.".formatted(customField.getName()));
            return false;
        }
        return true;
    }

    private boolean isValidTagField(CustomField customField, RawValue rawValue, Execution execution, PartialErrorDto partialErrors) {
        if (rawValue.getValues() != null && rawValue.getValues().stream().distinct().count() != (long)rawValue.getValues().size()) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field '%s' has duplicate values: '%s'. Only one occurrence will be kept.".formatted(customField.getName(), rawValue.getValues()));
            rawValue.setValues(new ArrayList(Set.copyOf(rawValue.getValues())));
        }
        return true;
    }

    private boolean isValidDropdownField(CustomField customField, RawValue rawValue, Execution execution, PartialErrorDto partialErrors) {
        List allowedValues = ((SingleSelectField)customField).getOptions();
        if (allowedValues.stream().noneMatch(option -> option.getLabel().equals(rawValue.getValue()))) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field '%s' has an invalid value: '%s'. Allowed values are: %s.".formatted(customField.getName(), rawValue.getValue(), allowedValues.stream().map(DenormalizedCustomFieldOption::getLabel).collect(Collectors.joining(", "))));
            return false;
        }
        return true;
    }

    private boolean isMissingRequiredValue(boolean isMultiValued, Object fieldValue, CustomField customField, Execution execution, PartialErrorDto partialErrors) {
        boolean isEmpty;
        if (customField.isOptional()) {
            return false;
        }
        boolean bl = isEmpty = isMultiValued ? this.isMultiValuedEmpty(fieldValue) : this.isSingleValuedEmpty(fieldValue);
        if (isEmpty) {
            this.addMissingRequiredValueError(customField, execution, partialErrors, isMultiValued);
            return true;
        }
        return false;
    }

    private boolean isMultiValuedEmpty(Object fieldValue) {
        List values = (List)fieldValue;
        values.removeAll(Arrays.asList("", null));
        return values.isEmpty();
    }

    private boolean isSingleValuedEmpty(Object fieldValue) {
        return String.valueOf(fieldValue).isEmpty();
    }

    private void addMissingRequiredValueError(CustomField customField, Execution execution, PartialErrorDto partialErrors, boolean isMultiValued) {
        String message = isMultiValued ? "Custom field '%s' is mandatory and must have at least one non-empty value." : "Custom field '%s' is mandatory and must have a non-empty value.";
        partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), message.formatted(customField.getCode()));
    }
}

