/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.containerloader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ParentPivotEntity;

public class ContainerLoader {
    private final Map<Long, NodeContainer<? extends TreeNode>> containers = new HashMap<Long, NodeContainer<? extends TreeNode>>();
    private final Map<String, Long> pivotIdConversion;

    public ContainerLoader(Map<String, Long> pivotIdConversion) {
        this.pivotIdConversion = pivotIdConversion;
    }

    public <E extends ParentPivotEntity, T extends TreeNode> NodeContainer<T> getContainer(E pivotEntity) {
        if (ContainerLoader.isLibraryParentType(pivotEntity.getParentType())) {
            return this.containers.values().iterator().next();
        }
        Long containerId = this.pivotIdConversion.get(pivotEntity.getParentId());
        NodeContainer<? extends TreeNode> container = this.containers.get(containerId);
        if (container == null) {
            throw new IllegalStateException(String.format("No container found for folder pivot %s with parent id %s", pivotEntity, pivotEntity.getParentId()));
        }
        return container;
    }

    public void addContainer(NodeContainer<? extends TreeNode> container) {
        this.containers.put(container.getId(), container);
    }

    public static boolean isLibraryParentType(EntityType parentType) {
        return EntityType.REQUIREMENT_LIBRARY.equals((Object)parentType) || EntityType.TEST_CASE_LIBRARY.equals((Object)parentType) || EntityType.CAMPAIGN_LIBRARY.equals((Object)parentType);
    }

    public <E extends ParentPivotEntity> Set<Long> getIdFromPivotParentId(List<E> parentPivotEntities) {
        return parentPivotEntities.stream().map(parentPivotEntity -> this.pivotIdConversion.get(parentPivotEntity.getParentId())).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

