/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.requirements;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.display.requirements.RequirementDisplayService;
import org.squashtest.tm.service.display.requirements.RequirementPathFinderService;
import org.squashtest.tm.service.display.testcase.TestCasePathFinderService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.RequirementVersionKnownIssueFinder;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.dto.requirement.AbstractRequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.HighLevelRequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementFolderDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementLibraryDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementMultiSelectionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionBundleStatsDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionLinkDto;
import org.squashtest.tm.service.internal.display.dto.requirement.VerifyingTestCaseDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ModificationHistoryDisplayDao;
import org.squashtest.tm.service.internal.repository.display.RequirementDisplayDao;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionDisplayDao;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionLinkDisplayDao;
import org.squashtest.tm.service.internal.repository.display.VerifyingTestCaseDisplayDao;
import org.squashtest.tm.service.plugin.ConfigurablePluginManager;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;
import org.squashtest.tm.service.requirement.RequirementHelper;
import org.squashtest.tm.service.requirement.RequirementStatisticsService;
import org.squashtest.tm.service.statistics.testingstatus.RemoteTestingStatusDao;
import org.squashtest.tm.service.user.PartyPreferenceService;

@Service
@Transactional(readOnly=true)
public class RequirementDisplayServiceImpl
implements RequirementDisplayService {
    private final RequirementVersionDisplayDao requirementVersionDisplayDao;
    private final CustomFieldValueDisplayDao customFieldValueDisplayDao;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final MilestoneDisplayDao milestoneDisplayDao;
    private final RequirementDisplayDao requirementDisplayDao;
    private final VerifyingTestCaseDisplayDao verifyingTestCaseDisplayDao;
    private final RequirementVersionLinkDisplayDao requirementVersionLinkDisplayDao;
    private final RequirementStatisticsService requirementStatisticsService;
    private final ModificationHistoryDisplayDao modificationHistoryDisplayDao;
    private final RequirementVersionKnownIssueFinder requirementVersionKnownIssueFinder;
    private final CustomReportDashboardService customReportDashboardService;
    private final PartyPreferenceService partyPreferenceService;
    private final HighLevelRequirementService highLevelRequirementService;
    private final TestCasePathFinderService testCasePathService;
    private final RequirementPathFinderService requirementsPathService;
    private final RequirementHelper requirementHelper;
    private final RequirementDao requirementDao;
    private final RemoteTestingStatusDao remoteTestingStatusDao;
    private final EntityPathHeaderService pathService;
    private final ConfigurablePluginManager configurablePluginManager;

    public RequirementDisplayServiceImpl(RequirementVersionDisplayDao requirementVersionDisplayDao, CustomFieldValueDisplayDao customFieldValueDisplayDao, AttachmentDisplayDao attachmentDisplayDao, MilestoneDisplayDao milestoneDisplayDao, RequirementDisplayDao requirementDisplayDao, VerifyingTestCaseDisplayDao verifyingTestCaseDisplayDao, RequirementVersionLinkDisplayDao requirementVersionLinkDisplayDao, ModificationHistoryDisplayDao modificationHistoryDisplayDao, RequirementStatisticsService requirementStatisticsService, RequirementVersionKnownIssueFinder requirementVersionKnownIssueFinder, CustomReportDashboardService customReportDashboardService, PartyPreferenceService partyPreferenceService, HighLevelRequirementService highLevelRequirementService, TestCasePathFinderService testCasePathService, RequirementPathFinderService requirementsPathService, RequirementHelper requirementHelper, RequirementDao requirementDao, RemoteTestingStatusDao remoteTestingStatusDao, EntityPathHeaderService pathService, ConfigurablePluginManager configurablePluginManager) {
        this.requirementVersionDisplayDao = requirementVersionDisplayDao;
        this.customFieldValueDisplayDao = customFieldValueDisplayDao;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.milestoneDisplayDao = milestoneDisplayDao;
        this.requirementDisplayDao = requirementDisplayDao;
        this.verifyingTestCaseDisplayDao = verifyingTestCaseDisplayDao;
        this.requirementVersionLinkDisplayDao = requirementVersionLinkDisplayDao;
        this.requirementStatisticsService = requirementStatisticsService;
        this.modificationHistoryDisplayDao = modificationHistoryDisplayDao;
        this.requirementVersionKnownIssueFinder = requirementVersionKnownIssueFinder;
        this.customReportDashboardService = customReportDashboardService;
        this.partyPreferenceService = partyPreferenceService;
        this.highLevelRequirementService = highLevelRequirementService;
        this.testCasePathService = testCasePathService;
        this.requirementsPathService = requirementsPathService;
        this.requirementHelper = requirementHelper;
        this.requirementDao = requirementDao;
        this.remoteTestingStatusDao = remoteTestingStatusDao;
        this.pathService = pathService;
        this.configurablePluginManager = configurablePluginManager;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'READ') or hasRole('ROLE_ADMIN')")
    public AbstractRequirementVersionDto findCurrentVersionView(Long requirementId) {
        Long currentVersionId = this.requirementVersionDisplayDao.findCurrentRequirementVersions(requirementId);
        if (this.requirementVersionIsLinkedToHighLevelRequirement(currentVersionId)) {
            return this.createHighLevelRequirementVersionDto(currentVersionId);
        }
        return this.createRequirementVersionDto(currentVersionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'READ') or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=Requirement.class)
    public HighLevelRequirementVersionDto findHighLevelCurrentVersionView(@Id Long requirementId) {
        Long currentVersionId = this.requirementVersionDisplayDao.findCurrentRequirementVersions(requirementId);
        return this.createHighLevelRequirementVersionDto(currentVersionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'READ') or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=RequirementVersion.class)
    public AbstractRequirementVersionDto findVersionView(@Id Long requirementVersionId) {
        if (this.requirementVersionIsLinkedToHighLevelRequirement(requirementVersionId)) {
            return this.createHighLevelRequirementVersionDto(requirementVersionId);
        }
        return this.createRequirementVersionDto(requirementVersionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'READ') or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=RequirementVersion.class)
    public RequirementVersionBundleStatsDto computeRequirementVersionStatistics(@Id Long requirementVersionId) {
        if (this.requirementVersionIsLinkedToHighLevelRequirement(requirementVersionId)) {
            return this.requirementStatisticsService.findCoveragesStatsByHighLvlReqVersionId(requirementVersionId);
        }
        return this.requirementStatisticsService.findCoveragesStatsByRequirementVersionId(requirementVersionId);
    }

    private boolean requirementVersionIsLinkedToHighLevelRequirement(Long requirementVersionId) {
        return this.requirementDao.isHighLevelRequirementVersion(requirementVersionId);
    }

    @Override
    public List<VerifyingTestCaseDto> findVerifyingTestCasesByHighLvlReqIdForCurrentVersion(Long highLvlReqId) {
        Long highLvlReqCurrentVersionId = this.requirementDao.findRequirementCurrentVersionIdFromRequirementId(highLvlReqId);
        return this.findVerifyingTestCasesByHighLvlReqVersionId(highLvlReqCurrentVersionId);
    }

    @Override
    public List<VerifyingTestCaseDto> findVerifyingTestCasesByHighLvlReqVersionId(Long requirementVersionId) {
        List<VerifyingTestCaseDto> verifyingTestCaseDtoList = this.verifyingTestCaseDisplayDao.findByHighLevelRequirementVersionId(requirementVersionId);
        verifyingTestCaseDtoList.forEach(verifyingTestCaseDto -> verifyingTestCaseDto.setPath(this.testCasePathService.buildTestCasePath(verifyingTestCaseDto.getId(), verifyingTestCaseDto.getProjectName())));
        return verifyingTestCaseDtoList;
    }

    @Override
    public Integer countIssuesByHighLvlReqId(Long highLevelReqId) {
        Long highLvlReqVersionId = this.requirementHelper.findRequirementVersionIdFromRequirementId(highLevelReqId);
        return this.requirementVersionKnownIssueFinder.countKnownIssues(highLvlReqVersionId);
    }

    @Override
    public Integer countIssuesByRequirementVersionId(Long requirementVersionId) {
        return this.requirementVersionKnownIssueFinder.countKnownIssues(requirementVersionId);
    }

    @Override
    public Long findRequirementIdByRequirementVersionId(Long requirementVersionId) {
        return this.requirementDao.findRequirementIdFromVersionId(requirementVersionId);
    }

    @Override
    public boolean isVersionCurrentVersion(Long requirementId, Long requirementVersionId) {
        Long currentVersionId = this.requirementDao.findRequirementCurrentVersionIdFromRequirementId(requirementId);
        return currentVersionId.equals(requirementVersionId);
    }

    private RequirementVersionDto createRequirementVersionDto(Long requirementVersionId) {
        RequirementVersionDto requirementVersion = this.requirementVersionDisplayDao.findRequirementVersion(requirementVersionId);
        this.appendPathToLinkedHighLevelRequirement(requirementVersion);
        this.appendRequirementCommonData(requirementVersion);
        requirementVersion.setVerifyingTestCases(this.findVerifyingTestCasesByRequirementVersionId(requirementVersionId));
        requirementVersion.setRequirementVersionLinks(this.findLinkedRequirementsByRequirementVersionId(requirementVersionId));
        Long requirementId = this.requirementDao.findRequirementIdFromVersionId(requirementVersionId);
        requirementVersion.setChildOfRequirement(this.requirementDao.checkIfRequirementIsChild(requirementId));
        this.appendSyncRequirementIdsByRemoteSyncId(requirementVersion);
        this.appendCanRequirementBeConvertedToHighLevelOrStandard(requirementVersion);
        return requirementVersion;
    }

    private void appendPathToLinkedHighLevelRequirement(RequirementVersionDto requirementVersion) {
        RequirementVersionDto.LinkedHighLevelRequirementDto linkedHighLevelRequirement = requirementVersion.getLinkedHighLevelRequirement();
        if (linkedHighLevelRequirement != null) {
            String path = this.requirementsPathService.buildRequirementLinkPath(linkedHighLevelRequirement.getRequirementId(), linkedHighLevelRequirement.getProjectName());
            linkedHighLevelRequirement.setPath(path);
        }
        requirementVersion.setLinkedHighLevelRequirement(linkedHighLevelRequirement);
    }

    private HighLevelRequirementVersionDto createHighLevelRequirementVersionDto(Long requirementVersionId) {
        HighLevelRequirementVersionDto requirementVersion = this.requirementVersionDisplayDao.findHighLevelRequirementVersion(requirementVersionId);
        this.appendRequirementCommonData(requirementVersion);
        requirementVersion.setLowLevelRequirements(this.highLevelRequirementService.findLinkedLowLevelRequirements(requirementVersion.getRequirementId()));
        requirementVersion.setVerifyingTestCases(this.findVerifyingTestCasesByHighLvlReqVersionId(requirementVersionId));
        requirementVersion.setRequirementVersionLinks(this.findLinkedRequirementsByRequirementVersionId(requirementVersionId));
        this.appendSyncRequirementIdsByRemoteSyncId(requirementVersion);
        this.appendCanRequirementBeConvertedToHighLevelOrStandard(requirementVersion);
        return requirementVersion;
    }

    private void appendCanRequirementBeConvertedToHighLevelOrStandard(AbstractRequirementVersionDto requirementVersion) {
        boolean isInCurrentPerimeter;
        RemoteRequirementPerimeterStatus remoteSyncStatus = requirementVersion.getRemoteReqPerimeterStatus();
        boolean bl = isInCurrentPerimeter = Objects.nonNull(remoteSyncStatus) && remoteSyncStatus.equals((Object)RemoteRequirementPerimeterStatus.IN_CURRENT_PERIMETER);
        if (!isInCurrentPerimeter) {
            requirementVersion.setCanBeConvertedToHighLevelOrStandard(true);
        } else {
            boolean pluginFoundAndActivated = this.configurablePluginManager.isPluginFoundAndActivated(requirementVersion.getProjectId(), requirementVersion.getRemoteSynchronisationKind());
            requirementVersion.setCanBeConvertedToHighLevelOrStandard(!requirementVersion.isHasExtender() || !pluginFoundAndActivated);
        }
    }

    private void appendRequirementCommonData(AbstractRequirementVersionDto requirementVersion) {
        Long requirementVersionId = requirementVersion.getId();
        requirementVersion.setBreadcrumbs(this.pathService.getRequirementLibraryNodeHeaderBreadcrumbs(requirementVersion.getRequirementId()));
        requirementVersion.setCustomFieldValues(this.customFieldValueDisplayDao.findCustomFieldValues(BindableEntity.REQUIREMENT_VERSION, requirementVersionId));
        requirementVersion.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(requirementVersion.getAttachmentListId()));
        requirementVersion.setMilestones(this.milestoneDisplayDao.getMilestonesByRequirementVersionId(requirementVersionId));
        requirementVersion.setBindableMilestones(this.milestoneDisplayDao.getMilestonesDtoAssociableToRequirementVersion(requirementVersionId));
    }

    private void appendSyncRequirementIdsByRemoteSyncId(AbstractRequirementVersionDto requirementVersion) {
        String remoteReqId = requirementVersion.getRemoteReqId();
        if (remoteReqId != null) {
            List<Long> syncReqIdsForRemoteSyncId = this.remoteTestingStatusDao.findRequirementIdsForOneRemoteKeyAndServerId(requirementVersion.getRemoteSynchronisationKind(), remoteReqId, requirementVersion.getServerId());
            requirementVersion.setSyncReqIdsForRemoteSyncId(syncReqIdsForRemoteSyncId);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public List<MilestoneDto> findBindableMilestones(Long requirementVersionId) {
        return this.milestoneDisplayDao.getMilestonesDtoAssociableToRequirementVersion(requirementVersionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.requirement.RequirementLibrary', 'READ')  or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=CampaignLibrary.class)
    public RequirementLibraryDto findLibrary(@Id long libraryId) {
        RequirementLibraryDto libraryDto = this.requirementDisplayDao.findRequirementLibraryDtoById(libraryId);
        libraryDto.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(libraryDto.getAttachmentListId()));
        this.appendFavoriteDashboardInformation(libraryDto);
        return libraryDto;
    }

    private void appendFavoriteDashboardInformation(RequirementLibraryDto libraryDto) {
        libraryDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.REQUIREMENT));
        libraryDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.REQUIREMENT));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_REQUIREMENT.getPreferenceKey());
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            libraryDto.setFavoriteDashboardId(dashboardId);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementFolderId, 'org.squashtest.tm.domain.requirement.RequirementFolder', 'READ') or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=RequirementFolder.class)
    public RequirementFolderDto getRequirementFolderView(@Id long requirementFolderId) {
        RequirementFolderDto requirementFolder = this.requirementDisplayDao.getRequirementFolderDtoById(requirementFolderId);
        requirementFolder.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(requirementFolder.getAttachmentListId()));
        requirementFolder.setCustomFieldValues(this.customFieldValueDisplayDao.findCustomFieldValues(BindableEntity.REQUIREMENT_FOLDER, requirementFolderId));
        this.appendFavoriteDashboardInformation(requirementFolder);
        requirementFolder.setBreadcrumbs(this.pathService.getRequirementLibraryNodeHeaderBreadcrumbs(requirementFolderId));
        return requirementFolder;
    }

    private void appendFavoriteDashboardInformation(RequirementFolderDto requirementFolderDto) {
        requirementFolderDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.REQUIREMENT));
        requirementFolderDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.REQUIREMENT));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_REQUIREMENT.getPreferenceKey());
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            requirementFolderDto.setFavoriteDashboardId(dashboardId);
        }
    }

    @Override
    public List<VerifyingTestCaseDto> findVerifyingTestCasesByRequirementVersionId(Long requirementVersionId) {
        List<VerifyingTestCaseDto> verifyingTestCasesDtos = this.verifyingTestCaseDisplayDao.findByRequirementVersionIds(new HashSet<Long>(Collections.singletonList(requirementVersionId)));
        for (VerifyingTestCaseDto testCase : verifyingTestCasesDtos) {
            testCase.setPath(this.testCasePathService.buildTestCasePath(testCase.getId(), testCase.getProjectName()));
        }
        return verifyingTestCasesDtos;
    }

    @Override
    public List<RequirementVersionLinkDto> findLinkedRequirementsByRequirementVersionId(Long requirementVersionId) {
        List<RequirementVersionLinkDto> requirementsVersionLinkDtos = this.requirementVersionLinkDisplayDao.findLinksByRequirementVersionId(requirementVersionId);
        for (RequirementVersionLinkDto requirementVersionLinkDto : requirementsVersionLinkDtos) {
            requirementVersionLinkDto.setPath(this.requirementsPathService.buildRequirementLinkPath(requirementVersionLinkDto.getRequirementId(), requirementVersionLinkDto.getProjectName()));
        }
        return requirementsVersionLinkDtos;
    }

    @Override
    public Map<String, String> findRequirementVersionNamesByRequirementIds(List<Long> requirementIds) {
        List<String> reqVersionNames = this.requirementDisplayDao.findRequirementVersionNamesByRequirementIds(requirementIds);
        HashMap<String, String> versionNames = new HashMap<String, String>();
        versionNames.put("versionName", String.join((CharSequence)",", reqVersionNames));
        return versionNames;
    }

    @Override
    public GridResponse findCurrentVersionModificationHistoryByRequirementVersionId(Long requirementVersionId, GridRequest request) {
        return this.modificationHistoryDisplayDao.findGridByRequirementVersionId(requirementVersionId, request);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'READ') or hasRole('ROLE_ADMIN')")
    public GridResponse findVersionsByRequirementId(Long requirementId, GridRequest request) {
        return this.requirementDisplayDao.findVersionsById(requirementId, request);
    }

    @Override
    public RequirementMultiSelectionDto getRequirementMultiView() {
        RequirementMultiSelectionDto requirementMultiSelectionDto = new RequirementMultiSelectionDto();
        requirementMultiSelectionDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.REQUIREMENT));
        requirementMultiSelectionDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.REQUIREMENT));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_REQUIREMENT.getPreferenceKey());
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            requirementMultiSelectionDto.setFavoriteDashboardId(dashboardId);
        }
        return requirementMultiSelectionDto;
    }

    @Override
    public RequirementVersionDto.LinkedHighLevelRequirementDto findLinkedHighLevelRequirement(Long requirementId) {
        return this.requirementVersionDisplayDao.findLinkedHighLevelRequirement(requirementId);
    }
}

