/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.internal.artificialintelligence.common.AbstractContentChunk;
import org.squashtest.tm.service.internal.artificialintelligence.common.ImageChunk;
import org.squashtest.tm.service.internal.artificialintelligence.common.TextChunk;
import org.squashtest.tm.service.internal.artificialintelligence.common.image.BmpToPngBase64Converter;

@Service
public class MessageChunkParser {
    private static final Pattern ATTACHMENT_ID_PATTERN = Pattern.compile("attach-list/\\d+/attachments/download/(\\d+)");
    private static final Pattern DATA_IMAGE_PATTERN = Pattern.compile("data:image/(.+?);base64,(.+)");
    private final AttachmentManagerService attachmentFinderService;

    public MessageChunkParser(AttachmentManagerService attachmentFinderService) {
        this.attachmentFinderService = attachmentFinderService;
    }

    public List<AbstractContentChunk> parseMessageChunks(String userMessage) {
        String afterImg;
        if (userMessage == null || userMessage.trim().isEmpty()) {
            throw new IllegalArgumentException("User message cannot be null or empty");
        }
        ArrayList<AbstractContentChunk> chunks = new ArrayList<AbstractContentChunk>();
        Pattern imgPattern = Pattern.compile("(<img[^>]*>)", 2);
        Matcher matcher = imgPattern.matcher(userMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            String imgHtml;
            Document imgDoc;
            Element imgEl;
            String beforeImg = userMessage.substring(lastEnd, matcher.start()).trim();
            if (!beforeImg.isEmpty()) {
                chunks.add(new TextChunk(beforeImg));
            }
            if ((imgEl = (imgDoc = Jsoup.parseBodyFragment((String)(imgHtml = matcher.group(1)))).selectFirst("img")) == null) {
                throw new IllegalArgumentException("Image HTML could not be parsed: " + imgHtml);
            }
            String src = imgEl.attr("src");
            if (src.trim().isEmpty()) {
                throw new IllegalArgumentException("Image src is missing or empty: " + imgHtml);
            }
            chunks.add(this.extractImageChunk(src));
            lastEnd = matcher.end();
        }
        if (lastEnd < userMessage.length() && !(afterImg = userMessage.substring(lastEnd).trim()).isEmpty()) {
            chunks.add(new TextChunk(afterImg));
        }
        return Collections.unmodifiableList(chunks);
    }

    private ImageChunk extractImageChunk(String src) {
        Matcher srcBase64Matcher = DATA_IMAGE_PATTERN.matcher(src);
        if (srcBase64Matcher.matches()) {
            String base64 = srcBase64Matcher.group(2);
            String realType = this.detectImageType(base64);
            if ("bmp".equals(realType)) {
                base64 = BmpToPngBase64Converter.convert(base64);
                realType = "png";
                return new ImageChunk(base64, realType);
            }
            return new ImageChunk(base64, realType);
        }
        Long attachmentId = this.extractAttachmentId(src);
        Map<String, String> base64AndType = this.attachmentFinderService.extractBase64AndTypeFromImageAttachment(attachmentId);
        if (base64AndType == null) {
            throw new IllegalArgumentException(String.format("Attachment with ID %s cannot be found", attachmentId));
        }
        String base64 = base64AndType.get("base64");
        String type = base64AndType.get("type");
        if (base64 == null || type == null) {
            throw new IllegalArgumentException("Missing base64 or type for attachment ID: " + String.valueOf(attachmentId));
        }
        if ("bmp".equals(type)) {
            return new ImageChunk(BmpToPngBase64Converter.convert(base64), "png");
        }
        return new ImageChunk(base64, type);
    }

    private Long extractAttachmentId(String src) {
        Matcher matcher = ATTACHMENT_ID_PATTERN.matcher(src);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.format("Could not find attachment ID in src URL: %s", src));
        }
        try {
            return Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid attachment ID in src URL: %s", src), e);
        }
    }

    public String detectImageType(String base64) {
        byte[] bytes = Base64.getDecoder().decode(base64);
        if (this.startsWith(bytes, new byte[]{-119, 80, 78, 71})) {
            return "png";
        }
        if (this.startsWith(bytes, new byte[]{-1, -40})) {
            return "jpeg";
        }
        if (this.startsWith(bytes, new byte[]{66, 77})) {
            return "bmp";
        }
        if (this.startsWith(bytes, new byte[]{71, 73, 70})) {
            return "gif";
        }
        throw new IllegalArgumentException("Unknown image type for provided base64.");
    }

    private boolean startsWith(byte[] data, byte[] prefix) {
        return data.length >= prefix.length && Arrays.equals(data, 0, prefix.length, prefix, 0, prefix.length);
    }
}

