/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.AiServices;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.service.artificialintelligence.AiChatClientProvider;
import org.squashtest.tm.service.internal.artificialintelligence.AiAssistant;
import org.squashtest.tm.service.internal.artificialintelligence.AiChatClient;
import org.squashtest.tm.service.internal.artificialintelligence.AiServerSecurityService;
import org.squashtest.tm.service.internal.artificialintelligence.server.ChatModelProviderHelper;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerDto;

@Service
@Transactional
public class AiChatClientProviderImpl
implements AiChatClientProvider {
    private final AiServerSecurityService aiServerSecurityService;

    public AiChatClientProviderImpl(AiServerSecurityService aiServerSecurityService) {
        this.aiServerSecurityService = aiServerSecurityService;
    }

    @Override
    public AiChatClient createAiChatClient(AiServerDto aiServerDto, String systemPrompt, TokenAuthCredentials credentials) {
        ChatModel model = ChatModelProviderHelper.buildChatModelForAiServer(aiServerDto, credentials);
        AiAssistant aiAssistant = (AiAssistant)AiServices.builder(AiAssistant.class).systemMessageProvider(chatMemoryId -> systemPrompt).chatModel(model).build();
        return new AiChatClient(aiAssistant, this.aiServerSecurityService, aiServerDto, model);
    }
}

