/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.bdd.BddImplementationTechnology;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NewFolderDto;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNodeVisitor;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.CheckBlockingMilestones;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.Position;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.PreventConcurrents;
import org.squashtest.tm.service.annotation.RestoreMode;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.annotation.TransientlyRestore;
import org.squashtest.tm.service.annotation.TransientlyRestores;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.TestCaseWorkspaceStrategyCopierService;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.importer.XlsImportLimitationHandler;
import org.squashtest.tm.service.internal.batchexport.TestCaseExcelExporterService;
import org.squashtest.tm.service.internal.batchimport.testcase.TestCaseExcelBatchImporter;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.library.AbstractLibraryNavigationService;
import org.squashtest.tm.service.internal.library.NodeDeletionHandler;
import org.squashtest.tm.service.internal.library.PasteStrategy;
import org.squashtest.tm.service.internal.library.PathService;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.KeywordTestCaseDao;
import org.squashtest.tm.service.internal.repository.LibraryDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.ScriptedTestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryNodeDao;
import org.squashtest.tm.service.internal.testcase.NatureTypeChainFixer;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.internal.testcase.TestCaseLibraryNavigationServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeDeletionHandler;
import org.squashtest.tm.service.internal.testcase.coercers.TCLNAndParentIdsCoercerForArray;
import org.squashtest.tm.service.internal.testcase.coercers.TCLNAndParentIdsCoercerForList;
import org.squashtest.tm.service.internal.testcase.coercers.TestCaseLibraryIdsCoercerForArray;
import org.squashtest.tm.service.internal.testcase.coercers.TestCaseLibraryIdsCoercerForList;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.statistics.testcase.TestCaseStatisticsBundle;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseStatisticsService;
import org.squashtest.tm.service.testcase.fromreq.ReqToTestCaseConfiguration;
import org.squashtest.tm.service.testcase.scripted.KeywordTestCaseToFileStrategy;

@Service(value="squashtest.tm.service.TestCaseLibraryNavigationService")
@Transactional
public class TestCaseLibraryNavigationServiceImpl
extends AbstractLibraryNavigationService<TestCaseLibrary, TestCaseFolder, TestCaseLibraryNode>
implements TestCaseLibraryNavigationService {
    private static final Logger LOGGER;
    private static final String EXPORT = "EXPORT";
    private static final String TEST_CASE_CLASS_NAME = "org.squashtest.tm.domain.testcase.TestCase";
    private static final String DESTINATION_ID = "destinationId";
    private static final String SOURCE_NODES_IDS = "sourceNodesIds";
    private static final String TARGET_ID = "targetId";
    private static final String TARGET_IDS = "targetIds";
    private static final String SIMPLE = "simple";
    private static final String EXTENSION_DELIMITER = ".";
    @Inject
    private TestCaseLibraryDao testCaseLibraryDao;
    @Inject
    private TestCaseFolderDao testCaseFolderDao;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    @Qualifier(value="squashtest.tm.repository.TestCaseLibraryNodeDao")
    private TestCaseLibraryNodeDao testCaseLibraryNodeDao;
    @Inject
    private ScriptedTestCaseDao scriptedTestCaseDao;
    @Inject
    private KeywordTestCaseDao keywordTestCaseDao;
    @Inject
    private TestCaseNodeDeletionHandler deletionHandler;
    @Inject
    private TestCaseWorkspaceStrategyCopierService testCaseWorkspaceStrategyCopierService;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToTestCaseFolderStrategy")
    private Provider<PasteStrategy<TestCaseFolder, TestCaseLibraryNode>> pasteToTestCaseFolderStrategyProvider;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToTestCaseLibraryStrategy")
    private Provider<PasteStrategy<TestCaseLibrary, TestCaseLibraryNode>> pasteToTestCaseLibraryStrategyProvider;
    @Inject
    private TestCaseStatisticsService statisticsService;
    @Inject
    private TestCaseCallTreeFinder calltreeService;
    @Inject
    private TestCaseExcelExporterService excelService;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private TestCaseExcelBatchImporter batchImporter;
    @Inject
    private PathService pathService;
    @Inject
    private MilestoneMembershipManager milestoneService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private CustomFieldBindingFinderService customFieldBindingFinderService;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;
    @Inject
    private VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    @Inject
    private MessageSource messageSource;
    @Inject
    private XlsImportLimitationHandler xlsImportLimitationHandler;
    @PersistenceContext
    private EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        TestCaseLibraryNavigationServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TestCaseLibraryNavigationServiceImpl.class);
    }

    @Override
    protected NodeDeletionHandler getDeletionHandler() {
        return this.deletionHandler;
    }

    @Override
    protected LibraryDao<TestCaseLibrary, TestCaseLibraryNode> getLibraryDao() {
        return this.testCaseLibraryDao;
    }

    @Override
    protected FolderDao<TestCaseFolder, TestCaseLibraryNode> getFolderDao() {
        return this.testCaseFolderDao;
    }

    protected TestCaseLibraryNodeDao getLibraryNodeDao() {
        return this.testCaseLibraryNodeDao;
    }

    @Override
    protected PasteStrategy<TestCaseFolder, TestCaseLibraryNode> getPasteToFolderStrategy() {
        return (PasteStrategy)this.pasteToTestCaseFolderStrategyProvider.get();
    }

    @Override
    protected PasteStrategy<TestCaseLibrary, TestCaseLibraryNode> getPasteToLibraryStrategy() {
        return (PasteStrategy)this.pasteToTestCaseLibraryStrategyProvider.get();
    }

    @Override
    @Transactional(readOnly=true)
    public String getPathAsString(long entityId) {
        return this.pathService.buildTestCasePath(entityId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getPathsAsString(List<Long> ids) {
        return this.pathService.buildTestCasesPaths(ids);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TestCaseLibraryNode> findNodesByPath(List<String> paths) {
        return this.getLibraryNodeDao().findNodesByPath(paths);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> findNodeIdsByPath(List<String> paths) {
        return this.getLibraryNodeDao().findNodeIdsByPath(paths);
    }

    @Override
    @Transactional(readOnly=true)
    public Long findNodeIdByPath(String path) {
        return this.getLibraryNodeDao().findNodeIdByPath(path);
    }

    @Override
    @Transactional(readOnly=true)
    public TestCaseLibraryNode findNodeByPath(String path) {
        return this.getLibraryNodeDao().findNodeByPath(path);
    }

    @Override
    public TestCase findTestCaseByPath(String path) {
        Long id = this.findNodeIdByPath(path);
        return (TestCase)this.testCaseDao.getReferenceById(id);
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibrary.class)
    @TransientlyRestore(entityType=TestCaseLibrary.class)
    public TestCaseFolder addFolderToLibrary(@Id long destinationId, TestCaseFolder newFolder) {
        TestCaseLibrary container = (TestCaseLibrary)this.testCaseLibraryDao.loadForNodeAddition(destinationId);
        container.addContent((LibraryNode)newFolder);
        new NatureTypeChainFixer().fix(newFolder);
        this.getFolderDao().persist(newFolder);
        new CustomFieldValuesFixer().fix(newFolder);
        this.generateCustomField(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibrary.class)
    @TransientlyRestore(entityType=TestCaseLibrary.class)
    public TestCaseFolder addFolderToLibrary(@Id long destinationId, NewFolderDto folderDto) {
        TestCaseFolder newFolder = (TestCaseFolder)folderDto.toFolder(EntityType.TEST_CASE_FOLDER);
        return this.addFolderToLibrary(destinationId, newFolder, (Map<Long, RawValue>)folderDto.getCustomFields());
    }

    @Override
    @TransientlyRestore(entityType=TestCaseLibrary.class)
    public TestCaseFolder addFolderToLibrary(@Id long destinationId, TestCaseFolder newFolder, Map<Long, RawValue> customFields) {
        return super.addFolderToLibrary(destinationId, newFolder, customFields);
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    @TransientlyRestore(entityType=TestCaseFolder.class)
    public TestCaseFolder addFolderToFolder(@Id long destinationId, TestCaseFolder newFolder) {
        TestCaseFolder container = this.getFolderDao().loadForNodeAddition(destinationId);
        container.addContent((TestCaseLibraryNode)newFolder);
        new NatureTypeChainFixer().fix(newFolder);
        this.getFolderDao().persist(newFolder);
        new CustomFieldValuesFixer().fix(newFolder);
        this.generateCustomField(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    @TransientlyRestore(entityType=TestCaseFolder.class)
    public TestCaseFolder addFolderToFolder(@Id long destinationId, NewFolderDto folderDto) {
        TestCaseFolder newFolder = (TestCaseFolder)folderDto.toFolder(EntityType.TEST_CASE_FOLDER);
        return this.addFolderToFolder(destinationId, newFolder, (Map<Long, RawValue>)folderDto.getCustomFields());
    }

    @Override
    @TransientlyRestore(entityType=TestCaseFolder.class)
    public TestCaseFolder addFolderToFolder(@Id long destinationId, TestCaseFolder newFolder, Map<Long, RawValue> customFields) {
        return super.addFolderToFolder(destinationId, newFolder, customFields);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibrary.class)
    @TransientlyRestore(entityType=TestCaseLibrary.class)
    public void addTestCaseToLibrary(@Id long libraryId, TestCase testCase, @Position Integer position) {
        TestCaseLibrary library = (TestCaseLibrary)this.testCaseLibraryDao.loadForNodeAddition(libraryId);
        if (position != null) {
            library.addContent((LibraryNode)testCase, position.intValue());
        } else {
            library.addContent((LibraryNode)testCase);
        }
        this.replaceInfoListReferences(testCase);
        this.testCaseDao.safePersist(testCase);
        this.createCustomFieldValuesForTestCase(testCase);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibrary.class)
    @TransientlyRestore(entityType=TestCaseLibrary.class)
    public TestCase addTestCaseToLibrary(@Id long libraryId, TestCase testCase, Map<Long, RawValue> customFieldValues, @Position Integer position, List<Long> milestoneIds) {
        return this.addTestCaseToLibraryUnsecured(libraryId, testCase, customFieldValues, position, milestoneIds);
    }

    @Override
    @PreventConcurrent(entityType=TestCaseLibrary.class)
    @TransientlyRestore(entityType=TestCaseLibrary.class)
    public TestCase addTestCaseToLibraryUnsecured(@Id long libraryId, TestCase testCase, Map<Long, RawValue> customFieldValues, @Position Integer position, List<Long> milestoneIds) {
        this.addTestCaseToLibrary(libraryId, testCase, position);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)testCase, customFieldValues);
        this.createAttachmentsFromLibraryNode((LibraryNode)testCase, (BoundEntity)testCase);
        this.milestoneService.bindTestCaseToMilestones(testCase.getId(), milestoneIds);
        return testCase;
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    @TransientlyRestore(entityType=TestCaseFolder.class)
    public void addTestCaseToFolder(@Id long folderId, TestCase testCase, Integer position) {
        TestCaseFolder folder = (TestCaseFolder)this.testCaseFolderDao.loadForNodeAddition(folderId);
        if (position != null) {
            folder.addContent((TestCaseLibraryNode)testCase, position.intValue());
        } else {
            folder.addContent((TestCaseLibraryNode)testCase);
        }
        this.replaceInfoListReferences(testCase);
        this.testCaseDao.safePersist(testCase);
        this.createCustomFieldValuesForTestCase(testCase);
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    @TransientlyRestore(entityType=TestCaseFolder.class)
    public TestCase addTestCaseToFolder(@Id long folderId, TestCase testCase, Map<Long, RawValue> customFieldValues, @Position Integer position, List<Long> milestoneIds) {
        return this.addTestCaseToFolderUnsecured(folderId, testCase, customFieldValues, position, milestoneIds);
    }

    @Override
    @TransientlyRestore(entityType=TestCaseFolder.class)
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    public TestCase addTestCaseToFolderUnsecured(@Id long folderId, TestCase testCase, Map<Long, RawValue> customFieldValues, @Position Integer position, List<Long> milestoneIds) {
        this.addTestCaseToFolder(folderId, testCase, position);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)testCase, customFieldValues);
        this.createAttachmentsFromLibraryNode((LibraryNode)testCase, (BoundEntity)testCase);
        this.milestoneService.bindTestCaseToMilestones(testCase.getId(), milestoneIds);
        return testCase;
    }

    @Override
    public Long mkdirs(String folderpath) {
        TestCaseFolder foldertree;
        String path = folderpath.replaceFirst("^/", "").replaceFirst("/$", "");
        StringBuilder buffer = new StringBuilder();
        String[] split = path.split("(?<!\\\\)/");
        ArrayList<String> paths = new ArrayList<String>(split.length - 1);
        buffer.append("/").append(split[0]);
        int i = 1;
        while (i < split.length) {
            buffer.append("/");
            buffer.append(split[i]);
            paths.add(buffer.toString());
            ++i;
        }
        List<Long> foundIds = this.findNodeIdsByPath(paths);
        int nullIdx = foundIds.indexOf(null);
        switch (nullIdx) {
            case -1: {
                return foundIds.get(foundIds.size() - 1);
            }
            case 0: {
                Long libraryId = this.projectDao.findByName(split[0].replace("\\/", "/")).getTestCaseLibrary().getId();
                foldertree = this.mkTransFolders(1, split);
                this.addFolderToLibrary((long)libraryId, foldertree);
                break;
            }
            default: {
                Long parentFolder = foundIds.get(nullIdx - 1);
                foldertree = this.mkTransFolders(nullIdx + 1, split);
                this.addFolderToFolder((long)parentFolder, foldertree);
            }
        }
        TestCaseFolder lastFolder = foldertree;
        do {
            if (!lastFolder.hasContent()) continue;
            lastFolder = (TestCaseFolder)lastFolder.getContent().get(0);
        } while (lastFolder.hasContent());
        return lastFolder.getId();
    }

    private TestCaseFolder mkTransFolders(int startIndex, String[] names) {
        TestCaseFolder baseFolder = null;
        TestCaseFolder currentParent = null;
        int i = startIndex;
        while (i < names.length) {
            TestCaseFolder currentChild = new TestCaseFolder();
            currentChild.setName(names[i].replace("\\/", "/"));
            currentChild.setDescription("");
            if (baseFolder == null) {
                baseFolder = currentChild;
            } else {
                currentParent.addContent((TestCaseLibraryNode)currentChild);
            }
            currentParent = currentChild;
            ++i;
        }
        return baseFolder;
    }

    @Override
    public ImportLog simulateImportExcelTestCase(File excelFile) {
        this.xlsImportLimitationHandler.checkMaxNumberOfTestCasesInsideXlsFile(excelFile);
        this.xlsImportLimitationHandler.checkMaxNumberOfTestStepsInsideXlsFile(excelFile);
        return this.batchImporter.simulateImport(excelFile);
    }

    @Override
    public ImportLog performImportExcelTestCase(File excelFile) {
        try {
            this.xlsImportLimitationHandler.incrementImportProcessCounter();
            this.xlsImportLimitationHandler.checkMaxNumberOfTestCasesInsideXlsFile(excelFile);
            this.xlsImportLimitationHandler.checkMaxNumberOfTestStepsInsideXlsFile(excelFile);
            this.xlsImportLimitationHandler.checkIfImportSlotIsAvailable();
            ImportLog importLog = this.batchImporter.performImport(excelFile);
            return importLog;
        }
        finally {
            this.xlsImportLimitationHandler.decrementImportProcessCounter();
        }
    }

    @Override
    @Transactional(readOnly=true)
    public File exportTestCaseAsExcel(List<Long> libraryIds, List<Long> nodeIds, boolean includeCalledTests, boolean keepRteFormat, MessageSource messageSource) {
        Collection<Long> allIds = this.findTestCaseIdsFromSelection(libraryIds, nodeIds, includeCalledTests);
        allIds = this.securityFilterIds(allIds, TEST_CASE_CLASS_NAME, EXPORT);
        return this.excelService.exportAsExcel(new ArrayList<Long>(allIds), keepRteFormat, messageSource);
    }

    @Override
    @Transactional(readOnly=true)
    public File exportGherkinTestCaseAsFeatureFiles(List<Long> libraryIds, List<Long> nodeIds, MessageSource messageSource) {
        Collection<Long> ids = this.findTestCaseIdsFromSelection(libraryIds, nodeIds);
        return this.doGherkinExport(ids);
    }

    @Override
    @Transactional(readOnly=true)
    public File exportKeywordTestCaseAsScriptFiles(List<Long> libraryIds, List<Long> nodeIds, MessageSource messageSource) {
        Collection<Long> ids = this.findTestCaseIdsFromSelection(libraryIds, nodeIds);
        return this.doKeywordExport(ids, messageSource);
    }

    private File doGherkinExport(Collection<Long> ids) {
        List scriptedTestCases = this.scriptedTestCaseDao.findAllById(ids);
        FileOutputStream fileOutputStream = null;
        try {
            File zipFile = File.createTempFile("export-feature-", ".zip");
            fileOutputStream = new FileOutputStream(zipFile);
            zipFile.deleteOnExit();
            ArchiveOutputStream archive = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)fileOutputStream);
            for (ScriptedTestCase scriptedTestCase : scriptedTestCases) {
                String name = "tc_" + String.valueOf(scriptedTestCase.getId());
                ZipArchiveEntry entry = new ZipArchiveEntry(name + ".feature");
                archive.putArchiveEntry((ArchiveEntry)entry);
                archive.write(scriptedTestCase.getScript().getBytes(StandardCharsets.UTF_8));
                archive.closeArchiveEntry();
            }
            archive.close();
            File file = zipFile;
            return file;
        }
        catch (IOException | ArchiveException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close FileOutputStream: ", (Throwable)e);
                }
            }
        }
    }

    private File doKeywordExport(Collection<Long> ids, MessageSource messageSource) {
        List keywordTestCases = this.keywordTestCaseDao.findAllById(ids);
        FileOutputStream fileOutputStream = null;
        try {
            File zipFile = File.createTempFile("export-keyword-", ".zip");
            fileOutputStream = new FileOutputStream(zipFile);
            zipFile.deleteOnExit();
            ArchiveOutputStream archive = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)fileOutputStream);
            for (KeywordTestCase keywordTestCase : keywordTestCases) {
                String name = "tc_" + String.valueOf(keywordTestCase.getId());
                BddImplementationTechnology technology = keywordTestCase.getProject().getBddImplementationTechnology();
                KeywordTestCaseToFileStrategy strategy = KeywordTestCaseToFileStrategy.strategyFor(technology);
                String extension = strategy.getExtension();
                ZipArchiveEntry entry = new ZipArchiveEntry(String.join((CharSequence)EXTENSION_DELIMITER, name, extension));
                archive.putArchiveEntry((ArchiveEntry)entry);
                archive.write(strategy.getWritableFileContent(keywordTestCase, messageSource, false).getBytes(StandardCharsets.UTF_8));
                archive.closeArchiveEntry();
            }
            archive.close();
            File file = zipFile;
            return file;
        }
        catch (IOException | ArchiveException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close FileOutputStream: ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public File searchExportTestCaseAsExcel(List<Long> nodeIds, boolean includeCalledTests, boolean keepRteFormat, MessageSource messageSource, String type, Boolean simplifiedColumnDisplayForTest) {
        Collection<Long> allIds = this.findTestCaseIdsFromSelection(CollectionUtils.EMPTY_COLLECTION, nodeIds, includeCalledTests);
        allIds = this.securityFilterIds(allIds, TEST_CASE_CLASS_NAME, EXPORT);
        File file = type.equals(SIMPLE) ? this.excelService.searchSimpleExportAsExcel(new ArrayList<Long>(allIds), keepRteFormat, messageSource, simplifiedColumnDisplayForTest) : this.excelService.searchExportAsExcel(new ArrayList<Long>(allIds), keepRteFormat, messageSource);
        return file;
    }

    @Override
    public TestCaseStatisticsBundle getStatisticsForSelection(Collection<Long> libraryIds, Collection<Long> nodeIds) {
        Collection<Long> tcIds = this.findTestCaseIdsFromSelection(libraryIds, nodeIds);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            tcIds = this.filterTcIdsListsByMilestone(tcIds, activeMilestone.get());
        }
        return this.statisticsService.gatherTestCaseStatisticsBundle(libraryIds, nodeIds);
    }

    @Override
    public Collection<Long> findTestCaseIdsFromSelection(Collection<Long> libraryIds, Collection<Long> nodeIds) {
        Set<Long> readLibIds = this.securityFilterIds(libraryIds, TestCaseLibrary.class.getName(), "READ");
        Set<Long> readNodeIds = this.securityFilterIds(nodeIds, TestCaseLibraryNode.class.getName(), "READ");
        HashSet<Long> tcIds = new HashSet<Long>();
        if (!readLibIds.isEmpty()) {
            tcIds.addAll(this.testCaseDao.findAllTestCaseIdsByLibraries(readLibIds));
        }
        if (!readNodeIds.isEmpty()) {
            tcIds.addAll(this.testCaseDao.findAllTestCaseIdsByNodeIds(readNodeIds));
        }
        return tcIds;
    }

    @Override
    public Collection<Long> findTestCaseIdsFromSelection(Collection<Long> libraryIds, Collection<Long> nodeIds, boolean includeCalledTests) {
        Collection<Long> tcIds = this.findTestCaseIdsFromSelection(libraryIds, nodeIds);
        if (includeCalledTests) {
            Set<Long> called = this.calltreeService.getTestCaseCallTree(tcIds);
            called = this.securityFilterIds(called, TEST_CASE_CLASS_NAME, "READ");
            tcIds.addAll(called);
        }
        return tcIds;
    }

    @Override
    public int countSiblingsOfNode(long nodeId) {
        return this.testCaseLibraryNodeDao.countSiblingsOfNode(nodeId);
    }

    private void createCustomFieldValuesForTestCase(TestCase testCase) {
        this.createCustomFieldValues((BoundEntity)testCase);
        if (!testCase.getSteps().isEmpty()) {
            this.createCustomFieldValues(testCase.getActionSteps());
        }
    }

    private void replaceInfoListReferences(TestCase testCase) {
        NatureTypeChainFixer.fix(testCase);
    }

    @Override
    public List<Long> findAllTestCasesLibraryNodeForMilestone(Milestone activeMilestone) {
        if (Objects.isNull(activeMilestone)) {
            return new ArrayList<Long>();
        }
        List<Long> list = Collections.singletonList(activeMilestone.getId());
        TestCaseDao testCaseDao = this.testCaseDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)testCaseDao, list);
        Object[] objectArray = new Object[]{this, testCaseDao, list, joinPoint};
        TestCaseLibraryNavigationServiceImpl$AjcClosure1 testCaseLibraryNavigationServiceImpl$AjcClosure1 = new TestCaseLibraryNavigationServiceImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testCaseLibraryNavigationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    private Collection<Long> filterTcIdsListsByMilestone(Collection<Long> tcIds, Milestone activeMilestone) {
        List<Long> tcInMilestone = this.findAllTestCasesLibraryNodeForMilestone(activeMilestone);
        return CollectionUtils.retainAll(tcIds, tcInMilestone);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="sourceNodesIds", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=TestCaseLibrary.class, paramName="sourceNodesIds", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    public void copyNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="sourceNodesIds") Long[] sourceNodesIds, ClipboardPayload clipboardPayload) {
        Map<NodeType, List<Long>> nodePastes = this.testCaseWorkspaceStrategyCopierService.verifyPermission(clipboardPayload);
        this.testCaseWorkspaceStrategyCopierService.copyNode(destinationId, TestCaseFolder.class, clipboardPayload, nodePastes);
    }

    @Override
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseFolder', 'CREATE') or hasRole('ROLE_ADMIN')")
    public void copyRequirementNodesToTestCaseFolder(@Id long destinationId, Long[] sourceNodesIds, ClipboardPayload clipboardPayload, ReqToTestCaseConfiguration configuration) {
        if (sourceNodesIds.length == 0) {
            return;
        }
        Map<NodeType, List<Long>> nodePastes = this.testCaseWorkspaceStrategyCopierService.verifyPermission(clipboardPayload);
        this.testCaseWorkspaceStrategyCopierService.copyRequirementNodesToTestCaseContainer(destinationId, TestCaseFolder.class, clipboardPayload, nodePastes, configuration);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=TestCaseLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetId", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=TestCaseLibrary.class, paramName="targetId", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    public void copyNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        Map<NodeType, List<Long>> nodePastes = this.testCaseWorkspaceStrategyCopierService.verifyPermission(clipboardPayload);
        this.testCaseWorkspaceStrategyCopierService.copyNode(destinationId, TestCaseLibrary.class, clipboardPayload, nodePastes);
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary', 'CREATE') or hasRole('ROLE_ADMIN')")
    public void copyRequirementNodesToTestCaseLibrary(@Id long destinationId, Long[] targetId, ClipboardPayload clipboardPayload, ReqToTestCaseConfiguration configuration) {
        if (targetId.length == 0) {
            return;
        }
        Map<NodeType, List<Long>> nodePastes = this.testCaseWorkspaceStrategyCopierService.verifyPermission(clipboardPayload);
        this.testCaseWorkspaceStrategyCopierService.copyRequirementNodesToTestCaseContainer(destinationId, TestCaseLibrary.class, clipboardPayload, nodePastes, configuration);
    }

    @Override
    public void copyRequirementNodesToTestCases(long destinationId, Long[] targetId, ClipboardPayload clipboardPayload, ReqToTestCaseConfiguration configuration) {
        Pair parent = this.testCaseDao.findParentTypeByTestCaseId(destinationId);
        switch ((EntityType)parent.getKey()) {
            case TEST_CASE_LIBRARY: {
                this.copyRequirementNodesToTestCaseLibrary((Long)parent.getValue(), targetId, clipboardPayload, configuration);
                break;
            }
            case TEST_CASE_FOLDER: {
                this.copyRequirementNodesToTestCaseFolder((Long)parent.getValue(), targetId, clipboardPayload, configuration);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parent type: %s for destinationId: %s".formatted(parent.getKey(), destinationId));
            }
        }
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetId", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=TestCaseLibrary.class, paramName="targetId", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    @TransientlyRestores(mode=RestoreMode.ALL, value={@TransientlyRestore(entityType=TestCaseFolder.class, paramName="destinationId"), @TransientlyRestore(entityType=TestCase.class, paramName="targetId")})
    public void moveNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        super.moveNodesToFolder(destinationId, targetId, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=TestCaseLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetId", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=TestCaseLibrary.class, paramName="targetId", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    @TransientlyRestores(mode=RestoreMode.ALL, value={@TransientlyRestore(entityType=TestCaseLibrary.class, paramName="destinationId"), @TransientlyRestore(entityType=TestCase.class, paramName="targetId")})
    public void moveNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        super.moveNodesToLibrary(destinationId, targetId, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetId", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=TestCaseLibrary.class, paramName="targetId", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    @TransientlyRestores(mode=RestoreMode.ALL, value={@TransientlyRestore(entityType=TestCaseFolder.class, paramName="destinationId"), @TransientlyRestore(entityType=TestCase.class, paramName="targetId")})
    public void moveNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, int position, ClipboardPayload clipboardPayload) {
        super.moveNodesToFolder(destinationId, targetId, position, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=TestCaseLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetId", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=TestCaseLibrary.class, paramName="targetId", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    @TransientlyRestores(mode=RestoreMode.ALL, value={@TransientlyRestore(entityType=TestCaseLibrary.class, paramName="destinationId"), @TransientlyRestore(entityType=TestCase.class, paramName="targetId")})
    public void moveNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, int position, ClipboardPayload clipboardPayload) {
        super.moveNodesToLibrary(destinationId, targetId, position, clipboardPayload);
    }

    @Override
    @PreventConcurrents(batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetIds", coercer=TCLNAndParentIdsCoercerForList.class), @BatchPreventConcurrent(entityType=TestCaseLibrary.class, paramName="targetIds", coercer=TestCaseLibraryIdsCoercerForList.class)})
    @CheckBlockingMilestones(entityType=TestCase.class)
    public OperationReport deleteNodes(@Ids(value="targetIds") List<Long> targetIds) {
        List nodes = this.testCaseLibraryNodeDao.findAllByIds(targetIds);
        this.permissionService.checkPermission(nodes, Permissions.DELETE.name());
        return this.deletionHandler.deleteNodes(targetIds);
    }

    private void generateCustomField(TestCaseFolder newFolder) {
        List<CustomFieldBinding> projectsBindings = this.customFieldBindingFinderService.findCustomFieldsForProjectAndEntity(newFolder.getProject().getId(), BindableEntity.TESTCASE_FOLDER);
        for (CustomFieldBinding binding : projectsBindings) {
            this.customFieldValueService.cascadeCustomFieldValuesCreationNotCreatedFolderYet(binding, (BoundEntity)newFolder);
        }
    }

    @Override
    public TreeMap<String, Long> buildTestCasePathsTree(String projectName) {
        return this.getLibraryNodeDao().buildNodePathsTree(projectName);
    }

    @Override
    public List<String> findContentNamesByLibraryId(Long libraryId) {
        return this.testCaseLibraryDao.findContentNamesByLibraryId(libraryId);
    }

    @Override
    public Map<Long, List<String>> findContentNamesByFolderIds(Collection<Long> folderIds) {
        return this.testCaseFolderDao.findContentNamesByFolderIds(folderIds);
    }

    @Override
    @PreventConcurrent(entityType=TestCaseLibrary.class)
    @TransientlyRestore(entityType=TestCaseLibrary.class)
    public void addTestCasesToLibrary(@Id Long libraryId, List<TestCase> testCases, List<Long> milestoneIds) {
        TestCaseLibrary library = (TestCaseLibrary)this.testCaseLibraryDao.loadForNodeAddition(libraryId);
        for (TestCase testCase : testCases) {
            library.addContent((LibraryNode)testCase);
            this.replaceInfoListReferences(testCase);
            this.testCaseDao.safePersist(testCase);
        }
        this.initCustomFieldsAndMilestones(testCases, milestoneIds, library.getProject());
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    @PreventConcurrent(entityType=TestCaseFolder.class)
    @TransientlyRestore(entityType=TestCaseFolder.class)
    public void addTestCasesToFolder(@Id Long folderId, List<TestCase> testCases, List<Long> milestoneIds) {
        TestCaseFolder folder = (TestCaseFolder)this.testCaseFolderDao.loadForNodeAddition(folderId);
        for (TestCase testCase : testCases) {
            folder.addContent((TestCaseLibraryNode)testCase);
            this.replaceInfoListReferences(testCase);
            this.testCaseDao.safePersist(testCase);
        }
        this.initCustomFieldsAndMilestones(testCases, milestoneIds, (GenericProject)folder.getProject());
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void initCustomFieldsAndMilestones(List<TestCase> testCases, List<Long> milestoneIds, GenericProject project) {
        Map<TestCase, List> testCaseMilestones = testCases.stream().collect(Collectors.toMap(testCase -> testCase, testCase -> milestoneIds));
        this.milestoneService.bindHoldersToMilestones(testCaseMilestones);
        this.customFieldValueService.createAllCustomFieldValues(testCases, project);
    }

    static final /* synthetic */ List findAllTestCasesLibraryNodeForMilestone_aroundBody0(TestCaseLibraryNavigationServiceImpl testCaseLibraryNavigationServiceImpl, TestCaseDao testCaseDao, Collection collection, JoinPoint joinPoint) {
        return testCaseDao.findAllTestCasesLibraryNodeForMilestone(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestCaseLibraryNavigationServiceImpl.java", TestCaseLibraryNavigationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllTestCasesLibraryNodeForMilestone", "org.squashtest.tm.service.internal.repository.TestCaseDao", "java.util.Collection", "arg0", "", "java.util.List"), 835);
    }

    private class CustomFieldValuesFixer
    implements TestCaseLibraryNodeVisitor {
        private CustomFieldValuesFixer() {
        }

        private void fix(TestCaseFolder folder) {
            for (TestCaseLibraryNode node : folder.getContent()) {
                node.accept((TestCaseLibraryNodeVisitor)this);
            }
        }

        public void visit(TestCase visited) {
            TestCaseLibraryNavigationServiceImpl.this.createCustomFieldValuesForTestCase(visited);
        }

        public void visit(TestCaseFolder visited) {
            this.fix(visited);
        }
    }
}

