/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.customfield.RawValue;

public class RawValueModel {
    @JsonProperty(required=false)
    private String value;
    @JsonProperty(required=false)
    private List<String> values;

    public RawValueModel() {
    }

    @JsonCreator
    public RawValueModel(Object any) {
        if (any instanceof String) {
            this.value = (String)any;
        } else if (any instanceof Boolean) {
            this.value = ((Boolean)any).toString().toLowerCase();
        } else if (any instanceof List) {
            this.values = (List)any;
        } else {
            throw new IllegalArgumentException("cannot make a RawValue from " + String.valueOf(any.getClass()));
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    @JsonIgnore
    public RawValue toRawValue() {
        if (this.value != null) {
            return new RawValue(this.value);
        }
        return new RawValue(this.values);
    }

    @JsonIgnore
    public boolean isEmpty() {
        if (this.value == null && (this.values == null || this.values.isEmpty())) {
            return true;
        }
        if (this.value != null && StringUtils.isBlank((CharSequence)this.value)) {
            return true;
        }
        return this.values != null && this.values.isEmpty();
    }

    public static final class RawValueModelMap
    extends HashMap<Long, RawValueModel> {
        private static final long serialVersionUID = 1L;
    }
}

