/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.tf;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.display.tf.AutomationWorkspaceDataProviderService;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.tf.AutomationTesterWorkspaceDataDto;
import org.squashtest.tm.service.internal.display.dto.tf.AutomationWorkspaceDataDto;
import org.squashtest.tm.service.internal.display.tf.AutomationWorkspaceDataProviderServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.display.AutomationRequestDisplayDao;
import org.squashtest.tm.service.internal.repository.display.AutomationTesterRequestDisplayDao;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional(readOnly=true)
public class AutomationWorkspaceDataProviderServiceImpl
implements AutomationWorkspaceDataProviderService {
    private final ProjectFinder projectFinder;
    private final UserAccountService userAccountService;
    private final UserDao userDao;
    private final AutomationRequestDisplayDao automationRequestDisplayDao;
    private final AutomationTesterRequestDisplayDao automationTesterRequestDisplayDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AutomationWorkspaceDataProviderServiceImpl(ProjectFinder projectFinder, UserAccountService userAccountService, UserDao userDao, AutomationRequestDisplayDao automationRequestDisplayDao, AutomationTesterRequestDisplayDao automationTesterRequestDisplayDao) {
        this.projectFinder = projectFinder;
        this.userAccountService = userAccountService;
        this.userDao = userDao;
        this.automationRequestDisplayDao = automationRequestDisplayDao;
        this.automationTesterRequestDisplayDao = automationTesterRequestDisplayDao;
    }

    @Override
    public AutomationWorkspaceDataDto findData() {
        AutomationWorkspaceDataDto dto = new AutomationWorkspaceDataDto();
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIdsForAutomationWriter();
        dto.setUsersWhoModifiedTestCasesAssignView(this.findModifiedUserViewsAssignView(readableProjectIds, currentUser.getUserId()));
        dto.setUsersWhoModifiedTestCasesTreatmentView(this.findModifiedUserViewsTreatmentView(readableProjectIds));
        dto.setUsersWhoModifiedTestCasesGlobalView(this.findModifiedUserViewsGlobalView(readableProjectIds));
        dto.setUsersAssignedTo(this.findAssignedUserViewsGlobalView(readableProjectIds));
        dto.setNbAssignedAutomReq(this.automationRequestDisplayDao.countByAssignedTo(readableProjectIds, currentUser.getUserId()));
        dto.setNbAutomReqToTreat(this.automationRequestDisplayDao.countTransmitted(readableProjectIds));
        dto.setNbTotal(this.automationRequestDisplayDao.countAll(readableProjectIds));
        return dto;
    }

    @Override
    public AutomationTesterWorkspaceDataDto findFunctionalTesterData() {
        AutomationTesterWorkspaceDataDto dto = new AutomationTesterWorkspaceDataDto();
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIds();
        dto.setNbGlobalAutomReq(this.automationTesterRequestDisplayDao.countGlobalAutomationRequests(readableProjectIds));
        dto.setNbReadyForTransmissionAutomReq(this.automationTesterRequestDisplayDao.countReadyForTransmissionAutomRequests(readableProjectIds));
        dto.setNbToBeValidatedAutomReq(this.automationTesterRequestDisplayDao.countToBeValidatedAutomRequests(readableProjectIds));
        dto.setUsersWhoModifiedTestCasesGlobalView(this.findModifiedUserViewsFunctionalTesterGlobalView(readableProjectIds));
        dto.setUsersWhoModifiedTestCasesReadyView(this.findModifiedUserViewsFunctionalTesterReadyView(readableProjectIds));
        dto.setUsersWhoModifiedTestCasesValidateView(this.findModifiedUserViewsFunctionalTesterValidateView(readableProjectIds));
        return dto;
    }

    private List<UserView> findModifiedUserViewsFunctionalTesterGlobalView(List<Long> readableProjectIds) {
        List<String> status = Arrays.stream(AutomationRequestStatus.values()).map(Enum::name).toList();
        List<String> usersWhoModifiedTestCases = this.automationTesterRequestDisplayDao.getLastModifyingUserLoginsForTesterView(readableProjectIds, status);
        return this.findUserViewsByLogin(usersWhoModifiedTestCases);
    }

    private List<UserView> findModifiedUserViewsFunctionalTesterReadyView(List<Long> readableProjectIds) {
        List<String> status = Arrays.asList(AutomationRequestStatus.READY_TO_TRANSMIT.name());
        List<String> usersWhoModifiedTestCases = this.automationTesterRequestDisplayDao.getLastModifyingUserLoginsForTesterView(readableProjectIds, status);
        return this.findUserViewsByLogin(usersWhoModifiedTestCases);
    }

    private List<UserView> findModifiedUserViewsFunctionalTesterValidateView(List<Long> readableProjectIds) {
        List<String> status = Arrays.asList(AutomationRequestStatus.WORK_IN_PROGRESS.name(), AutomationRequestStatus.REJECTED.name(), AutomationRequestStatus.SUSPENDED.name());
        List<String> usersWhoModifiedTestCases = this.automationTesterRequestDisplayDao.getLastModifyingUserLoginsForTesterView(readableProjectIds, status);
        return this.findUserViewsByLogin(usersWhoModifiedTestCases);
    }

    private List<UserView> findAssignedUserViewsGlobalView(List<Long> readableProjectIds) {
        List<String> usersWhoModifiedTestCases = this.automationRequestDisplayDao.getAssignedUserForAutomationRequests(readableProjectIds);
        return this.findUserViewsByLogin(usersWhoModifiedTestCases);
    }

    private List<UserView> findModifiedUserViewsAssignView(List<Long> readableProjectIds, Long userId) {
        List<String> status = Arrays.stream(AutomationRequestStatus.values()).map(Enum::name).toList();
        List<String> usersWhoModifiedTestCases = this.automationRequestDisplayDao.getTcLastModifiedByForCurrentUser(readableProjectIds, status, userId);
        return this.findUserViewsByLogin(usersWhoModifiedTestCases);
    }

    private List<UserView> findModifiedUserViewsTreatmentView(List<Long> readableProjectIds) {
        List<String> status = Arrays.asList(AutomationRequestStatus.TRANSMITTED.name(), AutomationRequestStatus.AUTOMATION_IN_PROGRESS.name());
        List<String> usersWhoModifiedTestCases = this.automationRequestDisplayDao.getTcLastModifiedByToAutomationRequestNotAssigned(readableProjectIds, status);
        return this.findUserViewsByLogin(usersWhoModifiedTestCases);
    }

    private List<UserView> findModifiedUserViewsGlobalView(List<Long> readableProjectIds) {
        List<String> status = Arrays.stream(AutomationRequestStatus.values()).map(Enum::name).toList();
        List<String> usersWhoModifiedTestCases = this.automationRequestDisplayDao.getTcLastModifiedByForAutomationRequests(readableProjectIds, status);
        return this.findUserViewsByLogin(usersWhoModifiedTestCases);
    }

    private List<UserView> findUserViewsByLogin(List<String> usersWhoCreatedTestCases) {
        List<String> list = usersWhoCreatedTestCases;
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        AutomationWorkspaceDataProviderServiceImpl$AjcClosure1 automationWorkspaceDataProviderServiceImpl$AjcClosure1 = new AutomationWorkspaceDataProviderServiceImpl$AjcClosure1(objectArray);
        List users = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(automationWorkspaceDataProviderServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        Map userViews = users.stream().map(user -> {
            UserView userView = new UserView();
            userView.setId(user.getId());
            userView.setFirstName(user.getFirstName());
            userView.setLastName(user.getLastName());
            userView.setLogin(user.getLogin());
            return userView;
        }).collect(Collectors.toMap(UserView::getLogin, Function.identity()));
        return usersWhoCreatedTestCases.stream().map(login -> userViews.getOrDefault(login, new UserView((String)login))).toList();
    }

    static {
        AutomationWorkspaceDataProviderServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findUsersByLoginIn_aroundBody0(AutomationWorkspaceDataProviderServiceImpl automationWorkspaceDataProviderServiceImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginIn(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AutomationWorkspaceDataProviderServiceImpl.java", AutomationWorkspaceDataProviderServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findUsersByLoginIn", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "loginList", "", "java.util.List"), 177);
    }
}

