/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.internal.batchimport.CustomFieldTransator;
import org.squashtest.tm.service.internal.batchimport.MilestoneImportHelper;
import org.squashtest.tm.service.internal.batchimport.Milestoned;
import org.squashtest.tm.service.internal.batchimport.Model;
import org.squashtest.tm.service.internal.batchimport.ValidationFacility;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;

public abstract class AbstractEntityFacilitySupport {
    protected static final String UNEXPECTED_ERROR_DURING_CREATION = "unexpected error occurred when creating {} in project : {}";
    protected static final String UNEXPECTED_ERROR_WHILE_IMPORTING = "unexpected error while importing ";
    protected static final String EXCEL_ERR_PREFIX = "Excel import : ";
    @Inject
    protected MilestoneImportHelper milestoneHelper;
    @Inject
    private PrivateCustomFieldValueService cufvalueService;
    private CustomFieldTransator customFieldTransator;
    protected ValidationFacility validator;
    protected Model model;

    protected final List<Long> boundMilestonesIds(Milestoned instr) {
        Collection<String> milestones = instr.getMilestones();
        if (milestones.isEmpty()) {
            return Collections.emptyList();
        }
        List<Milestone> ms = this.milestoneHelper.findBindable(milestones);
        ArrayList<Long> msids = new ArrayList<Long>(ms.size());
        for (Milestone m : ms) {
            msids.add(m.getId());
        }
        return msids;
    }

    protected final Map<Long, RawValue> toAcceptableCufs(Map<String, String> origCufs) {
        if (this.customFieldTransator == null) {
            throw new IllegalStateException("'customFieldTransator' is null, it should have been initialized by FacilityImpl in a @PostConstruct method");
        }
        return this.customFieldTransator.toAcceptableCufs(origCufs);
    }

    protected final InputType getInputTypeFor(String cufCode) {
        return this.customFieldTransator.getInputTypeFor(cufCode);
    }

    protected final void doUpdateCustomFields(Map<String, String> cufValues, BoundEntity bindableEntity) {
        List<CustomFieldValue> cufs = this.cufvalueService.findAllCustomFieldValues(bindableEntity);
        Set<String> codeSet = cufValues.keySet();
        for (CustomFieldValue v : cufs) {
            String code = v.getCustomField().getCode();
            String newValue = cufValues.get(code);
            if (!codeSet.contains(code)) continue;
            v.setValue(newValue);
        }
    }

    public void initializeCustomFieldTransator(CustomFieldTransator customFieldTransator) {
        this.customFieldTransator = customFieldTransator;
    }

    public void initializeValidator(ValidationFacility validator) {
        this.validator = validator;
        this.model = validator.getModel();
    }
}

