/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultimport;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.internal.dto.resultimport.ExecutionResultDto;
import org.squashtest.tm.service.internal.dto.resultimport.ImportTestPlanItemDto;
import org.squashtest.tm.service.internal.dto.resultimport.PartialErrorDto;
import org.squashtest.tm.service.internal.dto.resultimport.TestDto;
import org.squashtest.tm.service.internal.dto.resultimport.TestErrorDto;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.testautomation.AutomatedSuiteImportService;
import org.squashtest.tm.service.testautomation.resultimport.ResultImportService;

@Service
public class ResultImportServiceImpl
implements ResultImportService {
    private final IterationDao iterationDao;
    private final AutomatedSuiteImportService automatedSuiteImportService;
    private final IterationTestPlanDao iterationTestPlanDao;
    private final CustomTestSuiteModificationService customTestSuiteModificationService;

    @Inject
    public ResultImportServiceImpl(IterationDao iterationDao, AutomatedSuiteImportService automatedSuiteImportService, IterationTestPlanDao iterationTestPlanDao, CustomTestSuiteModificationService customTestSuiteModificationService) {
        this.iterationDao = iterationDao;
        this.automatedSuiteImportService = automatedSuiteImportService;
        this.iterationTestPlanDao = iterationTestPlanDao;
        this.customTestSuiteModificationService = customTestSuiteModificationService;
    }

    @Override
    @Transactional
    @UsedInPlugin(names={PluginName.API_REST})
    public PartialErrorDto importResultsForIteration(Long iterationId, ExecutionResultDto executionResultDto) {
        PartialErrorDto partialErrors = new PartialErrorDto();
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        if (iteration == null) {
            throw new EntityNotFoundException("Iteration not found with ID: " + String.valueOf(iterationId));
        }
        partialErrors.setIterationId(iteration.getId());
        ArrayList<ImportTestPlanItemDto> filteredTestPlanItems = new ArrayList<ImportTestPlanItemDto>();
        List<ImportTestPlanItemDto> testPlanItems = this.iterationTestPlanDao.findImportTestPlanItemDtosByIterationId(iterationId);
        for (TestDto testDto : executionResultDto.getTests()) {
            String testReference = testDto.getReference();
            String datasetName = testDto.getDatasetName();
            List<ImportTestPlanItemDto> filteredItpis = testPlanItems.stream().filter(itpi -> this.filterTestPlanItemByReferenceAndDatasetName((ImportTestPlanItemDto)itpi, testReference, datasetName)).toList();
            if (filteredItpis.size() == 1) {
                ImportTestPlanItemDto itpi2 = filteredItpis.getFirst();
                itpi2.setTestDto(testDto);
                filteredTestPlanItems.add(itpi2);
                continue;
            }
            TestErrorDto testError = new TestErrorDto();
            testError.setReference(testReference);
            String testIdentifier = "Test with reference " + testReference + (String)(datasetName != null && !datasetName.isBlank() ? " and dataset " + datasetName : " and an empty dataset");
            String errorMessage = filteredItpis.size() > 1 ? "%s found multiple times in iteration %s" : "%s not found in iteration %s";
            testError.setError(errorMessage.formatted(testIdentifier, iteration.getName()));
            partialErrors.getTests().add(testError);
        }
        if (!filteredTestPlanItems.isEmpty()) {
            this.automatedSuiteImportService.createAutomatedSuiteAndImportExecutions(filteredTestPlanItems, iteration, executionResultDto.getAutomatedTestSuite(), partialErrors);
            List testSuites = this.iterationDao.loadWithTestSuites(iterationId).getTestSuites();
            this.customTestSuiteModificationService.updateExecutionStatus(testSuites);
        }
        return partialErrors;
    }

    private boolean filterTestPlanItemByReferenceAndDatasetName(ImportTestPlanItemDto itpi, String testReference, String datasetName) {
        if (itpi.getAutomatedTestReference() != null && itpi.getAutomatedTestReference().equals(testReference)) {
            if (datasetName == null || datasetName.isBlank()) {
                return itpi.getDatasetName() == null;
            }
            return itpi.getDatasetName() != null && itpi.getDatasetName().equals(datasetName);
        }
        return false;
    }
}

