/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.testcase.ParameterDto;
import org.squashtest.tm.service.internal.repository.display.ParameterDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository
public class ParameterDisplayDaoImpl
implements ParameterDisplayDao {
    @Inject
    private DSLContext dsl;

    @Override
    public List<ParameterDto> findAllByTestCaseId(Long testCaseId) {
        ArrayList<ParameterDto> allParameters = new ArrayList<ParameterDto>();
        HashSet<Long> exploredTc = new HashSet<Long>();
        List<Long> srcTc = new LinkedList<Long>();
        srcTc.add(testCaseId);
        while (!srcTc.isEmpty()) {
            allParameters.addAll(this.findTestCaseParameters(srcTc));
            List<Long> destTc = this.findTestCasesThatDelegatesParameters(srcTc);
            exploredTc.addAll(srcTc);
            srcTc = destTc;
            srcTc.removeAll(exploredTc);
        }
        allParameters.sort(Comparator.comparing(ParameterDto::getId));
        return allParameters;
    }

    private List<Long> findTestCasesThatDelegatesParameters(List<Long> sourceIds) {
        return this.dsl.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(sourceIds).and(Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.isTrue())).fetchInto(Long.class);
    }

    private List<ParameterDto> findTestCaseParameters(List<Long> testCaseIds) {
        return this.dsl.select((SelectField)Tables.PARAMETER.PARAM_ID.as("ID"), (SelectField)Tables.PARAMETER.NAME, (SelectField)Tables.PARAMETER.DESCRIPTION, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("SOURCE_TEST_CASE_ID"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("SOURCE_TEST_CASE_NAME"), (SelectField)Tables.TEST_CASE.REFERENCE.as("SOURCE_TEST_CASE_REFERENCE"), (SelectField)Tables.PROJECT.NAME.as("SOURCE_TEST_CASE_PROJECT_NAME"), (SelectField)Tables.PARAMETER.PARAM_ORDER.as("ORDER")).from((TableLike)Tables.PARAMETER).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.PARAMETER.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.PARAMETER.TEST_CASE_ID.in(testCaseIds)).fetch().into(ParameterDto.class);
    }
}

