/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomatedExecutionExtender;
import org.squashtest.tm.jooq.domain.tables.AutomatedSuite;
import org.squashtest.tm.service.internal.repository.display.AutomatedSuiteDisplayDao;

@Repository
public class AutomatedSuiteDisplayDaoImpl
implements AutomatedSuiteDisplayDao {
    private final DSLContext dslContext;

    public AutomatedSuiteDisplayDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public List<String> findReportUrlsByAutomatedSuiteId(Long automatedSuiteId) {
        return this.dslContext.selectDistinct((SelectField)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.RESULT_URL).from((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).innerJoin((TableLike)AutomatedSuite.AUTOMATED_SUITE).on(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID)).where(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.RESULT_URL.isNotNull()).and(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Object)automatedSuiteId)).fetch((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.RESULT_URL);
    }

    @Override
    public Long findAttachmentListIdByAutomatedSuite(Long automatedSuiteId) {
        return (Long)this.dslContext.select((SelectField)AutomatedSuite.AUTOMATED_SUITE.ATTACHMENT_LIST_ID).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).where(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Object)automatedSuiteId)).fetchOneInto(Long.class);
    }

    public static Table<Record> getAutomatedSuiteTableByIterationId(Long iterationId, List<Field<?>> fields) {
        AutomatedSuite suiteAlreadyGathered = AutomatedSuite.AUTOMATED_SUITE.as("suite_already_gathered");
        return DSL.select(fields).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).join((TableLike)Tables.ITERATION).on(AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.eq((Object)iterationId)).unionAll((Select)DSL.select(fields).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).join((TableLike)Tables.ITERATION_TEST_SUITE).on(AutomatedSuite.AUTOMATED_SUITE.TEST_SUITE_ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).join((TableLike)Tables.ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId).and(AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.isNull().or(AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.ne((Object)iterationId))))).unionAll((Select)DSL.select(fields).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).join((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).join((TableLike)Tables.EXECUTION).on(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.ITERATION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId).andNotExists((Select)DSL.selectOne().from((TableLike)suiteAlreadyGathered).leftJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(suiteAlreadyGathered.TEST_SUITE_ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).where(suiteAlreadyGathered.SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID).and(suiteAlreadyGathered.ITERATION_ID.eq((Object)iterationId).or(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Object)iterationId)))))).groupBy(new GroupField[]{AutomatedSuite.AUTOMATED_SUITE.SUITE_ID, Tables.ITERATION.ITERATION_ID})).asTable();
    }

    public static Table<Record> getAutomatedSuiteTableByTestSuiteId(Long testSuiteId, List<Field<?>> fields) {
        AutomatedSuite suiteAlreadyGathered = AutomatedSuite.AUTOMATED_SUITE.as("suite_already_gathered");
        return DSL.select(fields).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).join((TableLike)Tables.ITERATION_TEST_SUITE).on(AutomatedSuite.AUTOMATED_SUITE.TEST_SUITE_ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).where(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Object)testSuiteId)).unionAll((Select)DSL.select(fields).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).join((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).join((TableLike)Tables.EXECUTION).on(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).join((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)testSuiteId).andNotExists((Select)DSL.selectOne().from((TableLike)suiteAlreadyGathered).join((TableLike)Tables.ITERATION_TEST_SUITE).on(suiteAlreadyGathered.TEST_SUITE_ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).where(suiteAlreadyGathered.SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID).and(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Object)testSuiteId))))).groupBy(new GroupField[]{AutomatedSuite.AUTOMATED_SUITE.SUITE_ID, Tables.ITERATION_TEST_SUITE.ITERATION_ID})).asTable();
    }

    @Override
    public long countAutomatedSuiteByIterationId(Long iterationId) {
        return this.dslContext.fetchCount(AutomatedSuiteDisplayDaoImpl.getAutomatedSuiteTableByIterationId(iterationId, List.of(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID)));
    }

    @Override
    public long countAutomatedSuiteByTestSuiteId(Long testSuiteId) {
        return this.dslContext.fetchCount(AutomatedSuiteDisplayDaoImpl.getAutomatedSuiteTableByTestSuiteId(testSuiteId, List.of(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID)));
    }
}

