/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.service.internal.library.PasteOperation;
import org.squashtest.tm.service.internal.library.TreeNodeUpdater;

@Component
@Scope(value="prototype")
public class NextLayersTreeNodeMover
implements NodeVisitor,
PasteOperation {
    @Inject
    private TreeNodeUpdater treeNodeUpdater;
    private NodeContainer<? extends TreeNode> destination;
    private List<Long> movedTcIds = new ArrayList<Long>();
    private List<Long> movedReqVersionIds = new ArrayList<Long>();

    @Override
    public TreeNode performOperation(TreeNode toMove, NodeContainer<TreeNode> destination, Integer position) {
        this.destination = destination;
        toMove.accept((NodeVisitor)this);
        toMove.accept((NodeVisitor)this.treeNodeUpdater);
        return toMove;
    }

    @Override
    public boolean isOkToGoDeeper() {
        return true;
    }

    public void visit(CampaignFolder campaignFolder) {
        campaignFolder.notifyAssociatedWithProject((Project)this.destination.getProject());
    }

    public void visit(RequirementFolder requirementFolder) {
        requirementFolder.notifyAssociatedWithProject((Project)this.destination.getProject());
    }

    public void visit(TestCaseFolder testCaseFolder) {
        testCaseFolder.notifyAssociatedWithProject((Project)this.destination.getProject());
    }

    public void visit(Campaign campaign) {
        campaign.notifyAssociatedWithProject((Project)this.destination.getProject());
    }

    public void visit(Iteration iteration) {
    }

    public void visit(TestSuite testSuite) {
    }

    public void visit(Sprint sprint) {
        sprint.notifyAssociatedWithProject((Project)this.destination.getProject());
    }

    public void visit(SprintGroup sprintGroup) {
        sprintGroup.notifyAssociatedWithProject((Project)this.destination.getProject());
    }

    public void visit(Requirement requirement) {
        requirement.notifyAssociatedWithProject((Project)this.destination.getProject());
        ArrayList<Long> reqVersionIds = new ArrayList<Long>();
        List requirementVersions = requirement.getRequirementVersions();
        for (RequirementVersion requirementVersion : requirementVersions) {
            reqVersionIds.add(requirementVersion.getId());
        }
        this.movedReqVersionIds.addAll(reqVersionIds);
    }

    public void visit(HighLevelRequirement highLevelRequirement) {
        highLevelRequirement.notifyAssociatedWithProject((Project)this.destination.getProject());
        ArrayList<Long> reqVersionIds = new ArrayList<Long>();
        List requirementVersions = highLevelRequirement.getRequirementVersions();
        for (RequirementVersion requirementVersion : requirementVersions) {
            reqVersionIds.add(requirementVersion.getId());
        }
        this.movedReqVersionIds.addAll(reqVersionIds);
    }

    public void visit(TestCase testCase) {
        testCase.notifyAssociatedWithProject((Project)this.destination.getProject());
        this.movedTcIds.add(testCase.getId());
    }
}

