/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.importer;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseNature;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.testcase.TestStep;

class PseudoTestCase {
    private Date createdOnDate = null;
    private String createdBy = null;
    private String createdOn = null;
    private String automatable = "";
    private String importance = "";
    private String nature = "";
    private String type = "";
    private String status = "";
    private String uuid = "";
    private final List<String[]> descriptionElements = new ArrayList<String[]>();
    private final List<String> prerequisites = new ArrayList<String>();
    private final List<String[]> stepElements = new LinkedList<String[]>();

    PseudoTestCase() {
    }

    public String formatDescription() {
        StringBuilder builder = new StringBuilder();
        List<String[]> elements = this.descriptionElements;
        if (!elements.isEmpty()) {
            builder.append("<p>").append(elements.get(0)[1]).append("</p>");
        }
        if (elements.size() > 1) {
            builder.append("<hr/>");
            builder.append("<ul>");
            int i = 1;
            while (i < elements.size()) {
                String[] elt = elements.get(i);
                builder.append("<li>").append("<strong>").append(elt[0]).append(" :</strong> ").append(elt[1]).append("</li>");
                ++i;
            }
            builder.append("</ul>");
        }
        return builder.toString();
    }

    public TestCaseImportance formatImportance() {
        return TestCaseImportance.valueOf((String)this.importance);
    }

    public InfoListItem formatNature() {
        ListItemReference res;
        if (StringUtils.isBlank((CharSequence)this.nature)) {
            res = null;
        } else {
            try {
                TestCaseNature obsoleteNature = TestCaseNature.valueOf((String)this.nature);
                res = new ListItemReference("NAT_" + obsoleteNature.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                res = new ListItemReference(this.nature);
            }
        }
        return res;
    }

    public InfoListItem formatType() {
        ListItemReference res;
        if (StringUtils.isBlank((CharSequence)this.type)) {
            res = null;
        } else {
            try {
                TestCaseNature obsoleteNature = TestCaseNature.valueOf((String)this.type);
                res = new ListItemReference("TYP_" + obsoleteNature.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                res = new ListItemReference(this.type);
            }
        }
        return res;
    }

    public TestCaseStatus formatStatus() {
        return TestCaseStatus.valueOf((String)this.status);
    }

    public TestCaseAutomatable formatAutomatable() {
        return TestCaseAutomatable.valueOf((String)this.automatable);
    }

    public String formatPreRequisites() {
        StringBuilder builder = new StringBuilder();
        if (!this.prerequisites.isEmpty()) {
            builder.append("<ol>");
            for (String string : this.prerequisites) {
                builder.append("<li>").append(string).append("</li>");
            }
            builder.append("</ol>");
        }
        return builder.toString();
    }

    public List<TestStep> formatSteps() {
        LinkedList<TestStep> steps = new LinkedList<TestStep>();
        for (String[] pseudoStep : this.stepElements) {
            ActionTestStep step = new ActionTestStep();
            step.setAction("<p>" + pseudoStep[0] + "</p>");
            step.setExpectedResult("<p>" + pseudoStep[1] + "</p>");
            steps.add((TestStep)step);
        }
        return steps;
    }

    public Date getCreatedOnDate() {
        return this.createdOnDate;
    }

    public void setCreatedOnDate(Date createdOnDate) {
        this.createdOnDate = createdOnDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getImportance() {
        return this.importance;
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public String getAutomatable() {
        return this.automatable;
    }

    public void setAutomatable(String automatable) {
        this.automatable = automatable;
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<String[]> getDescriptionElements() {
        return this.descriptionElements;
    }

    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    public List<String[]> getStepElements() {
        return this.stepElements;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

