/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.service.internal.dto.ExecutionDto;
import org.squashtest.tm.service.internal.dto.TestCaseDto;

public class ITPIDto {
    private Long id = -1L;
    private String status = "";
    private String userName = "";
    private Date lastExecutedOn;
    private Map<Long, ExecutionDto> executionMap = new HashMap<Long, ExecutionDto>();
    private String dataset = "";
    private Set<String> testSuiteSet = new HashSet<String>();
    private TestCaseDto testCase;

    public ITPIDto(Long id, String status, String userName, Date lastExecutedOn) {
        this.id = id;
        this.status = status;
        if (userName != null) {
            this.userName = userName;
        }
        this.lastExecutedOn = lastExecutedOn;
    }

    public ITPIDto() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Date getLastExecutedOn() {
        return this.lastExecutedOn;
    }

    public void setLastExecutedOn(Date lastExecutedOn) {
        this.lastExecutedOn = lastExecutedOn;
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public Set<String> getTestSuiteSet() {
        return this.testSuiteSet;
    }

    public void setTestSuiteSet(Set<String> testSuiteSet) {
        this.testSuiteSet = testSuiteSet;
    }

    public TestCaseDto getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCaseDto testCase) {
        this.testCase = testCase;
    }

    public boolean isTestCaseDeleted() {
        return this.testCase == null;
    }

    public String getTestSuiteNames() {
        StringBuilder builder = new StringBuilder();
        for (String suite : this.testSuiteSet) {
            builder.append(suite).append(", ");
        }
        return builder.toString().replaceFirst(", $", "");
    }

    public void addExecution(ExecutionDto execution) {
        this.executionMap.put(execution.getId(), execution);
    }

    public ExecutionDto getLatestExecution() {
        if (!this.executionMap.isEmpty()) {
            Long max = Collections.max(this.executionMap.keySet());
            return this.executionMap.get(max);
        }
        return null;
    }

    public Map<Long, ExecutionDto> getExecutionMap() {
        return this.executionMap;
    }

    public void setExecutionMap(Map<Long, ExecutionDto> executionMap) {
        this.executionMap = executionMap;
    }

    public ExecutionDto getExecution(Long executionId) {
        return this.executionMap.get(executionId);
    }
}

