/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultpublisher;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.exception.EntityDoesNotExistException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.users.ApiToken;
import org.squashtest.tm.service.campaign.AutomatedSuiteModificationService;
import org.squashtest.tm.service.internal.repository.ApiTokenDao;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.testautomation.resultpublisher.AutomatedSuiteCompletionActionsService;

@Service
@Transactional
public class AutomatedSuiteCompletionActionsServiceImpl
implements AutomatedSuiteCompletionActionsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedSuiteCompletionActionsServiceImpl.class);
    private static final long TOKEN_DELETION_DELAY = TimeUnit.HOURS.toHours(1L);
    private static final TimeUnit TOKEN_DELETION_TIME_UNIT = TimeUnit.HOURS;
    private final AutomatedSuiteDao autoSuiteDao;
    private final ApiTokenDao apiTokenDao;
    private final AutomatedSuiteModificationService automatedSuiteModificationService;

    public AutomatedSuiteCompletionActionsServiceImpl(AutomatedSuiteDao autoSuiteDao, ApiTokenDao apiTokenDao, AutomatedSuiteModificationService automatedSuiteModificationService) {
        this.autoSuiteDao = autoSuiteDao;
        this.apiTokenDao = apiTokenDao;
        this.automatedSuiteModificationService = automatedSuiteModificationService;
    }

    @Override
    public void performCompletionActions(String automatedSuiteUuid) {
        try {
            LOGGER.info("Performing completion actions for AutomatedSuite UUID: {}", new Object[]{automatedSuiteUuid});
            AutomatedSuite automatedSuite = this.autoSuiteDao.findByUuid(automatedSuiteUuid).orElseThrow(() -> new EntityDoesNotExistException("AUTOMATED_SUITE", automatedSuiteUuid));
            if (automatedSuite.getWorkflows() != null) {
                automatedSuite.getWorkflows().clear();
            }
            LOGGER.debug("Workflows cleared for AutomatedSuite UUID: {}", new Object[]{automatedSuiteUuid});
            this.automatedSuiteModificationService.updateExecutionStatus(automatedSuite);
            LOGGER.debug("Final AutomatedSuite status computed for AutomatedSuite UUID: {}", new Object[]{automatedSuiteUuid});
            this.deleteAutoGeneratedToken(automatedSuite.getId(), automatedSuiteUuid);
            LOGGER.info("AutomatedSuite completion actions completed successfully for UUID: {}", new Object[]{automatedSuiteUuid});
        }
        catch (Exception e) {
            LOGGER.error("Error performing completion actions for AutomatedSuite UUID: {}", new Object[]{automatedSuiteUuid, e});
        }
    }

    private void deleteAutoGeneratedToken(Long automatedSuiteId, String automatedSuiteUuid) {
        if (this.autoSuiteDao.isAutomatedSuiteCreatedByTestAutomationServerUser(automatedSuiteId)) {
            LOGGER.debug("AutomatedSuite {} was created by TA server user, skipping token deletion", new Object[]{automatedSuiteUuid});
            return;
        }
        String tokenPartialName = "-" + automatedSuiteUuid + "-";
        this.scheduleTokenDeletion(tokenPartialName);
    }

    private void scheduleTokenDeletion(String tokenPartialName) {
        if (!this.hasFoundTokenToDelete(tokenPartialName)) {
            return;
        }
        LOGGER.info("Scheduling token deletion for pattern: {}", new Object[]{tokenPartialName});
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.schedule(() -> {
            this.apiTokenDao.deleteAllByNameContains(tokenPartialName);
            LOGGER.info("Tokens deleted for pattern: {}", new Object[]{tokenPartialName});
        }, TOKEN_DELETION_DELAY, TOKEN_DELETION_TIME_UNIT);
        scheduler.shutdown();
    }

    private boolean hasFoundTokenToDelete(String tokenPartialName) {
        List<ApiToken> tokens = this.apiTokenDao.findAllByNameContains(tokenPartialName);
        if (tokens == null || tokens.isEmpty()) {
            LOGGER.trace("No token found matching the pattern '{}', associated with the automated suite.", new Object[]{tokenPartialName});
            return false;
        }
        if (tokens.size() > 1) {
            LOGGER.warn("Multiple tokens matching the pattern '{}' were found. All will be scheduled for deletion.", new Object[]{tokenPartialName});
        }
        return true;
    }
}

