/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.lang.reflect.Constructor;
import java.util.List;
import org.hibernate.InstantiationException;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;

public class EasyConstructorResultTransformer<T>
implements TupleTransformer<T>,
ResultListTransformer<T> {
    Constructor<?> constructor;

    public EasyConstructorResultTransformer(Class<T> clazz) {
        this.constructor = clazz.getDeclaredConstructors()[0];
    }

    public T transformTuple(Object[] tuple, String[] aliases) {
        try {
            return (T)this.constructor.newInstance(tuple);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate class", this.constructor.getDeclaringClass(), e);
        }
    }

    public List<T> transformList(List<T> resultList) {
        return resultList;
    }
}

