/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.importer;

import org.squashtest.tm.service.importer.ImportSummary;

public class ImportSummaryImpl
implements ImportSummary {
    private int total = 0;
    private int renamed = 0;
    private int modified = 0;
    private int failures = 0;
    private int rejected = 0;
    private int milestoneFailures = 0;
    private int milestoneNotActivatedFailures = 0;

    @Override
    public int getMilestoneNotActivatedFailures() {
        return this.milestoneNotActivatedFailures;
    }

    @Override
    public int getMilestoneFailures() {
        return this.milestoneFailures;
    }

    public void setMilestoneFailures(int milestoneFailures) {
        this.milestoneFailures = milestoneFailures;
    }

    public void incrMilestoneNotActivatedFailures() {
        ++this.milestoneNotActivatedFailures;
    }

    public void incrMilestoneFailures() {
        ++this.milestoneFailures;
    }

    public void incrTotal() {
        ++this.total;
    }

    public void incrRenamed() {
        ++this.renamed;
    }

    public void incrFailures() {
        ++this.failures;
    }

    public void incrModified() {
        ++this.modified;
    }

    public void incrRejected() {
        ++this.rejected;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    @Override
    public int getSuccess() {
        return this.total - this.failures - this.rejected;
    }

    @Override
    public int getRenamed() {
        return this.renamed;
    }

    public void setRenammed(int renammed) {
        this.renamed = renammed;
    }

    @Override
    public int getModified() {
        return this.modified;
    }

    public void setModified(int modified) {
        this.modified = modified;
    }

    @Override
    public int getFailures() {
        return this.failures;
    }

    public void setFailures(int failures) {
        this.failures = failures;
    }

    @Override
    public int getRejected() {
        return this.rejected;
    }

    public void setRejected(int rejected) {
        this.rejected = rejected;
    }

    @Override
    public void add(ImportSummary summary) {
        this.total += summary.getTotal();
        this.failures += summary.getFailures();
        this.modified += summary.getModified();
        this.renamed += summary.getRenamed();
        this.rejected += summary.getRejected();
        this.milestoneFailures += summary.getMilestoneFailures();
        this.milestoneNotActivatedFailures += summary.getMilestoneNotActivatedFailures();
    }
}

