/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.mapping;

import java.util.Arrays;
import java.util.Objects;

public enum XrayTestType {
    MANUAL("manual"),
    CUCUMBER("cucumber"),
    GENERIC("generic"),
    UNSUPPORTED("unsupported-type");

    private final String name;

    private XrayTestType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static XrayTestType getTestType(String status) {
        if (Objects.isNull(status)) {
            return UNSUPPORTED;
        }
        return Arrays.stream(XrayTestType.values()).filter(xrayTestType -> xrayTestType.getName().toLowerCase().contains(status.toLowerCase())).findFirst().orElse(UNSUPPORTED);
    }
}

