/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.domain.requirement.QRequirementVersionLink;
import org.squashtest.tm.domain.requirement.QRequirementVersionLinkType;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class RequirementVersionHasLinkTypeFilterHandler
implements FilterHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"REQUIREMENT_VERSION_HAS_LINK_TYPE"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        QRequirementVersion outerVersion = QRequirementVersion.requirementVersion;
        QRequirementVersion reqVersionInit = new QRequirementVersion("reqVersionInit");
        QRequirementVersionLink versionLink = new QRequirementVersionLink("versionLink");
        QRequirementVersionLinkType versionType = new QRequirementVersionLinkType("versionType");
        List<String> values = filter.getValues();
        FilterOperation filterOperation = FilterOperation.valueOf(filter.getOperation());
        HibernateQuery subquery = (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)reqVersionInit)).join((CollectionExpression)reqVersionInit.requirementVersionLinks, (Path)versionLink)).join((EntityPath)versionLink.linkType, (Path)versionType)).where((Predicate)reqVersionInit.id.eq((Expression)outerVersion.id).and((Predicate)versionLink.linkDirection.isFalse().and((Predicate)versionType.role2Code.in(values)).or((Predicate)versionLink.linkDirection.isTrue().and((Predicate)versionType.role1Code.in(values)))));
        if (FilterOperation.NONE.equals((Object)filterOperation)) {
            query.where((Predicate)subquery.notExists());
        } else {
            query.where((Predicate)subquery.exists());
        }
    }

    public static enum FilterOperation {
        NONE,
        AT_LEAST_ONE;

    }
}

