/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportHeader;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportMode;

public class CampaignExportRows {
    protected static final String DEFAULT_VALUE = "n/a";
    private static final String DEFAULT_VALUE_CUF = "";
    private final boolean milestonesEnabled;
    private final Map<String, String> valueByHeaderNameModel = new LinkedHashMap<String, String>();
    private final Map<String, CampaignExportHeader> headerModelMap = new LinkedHashMap<String, CampaignExportHeader>();
    private final Map<String, String> cufCodeByHeaderModel = new LinkedHashMap<String, String>();
    private Map<String, String> currentRow = null;

    public CampaignExportRows(CampaignExportMode mode, Map<BindableEntity, List<String>> cufCodesByBindableEntity, boolean milestonesEnabled) {
        this.milestonesEnabled = milestonesEnabled;
        this.createHeaderModel(mode, cufCodesByBindableEntity);
    }

    public Collection<String> getHeaderNames() {
        return this.valueByHeaderNameModel.keySet();
    }

    public CampaignExportHeader getHeaderColumn(String headerName) {
        return this.headerModelMap.get(headerName);
    }

    public String getCufCodeFromHeader(String headerName) {
        return this.cufCodeByHeaderModel.get(headerName);
    }

    private void createHeaderModel(CampaignExportMode mode, Map<BindableEntity, List<String>> cufCodesByBindableEntity) {
        CampaignExportHeader.getExportHeadersFromMode(mode, this.milestonesEnabled).forEach(headerColumns -> this.addHeaderColumnToModel((CampaignExportHeader)((Object)headerColumns), cufCodesByBindableEntity));
    }

    private void addHeaderColumnToModel(CampaignExportHeader headerColumn, Map<BindableEntity, List<String>> cufCodesByBindableEntity) {
        if (CampaignExportHeader.isCufHeader(headerColumn)) {
            this.addCufHeaders(headerColumn, cufCodesByBindableEntity);
            return;
        }
        String headerName = headerColumn.getHeaderName();
        this.valueByHeaderNameModel.put(headerName, DEFAULT_VALUE);
        this.headerModelMap.put(headerName, headerColumn);
    }

    private void addCufHeaders(CampaignExportHeader headerColumn, Map<BindableEntity, List<String>> cufCodesByBindableEntity) {
        BindableEntity bindableEntity = CampaignExportHeader.toBindableEntity(headerColumn);
        if (!cufCodesByBindableEntity.containsKey(bindableEntity)) {
            return;
        }
        cufCodesByBindableEntity.get(bindableEntity).forEach(code -> {
            String headerName = "%s%s".formatted(headerColumn.getHeaderName(), code);
            this.valueByHeaderNameModel.put(headerName, DEFAULT_VALUE_CUF);
            this.headerModelMap.put(headerName, headerColumn);
            this.cufCodeByHeaderModel.put(headerName, (String)code);
        });
    }

    private void addValue(String headerName, String value) {
        if (Objects.isNull(this.currentRow)) {
            this.currentRow = new LinkedHashMap<String, String>(this.valueByHeaderNameModel);
        }
        if (Objects.nonNull(value) && this.currentRow.containsKey(headerName) && !DEFAULT_VALUE.equals(value)) {
            this.currentRow.replace(headerName, value);
        }
    }

    private String valueToString(CampaignExportHeader headerColumn, Object rawValue) {
        if (Objects.isNull(rawValue)) {
            return headerColumn.getDefaultValue();
        }
        if (rawValue instanceof Date) {
            Date date = (Date)rawValue;
            return DateUtils.formatShortDate((Date)date);
        }
        if (rawValue instanceof Number) {
            Number number = (Number)rawValue;
            return this.valueToString(headerColumn, number);
        }
        return rawValue.toString().trim();
    }

    private String valueToString(CampaignExportHeader headerColumn, Number rawValue) {
        if (CampaignExportHeader.IT_NUM.equals((Object)headerColumn)) {
            return "%s".formatted(rawValue.intValue() + 1);
        }
        return rawValue.toString();
    }

    public void addValue(CampaignExportHeader header, String headerName, Object rawValue) {
        String value = this.valueToString(header, rawValue);
        this.addValue(headerName, value);
    }

    public Map<String, String> getRow() {
        LinkedHashMap<String, String> row;
        if (Objects.isNull(this.currentRow)) {
            row = new LinkedHashMap<String, String>(this.valueByHeaderNameModel);
        } else {
            row = new LinkedHashMap<String, String>(this.currentRow);
            this.currentRow = null;
        }
        return row;
    }
}

