/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.project;

import jakarta.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.project.AdministrableProject;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.project.ProjectVisitor;
import org.squashtest.tm.exception.library.CannotDeleteProjectException;
import org.squashtest.tm.service.internal.project.ProjectDeletionHandler;

@Component
@Scope(value="prototype")
public class GenericToAdministrableProject
implements ProjectVisitor {
    private AdministrableProject administrableProject;
    @Inject
    private ProjectDeletionHandler projectDeletionHandler;

    public AdministrableProject convertToAdministrableProject(GenericProject project) {
        project.accept((ProjectVisitor)this);
        return this.administrableProject;
    }

    public void visit(Project project) {
        this.administrableProject = new AdministrableProject((GenericProject)project);
        boolean isDeletable = true;
        try {
            this.projectDeletionHandler.checkProjectContainsOnlyFolders(project);
            this.projectDeletionHandler.checkProjectHasActivePlugin(project);
        }
        catch (CannotDeleteProjectException cannotDeleteProjectException) {
            isDeletable = false;
        }
        this.administrableProject.setDeletable(isDeletable);
        this.administrableProject.setTemplate(false);
    }

    public void visit(ProjectTemplate projectTemplate) {
        this.administrableProject = new AdministrableProject((GenericProject)projectTemplate);
        this.administrableProject.setDeletable(true);
        this.administrableProject.setTemplate(true);
    }
}

