/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.filemanagement.reader;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.squashtest.tm.exception.filemanagement.XmlParsingTimeoutException;

public class TimeoutXMLStreamReader
implements XMLStreamReader {
    private static final long CHECK_INTERVAL = 1000L;
    private final XMLStreamReader delegate;
    private final long startTime;
    private final long timeoutMs;
    private long operationCount = 0L;

    public TimeoutXMLStreamReader(XMLStreamReader delegate, long timeoutMs) {
        this.delegate = delegate;
        this.timeoutMs = timeoutMs;
        this.startTime = System.currentTimeMillis();
    }

    private void checkTimeout() {
        long elapsed;
        ++this.operationCount;
        if (this.operationCount % 1000L == 0L && (elapsed = System.currentTimeMillis() - this.startTime) > this.timeoutMs) {
            throw new XmlParsingTimeoutException(String.format("XML parsing timeout exceeded: %d ms (limit: %d ms).", elapsed, this.timeoutMs));
        }
    }

    @Override
    public int next() throws XMLStreamException {
        this.checkTimeout();
        return this.delegate.next();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        this.checkTimeout();
        return this.delegate.hasNext();
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.delegate.getElementText();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        return this.delegate.nextTag();
    }

    @Override
    public Object getProperty(String name) {
        return this.delegate.getProperty(name);
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this.delegate.require(type, namespaceURI, localName);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.delegate.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.delegate.isStartElement();
    }

    @Override
    public boolean isEndElement() {
        return this.delegate.isEndElement();
    }

    @Override
    public boolean isCharacters() {
        return this.delegate.isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.delegate.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.delegate.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public int getAttributeCount() {
        return this.delegate.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.delegate.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.delegate.getAttributeNamespace(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.delegate.getAttributeLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.delegate.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.delegate.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.delegate.getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.delegate.isAttributeSpecified(index);
    }

    @Override
    public int getNamespaceCount() {
        return this.delegate.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.delegate.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.delegate.getNamespaceURI(index);
    }

    @Override
    public Location getLocation() {
        return this.delegate.getLocation();
    }

    @Override
    public QName getName() {
        return this.delegate.getName();
    }

    @Override
    public String getLocalName() {
        return this.delegate.getLocalName();
    }

    @Override
    public boolean hasName() {
        return this.delegate.hasName();
    }

    @Override
    public String getNamespaceURI() {
        return this.delegate.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.delegate.getPrefix();
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public boolean isStandalone() {
        return this.delegate.isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        return this.delegate.standaloneSet();
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.delegate.getCharacterEncodingScheme();
    }

    @Override
    public String getPITarget() {
        return this.delegate.getPITarget();
    }

    @Override
    public String getPIData() {
        return this.delegate.getPIData();
    }

    @Override
    public int getEventType() {
        return this.delegate.getEventType();
    }

    @Override
    public String getText() {
        return this.delegate.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.delegate.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.delegate.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        return this.delegate.getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.delegate.getTextLength();
    }

    @Override
    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    @Override
    public boolean hasText() {
        return this.delegate.hasText();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }
}

