/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.filemanagement.reader;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.internal.filemanagement.reader.TimeoutXMLStreamReader;

@Component
public class ReaderFactoryProvider {
    private static final long DEFAULT_PARSING_TIMEOUT_MS = 300000L;

    public XMLStreamReader createXMLParser(InputStream inputStream) throws XMLStreamException {
        return this.createXMLParser(inputStream, 300000L);
    }

    public XMLStreamReader createXMLParser(InputStream inputStream, long timeoutMs) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        XMLStreamReader reader = factory.createXMLStreamReader(inputStream);
        return new TimeoutXMLStreamReader(reader, timeoutMs);
    }

    public Validator createValidator(String resourcePath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);){
                if (stream == null) {
                    throw new IllegalArgumentException("Schema resource not found: " + resourcePath);
                }
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = factory.newSchema(new StreamSource(stream));
                return schema.newValidator();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error accessing schema resource: " + resourcePath, e);
        }
    }
}

